/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ProposalComputer;
import org.openarchitectureware.expression.codeassist.ProposalFactory;
import org.openarchitectureware.xpand2.codeassist.XpandTokens;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordProposalComputer
implements ProposalComputer {
    private static final Pattern PREFIX = Pattern.compile("([A-Z]+)\\z");

    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        String prefix = this.getPrefix(txt);
        ArrayList<Object> result = new ArrayList<Object>();
        if (prefix.length() > 0) {
            String[] kw = XpandTokens.ALLKEYWORDS;
            int i = 0;
            while (i < kw.length) {
                String string = kw[i];
                if (string.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(factory.createKeywordProposal(String.valueOf(string) + this.getInsertionSuffix(string), string, prefix));
                }
                ++i;
            }
        }
        return result;
    }

    private String getPrefix(String txt) {
        Matcher m = PREFIX.matcher(txt);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private String getInsertionSuffix(String keyword) {
        if (keyword.startsWith("END") || "REM".equals(keyword)) {
            return "\u00bb";
        }
        return " ";
    }
}

