/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.output;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;
import org.openarchitectureware.xpand2.output.FileHandle;
import org.openarchitectureware.xpand2.output.PostProcessor;

public class JavaBeautifier
implements PostProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private CodeFormatter codeFormatter;
    private String configFile;
    private Properties options;

    public void beforeWriteAndClose(FileHandle info) {
        if (info.getTargetFile() != null && info.getTargetFile().getAbsolutePath().endsWith(".java")) {
            Document doc = new Document(info.getBuffer().toString());
            TextEdit edit = this.getCodeFormatter().format(8, doc.get(), 0, doc.get().length(), 0, null);
            if (edit != null) {
                try {
                    edit.apply((IDocument)doc);
                    info.setBuffer(new StringBuffer(doc.get()));
                }
                catch (MalformedTreeException e) {
                    this.log.warn((Object)("Error during code formatting. Illegal code edit tree (" + e.getMessage() + ")."));
                }
                catch (BadLocationException e) {
                    this.log.warn((Object)("Error during code formatting. Bad location (" + e.getMessage() + ")."));
                }
            } else {
                this.log.warn((Object)("File " + info.getTargetFile() + " could not be formatted. Make sure your template produces legal Java code!"));
            }
        }
    }

    private CodeFormatter getCodeFormatter() {
        if (this.codeFormatter == null) {
            if (this.configFile == null) {
                this.options = new Properties();
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                this.log.debug((Object)"no config file specified; using the default config file supplied with oAW: org.eclipse.jdt.core.formatterprefs");
            } else {
                this.options = this.readConfig(this.configFile);
            }
            this.codeFormatter = ToolFactory.createCodeFormatter((Map)this.options);
        }
        return this.codeFormatter;
    }

    /*
     * Loose catch block
     */
    private Properties readConfig(String filename) {
        Properties properties;
        BufferedReader reader;
        BufferedInputStream stream;
        block27: {
            stream = null;
            reader = null;
            InputStream is = this.openStream(filename);
            Properties formatterOptions = new Properties();
            if (filename.endsWith(".xml")) {
                Pattern pattern = Pattern.compile("<setting id=\"([^\"]*)\" value=\"([^\"]*)\"\\/>");
                reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                while (line != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (matcher.matches()) {
                        formatterOptions.put(matcher.group(1), matcher.group(2));
                    }
                    line = reader.readLine();
                }
            } else {
                stream = new BufferedInputStream(is);
                formatterOptions.load(stream);
            }
            if (formatterOptions.get("org.eclipse.jdt.core.compiler.compliance") == null) {
                formatterOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            }
            if (formatterOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform") == null) {
                formatterOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            }
            if (formatterOptions.get("org.eclipse.jdt.core.compiler.source") == null) {
                formatterOptions.put("org.eclipse.jdt.core.compiler.source", "1.5");
            }
            properties = formatterOptions;
            if (stream == null) break block27;
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
        catch (IOException e) {
            block28: {
                try {
                    this.log.warn((Object)("Problem reading code formatter config file (" + e.getMessage() + ")."));
                    if (stream == null) break block28;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected InputStream openStream(String filename) throws IOException {
        InputStream is = ResourceLoaderFactory.createResourceLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IOException("Config file [" + filename + "] does not exist.");
        }
        return is;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void afterClose(FileHandle impl) {
    }
}

