/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.openorb.compiler.Configurator;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlParser;

public class IdlCompiler {
    public static final String tab = "    ";
    public static Vector includeList = new Vector();
    public static Hashtable definedMacros = new Hashtable();
    public static Vector importLink = new Vector();
    public static Vector nativeDefinition = new Vector();
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static boolean map_stub;
    public static boolean local_stub;
    public static boolean map_skeleton;
    public static boolean map_all;
    public static boolean map_tie;
    public static boolean map_user;
    public static boolean pidl;
    public static boolean map_poa;
    public static boolean verbose;
    public static String packageName;
    public static boolean use_package;
    public static boolean portableHelper;
    public static String outdir;
    public static boolean dynamic;
    public static boolean usePrefix;
    public static boolean silentMode;
    public static boolean displayBadFlag;
    public static boolean reversePrefix;
    public static boolean useReflection;
    public static boolean useSwitch;
    public static boolean useClasses;
    public static boolean jdk1_4;
    public static int minTableSize;
    public static String generateValueFactory;
    public static String generateValueImpl;

    public static void display_help() {
        System.out.println("");
        System.out.println("");
        System.out.println("---------------------------------------------------------------");
        System.out.println("OpenORB                                                        ");
        System.out.println("(c) 2002 The Community OpenORB");
        System.out.println("IDL To Java Compiler                                           ");
        System.out.println("---------------------------------------------------------------");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate mapping for included files.");
        System.out.println("\t-boa");
        System.out.println("\t\tGenerate skeleton for BOA.");
        System.out.println("\t-d directory_name");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the 'generated' directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -d /home/me/");
        System.out.println("\t-dynamic");
        System.out.println("\t\tGenerate stub with DII and skeleton with DSI");
        System.out.println("\t\t( portable way before CORBA 2.3 ).");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbol. It is equivalent to #define.");
        System.out.println("\t-importLink link");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  org.openorb.compiler.IdlCompiler demo.idl -I /home/me/idl -I ../other");
        System.out.println("\t-native native_name native_mapping");
        System.out.println("\t\tDefine native type mapping.");
        System.out.println("\t\tFor example : ");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -native cookie java.lang.Object");
        System.out.println("\t\t this command implies the mapping of");
        System.out.println("\t\t cookie in java.lang.Object.");
        System.out.println("\t-nolocalstub");
        System.out.println("\t\tGenerate stubs without local invocation path.");
        System.out.println("\t-noprefix");
        System.out.println("\t\tDon't use prefixes as packages names.");
        System.out.println("\t-noreverseprefix");
        System.out.println("\t\tThe prefixes are used as package name but they are not reversed.");
        System.out.println("\t-noskeleton");
        System.out.println("\t\tDon't generate skeleton.");
        System.out.println("\t-nostub");
        System.out.println("\t\tDon't generate stub.");
        System.out.println("\t-notie");
        System.out.println("\t\tDon't generate TIE classes for delegation mode.");
        System.out.println("\t-package package_name");
        System.out.println("\t\tGenerate files in package_name.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -package exemple");
        System.out.println("\t-pidl");
        System.out.println("\t-portablehelper");
        System.out.println("\t\tGenerate portable helper classes. Nonportable helpers must be");
        System.out.println("\t\tcompiled using OpenORB, but the generated class files will work");
        System.out.println("\t\tanywhere. Portable helpers can be compiled anywhere and will");
        System.out.println("\t\twork identically on all orbs with Any.extract_Streamable.");
        System.out.println("\t-quiet");
        System.out.println("\t\tSuppress any output. Same as -silence.");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number.");
        System.out.println("\t-silence");
        System.out.println("\t\tSuppress any output. Same as -quiet.");
        System.out.println("\t-verbose");
        System.out.println("\t\tShow debug output.");
        System.out.println("\t-jdk1.4");
        System.out.println("\t\tGenerate classes that use JDK1.4 features.");
        System.out.println("\t\tThe generate classes will not compile on previous versions.");
        System.out.println("\t-invokeMethod <Classes|Reflection|Switch>");
        System.out.println("\t\tThe method used to implement the xxxPOA invoke method.");
        System.out.println("\t\tIf not specified Classes is used.");
        System.out.println("\t-minTableSize <size>");
        System.out.println("\t\tThe minimum size of method table.");
        System.out.println("\t-XgenerateValueFactory <impl postfix>");
        System.out.println("\t\tGenerate default value factories for valuetypes.");
        System.out.println("\t\tCreates instance of <valuetype name><impl postfix>.");
        System.out.println("\t-XgenerateValueImpl <postfix>");
        System.out.println("\t\tGeneratae default implementation of valuetypes.");
        System.out.println("\t\tCreates classes with name <valuetype name><postfix>.");
        System.out.println("");
        System.out.println("");
        System.exit(1);
    }

    public static void scan_arguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            block90: {
                if (args[i].charAt(0) != '-') {
                    idl_file_name_list.addElement(args[i]);
                } else if (args[i].equals("-release")) {
                    System.out.println("OpenORB Version 1.3.0");
                    System.exit(1);
                } else if (args[i].equals("-h") || args[i].equals("-help")) {
                    IdlCompiler.display_help();
                } else if (args[i].equals("-silence") || args[i].equals("-quiet")) {
                    silentMode = true;
                } else if (args[i].equals("-verbose")) {
                    verbose = true;
                } else if (args[i].equals("-noprefix")) {
                    usePrefix = false;
                } else if (args[i].equals("-noreverseprefix")) {
                    reversePrefix = false;
                } else if (args[i].equals("-nostub")) {
                    map_stub = false;
                } else if (args[i].equals("-nolocalstub")) {
                    local_stub = false;
                } else if (args[i].equals("-noskeleton")) {
                    map_skeleton = false;
                } else if (args[i].equals("-notie")) {
                    map_tie = false;
                } else if (args[i].equals("-portablehelper")) {
                    portableHelper = true;
                } else if (args[i].equals("-boa")) {
                    map_poa = false;
                } else if (args[i].equals("-dynamic")) {
                    dynamic = true;
                } else if (args[i].equals("-all")) {
                    map_all = true;
                } else if (args[i].equals("-pidl")) {
                    pidl = true;
                    map_stub = false;
                    map_skeleton = false;
                    map_tie = false;
                } else if ("-jdk1.4".equals(args[i])) {
                    jdk1_4 = true;
                } else if ("-XgenerateValueFactory".equals(args[i])) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-XgenerateValueFactory'");
                        System.exit(2);
                    }
                    generateValueFactory = args[++i];
                } else if ("-XgenerateValueImpl".equals(args[i])) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-XgenerateValueImpl'");
                        System.exit(2);
                    }
                    generateValueImpl = args[++i];
                } else if ("-invokeMethod".equals(args[i])) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-invokeMethod'");
                        System.exit(2);
                    }
                    useReflection = false;
                    useSwitch = false;
                    useClasses = false;
                    if ("Classes".equals(args[++i])) {
                        useClasses = true;
                    } else if ("Reflection".equals(args[i])) {
                        useReflection = true;
                    } else if ("Switch".equals(args[i])) {
                        useSwitch = true;
                    } else {
                        System.out.println("'-invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'");
                        System.exit(2);
                    }
                } else if ("-minTableSize".equals(args[i])) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-minTableSize'");
                        System.exit(2);
                    }
                    minTableSize = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-package")) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-package'");
                        System.exit(2);
                    }
                    packageName = args[++i];
                    use_package = false;
                } else if (args[i].equals("-importlink")) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-importlink'");
                        System.exit(2);
                    }
                    importLink.addElement(args[++i]);
                } else if (args[i].equals("-d")) {
                    if (i + 1 == args.length) {
                        System.out.println("Argument expected after '-d'");
                        System.exit(2);
                    }
                    outdir = args[++i];
                    if (packageName == null) {
                        packageName = "";
                        use_package = false;
                    }
                } else if (args[i].equals("-I")) {
                    if (++i == args.length) {
                        System.out.println("Argument expected after '-I'");
                        System.exit(2);
                    }
                    URL url = null;
                    try {
                        url = new URL(args[i]);
                    }
                    catch (MalformedURLException ex) {
                        try {
                            url = new File(args[i]).toURL();
                        }
                        catch (MalformedURLException ex1) {
                            // empty catch block
                        }
                    }
                    if (url != null) {
                        includeList.addElement(url);
                    }
                } else if (args[i].startsWith("-I")) {
                    String path = args[i].substring(2);
                    URL url = null;
                    try {
                        url = new URL(path);
                    }
                    catch (MalformedURLException ex) {
                        try {
                            url = new File(path).toURL();
                        }
                        catch (MalformedURLException ex1) {
                            // empty catch block
                        }
                    }
                    if (url != null) {
                        includeList.addElement(url);
                    }
                } else if (args[i].startsWith("-D")) {
                    try {
                        int idx = args[i].indexOf(61);
                        if (idx < 0) {
                            definedMacros.put(args[i].substring(2, args[i].length()), "");
                            break block90;
                        }
                        definedMacros.put(args[i].substring(2, idx), args[i].substring(idx + 1));
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].equals("-native")) {
                    if (i + 2 == args.length) {
                        System.out.println("Argument expected after '-native'");
                        System.exit(2);
                    }
                    nativeDefinition.addElement(args[++i] + ":" + args[++i]);
                } else if (displayBadFlag) {
                    System.out.println("Bad parameter : " + args[i]);
                    System.out.println("Please, use no flag to display all compiler option flags");
                    System.exit(2);
                }
            }
            ++i;
        }
        if (outdir == null || outdir.equals("")) {
            outdir = new String("generated");
            if (packageName == null) {
                packageName = "";
                use_package = false;
            }
        }
        idl_file_name = new String[idl_file_name_list.size()];
        int i2 = 0;
        while (i2 < idl_file_name_list.size()) {
            IdlCompiler.idl_file_name[i2] = (String)idl_file_name_list.elementAt(i2);
            ++i2;
        }
    }

    public static void configFile() {
        Configurator config = null;
        try {
            Object obj = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.compiler.orb.DefaultConfigurator").newInstance();
            config = (Configurator)obj;
        }
        catch (Exception ex) {
            return;
        }
        config.updateInfo(includeList, importLink);
    }

    public static void prepare() {
        definedMacros.put("__IDL_TO_JAVA__", "");
        definedMacros.put("__OPENORB__", "OpenORB Version 1.3.0");
        definedMacros.put("__OPENORB_MAJOR__", "1");
        definedMacros.put("__OPENORB_MINOR__", "3");
        definedMacros.put("__OPENORB_MINOR_CHANGE__", "0");
        definedMacros.put("__CORBA_IDL__", "2.4");
        definedMacros.put("__CORBA_MAJOR__", "2");
        definedMacros.put("__CORBA_MINOR__", "4");
        definedMacros.put("__CORBA_MINOR_CHANGE__", "2.4.2");
    }

    public static void compile_file(String file_name, IdlParser Parser) throws CompilationException {
        IdlObject CompilationGraph = Parser.compile_idl(file_name);
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(2);
        }
        if (verbose) {
            System.out.println("Now translate to Java...");
        }
        IdlToJava toJava = new IdlToJava();
        toJava.translateData(CompilationGraph, packageName);
        if (map_stub) {
            toJava.translateStub(CompilationGraph, packageName);
        }
        if (map_skeleton) {
            toJava.translateSkeleton(CompilationGraph, packageName);
        }
        if (map_tie) {
            toJava.translateTIE(CompilationGraph, packageName);
        }
    }

    public static IdlParser createIDLParser(String[] args) {
        IdlCompiler.prepare();
        IdlCompiler.scan_arguments(args);
        IdlCompiler.configFile();
        return new IdlParser();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            IdlCompiler.display_help();
        }
        IdlParser Parser = IdlCompiler.createIDLParser(args);
        if (idl_file_name.length == 0) {
            IdlCompiler.display_help();
        }
        if (!silentMode) {
            System.out.println("OpenORB  IDL To Java Compiler / (c) 2002 The Community OpenORB");
        }
        try {
            Hashtable definedCopy = (Hashtable)definedMacros.clone();
            int i = 0;
            while (i < idl_file_name.length) {
                definedMacros = definedCopy;
                if (!silentMode) {
                    System.out.println("compile : " + idl_file_name[i]);
                }
                IdlCompiler.compile_file(idl_file_name[i], Parser);
                ++i;
            }
        }
        catch (CompilationException ex) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(2);
        }
    }

    static {
        idl_file_name_list = new Vector();
        map_stub = true;
        local_stub = true;
        map_skeleton = true;
        map_all = false;
        map_tie = true;
        map_user = false;
        pidl = false;
        map_poa = true;
        verbose = false;
        packageName = null;
        use_package = false;
        portableHelper = false;
        outdir = null;
        dynamic = false;
        usePrefix = true;
        silentMode = false;
        displayBadFlag = true;
        reversePrefix = true;
        useClasses = true;
        minTableSize = 9;
    }
}

