/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.doc.html.IdlToHTML;
import org.openorb.compiler.doc.rtf.IdlToRTF;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.IdlParser;

public class IdlDoc {
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static String packageName;
    public static boolean use_package;
    public static String outdir;
    public static boolean stylesheet;
    public static boolean htmlDoc;
    public static String title;
    public static String header;
    public static String footer;
    public static String filename;
    public static String codepage;
    public static boolean usePrefix;

    public static void printUsage() {
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################");
        System.out.println("#                    OpenORB                    #");
        System.out.println("#                -----------------              #");
        System.out.println("#         (c) 2002 The Community OpenORB        #");
        System.out.println("#################################################");
        System.out.println("# Java Doc Compiler, Release 1.0                #");
        System.out.println("#################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number");
        System.out.println("\t-html");
        System.out.println("\t\tCreate HTML output");
        System.out.println("\t-outdir:");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the corba_pkg directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t idl2doc demo.idl -outdir:/home/me/");
        System.out.println("\t-nopackage");
        System.out.println("\t\tDon't use a package name");
        System.out.println("\t-package: package_name");
        System.out.println("\t\tGenerate files in package_name");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl demo.idl -package:exemple");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  idl demo.idl -I/home/me/idl -I../autre");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbole. It is equivalent to #define");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate documentation for included files.");
        System.out.println("\t-stylesheet ( for HTML documentation only )");
        System.out.println("\t\tGenerate a style sheet for HTML documentation.");
        System.out.println("\t-title:");
        System.out.println("\t\tSet the documentation title.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2html demo.idl \"-title:My Doc Title\"");
        System.out.println("\t-codepage:");
        System.out.println("\t\tSet the codepage for the generated html files.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2html demo.idl -codepage:ISO-8859-5");
        System.out.println("\t-noprefix");
        System.out.println("\t\t Disable usage of prefix for package name.");
        System.out.println("\t-header ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation header.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl \"-header:My Doc header\"");
        System.out.println("\t-footer ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation footer.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl \"-footer:My Doc footer\"");
        System.out.println("\t-docname:");
        System.out.println("\t\tSet the documentation file name for RTF documentation.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl -docname:mydoc.rtf");
        System.out.println("\t-codepage:");
        System.out.println("\t\tSet the codepage for the generated files.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl -docname:mydoc.rtf");
        System.out.println("");
        System.out.println("");
        System.exit(0);
    }

    public static void analyse_arguments(String[] args) {
        IdlCompiler.includeList = new Vector();
        IdlCompiler.definedMacros = new Hashtable();
        int i = 0;
        while (i < args.length) {
            block65: {
                if (args[i].charAt(0) != '-') {
                    idl_file_name_list.addElement(args[i]);
                } else if (args[i].equals("-release")) {
                    System.out.println("1.3.0");
                    System.exit(0);
                } else if (args[i].equals("-h")) {
                    IdlDoc.printUsage();
                } else if (args[i].equals("-html")) {
                    htmlDoc = true;
                } else if (args[i].equals("-help")) {
                    IdlDoc.printUsage();
                } else if (args[i].equals("-nopackage")) {
                    use_package = false;
                } else if (args[i].equals("-noprefix")) {
                    usePrefix = false;
                } else if (args[i].equals("-stylesheet")) {
                    stylesheet = true;
                } else if (args[i].equals("-all")) {
                    IdlCompiler.map_all = true;
                } else if (args[i].startsWith("-package:")) {
                    try {
                        packageName = args[i].substring(9, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (packageName.equals("")) {
                        System.out.println("Package name cannot be empty...");
                        System.exit(0);
                    }
                } else if (args[i].startsWith("-title:")) {
                    try {
                        title = args[i].substring(7, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-header:")) {
                    try {
                        header = args[i].substring(7, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-footer:")) {
                    try {
                        footer = args[i].substring(7, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-docname:")) {
                    try {
                        filename = args[i].substring(9, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-outdir:")) {
                    try {
                        outdir = args[i].substring(8, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                    if (packageName == null) {
                        packageName = "";
                        use_package = false;
                    }
                } else if (args[i].startsWith("-codepage:")) {
                    try {
                        codepage = args[i].substring(10, args[i].length());
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-I")) {
                    try {
                        String name = args[i].substring(2, args[i].length());
                        URL url = null;
                        try {
                            url = new URL(name);
                        }
                        catch (MalformedURLException ex) {
                            try {
                                url = new File(name).toURL();
                            }
                            catch (MalformedURLException ex1) {
                                // empty catch block
                            }
                        }
                        if (url != null) {
                            IdlCompiler.includeList.addElement(url);
                        }
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else if (args[i].startsWith("-D")) {
                    try {
                        int idx = args[i].indexOf(61);
                        if (idx < 0) {
                            IdlCompiler.definedMacros.put(args[i].substring(2, args[i].length()), "");
                            break block65;
                        }
                        IdlCompiler.definedMacros.put(args[i].substring(2, idx), args[i].substring(idx + 1));
                    }
                    catch (StringIndexOutOfBoundsException ex) {}
                } else {
                    System.out.println("Bad parameter");
                    System.out.println("Please, use no flag to display all compiler option flags");
                    System.exit(0);
                }
            }
            ++i;
        }
        if (packageName == null) {
            packageName = new String("corba_pkg");
        }
        IdlCompiler.packageName = packageName;
        idl_file_name = new String[idl_file_name_list.size()];
        int i2 = 0;
        while (i2 < idl_file_name_list.size()) {
            IdlDoc.idl_file_name[i2] = (String)idl_file_name_list.elementAt(i2);
            ++i2;
        }
    }

    public static void main(String[] args) {
        IdlParser Parser = null;
        idl_file_name_list = new Vector();
        if (args.length != 0) {
            IdlDoc.analyse_arguments(args);
        } else {
            IdlDoc.printUsage();
        }
        IdlCompiler.idl_file_name = idl_file_name;
        if (idl_file_name.length == 0) {
            IdlDoc.printUsage();
        }
        Parser = new IdlParser();
        System.out.println("OpenORB Doc generator");
        IdlObject CompilationGraph = null;
        int i = 0;
        while (i < idl_file_name.length) {
            CompilationGraph = Parser.compile_idl(idl_file_name[i]);
            ++i;
        }
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(0);
        }
        if (htmlDoc) {
            System.out.println("IDL To HTML");
            IdlToHTML toHTML = new IdlToHTML();
            toHTML.translateToHTML(CompilationGraph, title, packageName);
        } else {
            System.out.println("IDL To RTF");
            IdlToRTF toRTF = new IdlToRTF();
            if (filename == null) {
                System.out.println("IDL to RTF fatal error : you must specify an file name for the RTF documentation with '-docname:' flag.");
                System.exit(0);
            }
            toRTF.translateToRTF(CompilationGraph, filename, title, header, footer);
        }
    }

    static {
        packageName = null;
        use_package = true;
        outdir = null;
        stylesheet = false;
        htmlDoc = false;
        title = "IDL Documentation";
        header = "";
        footer = "";
        filename = "";
        codepage = "ISO-8859-1";
        usePrefix = true;
    }
}

