/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.idl.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.idl.reflect.idlIdentifier;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlObject;

public class tools {
    public static final String tab = "    ";
    protected static IdlToJava generator = new IdlToJava();

    public static PrintWriter createNewFile(File into, String name) {
        PrintWriter printout = null;
        String path = new String(into.getPath() + File.separator + name + ".java");
        File file = new File(path);
        try {
            FileOutputStream output = new FileOutputStream(file);
            DataOutputStream dataout = new DataOutputStream(output);
            printout = new PrintWriter(dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printout;
    }

    public static void writePackageName(PrintWriter writer, idlObject obj) {
        if (obj.idlDefinedIn() != null) {
            writer.println("package " + tools.fullname(obj.idlDefinedIn()) + ";");
        }
    }

    public static String javaName(idlObject obj) {
        if (obj.idlType() == 12) {
            return tools.fullname(((idlIdentifier)obj).original());
        }
        return tools.fullname(obj);
    }

    private static String fullname(idlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = (IdlObject)obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            if (first) {
                if (obj2.kind() == 15 || obj2.kind() == 28 || obj2.kind() == 3 || obj2.kind() == 4 || obj2.kind() == 14) {
                    v.addElement(obj2.name() + "Package");
                } else {
                    v.addElement(obj2.name());
                }
            } else {
                v.addElement(obj2.name());
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (!(IdlCompiler.packageName == null || obj.included() || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("generated") && !IdlCompiler.use_package)) {
            name = tools.adaptToDot(IdlCompiler.packageName);
        }
        if (IdlCompiler.usePrefix && ((IdlObject)obj).getPrefix() != null) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + tools.inversedPrefix(((IdlObject)obj).getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public static String adaptToDot(String path) {
        char[] tmp = new char[path.length()];
        int i = 0;
        while (i < path.length()) {
            tmp[i] = path.charAt(i) == '/' || path.charAt(i) == '\\' ? 46 : path.charAt(i);
            ++i;
        }
        return new String(tmp);
    }

    public static String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    public static void javaType(idlObject obj, PrintWriter output) {
        if (obj.idlType() == 12) {
            generator.translate_type((IdlObject)((idlIdentifier)obj).original(), output);
            return;
        }
        generator.translate_type((IdlObject)obj, output);
    }

    public static void marshal(idlObject obj, PrintWriter output, String streamName, String typeName) {
        generator.translate_marshalling_member((IdlObject)obj, output, streamName, typeName, "        ");
    }

    public static void unmarshal(idlObject obj, PrintWriter output, String streamName, String typeName) {
        generator.translate_unmarshalling_member((IdlObject)obj, output, streamName, typeName, "        ");
    }

    public static void translate_comment_section(PrintWriter output, String description, IdlObject obj) {
        tools.translate_comment_section_base(output, description, obj);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void translate_comment_section_base(PrintWriter output, String description, IdlObject obj) {
        int i = 0;
        while (i < description.length()) {
            if (description.charAt(i) == '\n') {
                if (i == description.length() - 1) {
                    output.println("");
                    return;
                }
                output.println("");
                if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                    output.print(tab);
                }
                output.print(" * ");
            } else {
                output.print(description.charAt(i));
            }
            ++i;
        }
    }

    public static void javadoc(PrintWriter output, IdlObject obj) {
        tools.javadoc_base(output, obj);
    }

    public static void javadoc_base(PrintWriter output, IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null) {
            description = comment.get_description();
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.println("/**");
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.print(" * ");
            tools.translate_comment_section(output, description, obj);
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                switch (sections[i].kind().value()) {
                    case 0: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (obj.kind() == 17 || obj.kind() == 16) {
                            output.print(tab);
                        }
                        output.print(" * @" + sections[i].get_title() + " ");
                    }
                }
                description = sections[i].get_description();
                tools.translate_comment_section(output, description, obj);
                ++i;
            }
            if (obj.kind() == 17 || obj.kind() == 16 || obj.kind() == 29) {
                output.print(tab);
            }
            output.println(" */");
        }
    }
}

