/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class ArrayOfIntSupport
extends PropertyEditorSupport
implements XMLPropertyEditor {
    private static final String VALUE_FORMAT = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$ArrayOfIntSupport == null ? (class$org$netbeans$beaninfo$editors$ArrayOfIntSupport = ArrayOfIntSupport.class$("org.netbeans.beaninfo.editors.ArrayOfIntSupport")) : class$org$netbeans$beaninfo$editors$ArrayOfIntSupport)).getString("EXC_BadFormatValue");
    private int count;
    private String className;
    public static final String ATTR_VALUE = "value";
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$ArrayOfIntSupport;

    public ArrayOfIntSupport(String className, int count) {
        this.className = className;
        this.count = count;
    }

    public String getJavaInitializationString() {
        int[] val = this.getValues();
        StringBuffer buf = new StringBuffer("new ");
        buf.append(this.className);
        buf.append("(");
        this.addArray(buf, val);
        buf.append(")");
        return buf.toString();
    }

    abstract int[] getValues();

    abstract void setValues(int[] var1);

    public String getAsText() {
        if (this.getValue() == null) {
            return "null";
        }
        int[] val = this.getValues();
        if (val == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("[");
        this.addArray(buf, val);
        buf.append("]");
        return buf.toString();
    }

    private void addArray(StringBuffer buf, int[] arr) {
        int i = 0;
        while (i < this.count) {
            if (arr == null) {
                buf.append("0");
            } else {
                buf.append(arr[i]);
            }
            if (i < this.count - 1) {
                buf.append(", ");
            }
            ++i;
        }
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.equals("null") || text.equals("")) {
            this.setValue(null);
            return;
        }
        int[] newVal = new int[this.count];
        int nextNumber = 0;
        StringTokenizer tuk = new StringTokenizer(text, "[] ,;", false);
        while (tuk.hasMoreTokens()) {
            String token = tuk.nextToken();
            if (nextNumber >= this.count) {
                this.badFormat();
            }
            try {
                newVal[nextNumber] = new Integer(token);
                ++nextNumber;
            }
            catch (NumberFormatException e) {
                this.badFormat();
            }
        }
        if (nextNumber != this.count && nextNumber > 0) {
            int copyValue = newVal[nextNumber - 1];
            int i = nextNumber;
            while (i < this.count) {
                newVal[i] = copyValue;
                ++i;
            }
        }
        this.setValues(newVal);
    }

    private void badFormat() throws IllegalArgumentException {
        throw new IllegalArgumentException(new MessageFormat(VALUE_FORMAT).format(new Object[]{this.className, this.getHintFormat()}));
    }

    String getHintFormat() {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < this.count) {
            buf.append("<n");
            buf.append(i);
            buf.append(">");
            if (i < this.count - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    protected abstract String getXMLValueTag();

    public void readFromXML(Node element) throws IOException {
        if (!this.getXMLValueTag().equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String value = attributes.getNamedItem(ATTR_VALUE).getNodeValue();
            this.setAsText(value);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(this.getXMLValueTag());
        el.setAttribute(ATTR_VALUE, this.getAsText());
        return el;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

