/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.JarAndZipFilter;
import org.netbeans.beaninfo.editors.FileEditor;
import org.netbeans.core.ExJarFileSystem;
import org.netbeans.core.ExLocalFileSystem;
import org.netbeans.core.ModuleFSSection;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.NewType;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemPanel
extends TopComponent
implements EnhancedCustomPropertyEditor {
    private NewType[] newTypes;
    private String[] newTypeNames;
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private FileSystem originalFS;
    private LocalFileSystem localFS;
    private JarFileSystem jarFS;
    private FileSystem otherFS;
    private FileSystem fs;
    private Node activeNode;
    private Node originalNode;
    private Node localFSNode;
    private Node jarFSNode;
    private Node otherNode;
    private Node emptyNode;
    private ButtonGroup group;
    private JRadioButton originalRadioButton;
    private JRadioButton dirRadioButton;
    private JLabel dirLabel;
    private JTextField dirTextField;
    private JButton browseDirButton;
    private JRadioButton jarRadioButton;
    private JLabel jarLabel;
    private JTextField jarTextField;
    private JButton browseJarButton;
    private JRadioButton otherRadioButton;
    private JLabel createLabel;
    private JComboBox typeComboBox;
    private PropertySheet propertySheet1;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FileSystemPanel;

    public FileSystemPanel() {
        this.initComponents();
        this.initialize();
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.originalRadioButton = new JRadioButton();
        this.dirRadioButton = new JRadioButton();
        this.dirLabel = new JLabel();
        this.dirTextField = new JTextField();
        this.browseDirButton = new JButton();
        this.jarRadioButton = new JRadioButton();
        this.jarLabel = new JLabel();
        this.jarTextField = new JTextField();
        this.browseJarButton = new JButton();
        this.otherRadioButton = new JRadioButton();
        this.createLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.propertySheet1 = new PropertySheet();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        ((JComponent)((Object)this)).setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.Border_Title")), new EmptyBorder(new Insets(8, 8, 8, 8))));
        this.originalRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.originalRadioButton.text"));
        this.originalRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FileSystemPanel.this.originalRadioButtonItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        ((Container)((Object)this)).add(this.originalRadioButton, gridBagConstraints1);
        this.dirRadioButton.setSelected(true);
        this.dirRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.dirRadioButton.text"));
        this.dirRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FileSystemPanel.this.dirRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        ((Container)((Object)this)).add(this.dirRadioButton, gridBagConstraints1);
        this.dirLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.dirLabel.text"));
        this.dirLabel.setLabelFor(this.dirTextField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints1.anchor = 17;
        ((Container)((Object)this)).add(this.dirLabel, gridBagConstraints1);
        this.dirTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FileSystemPanel.this.dirTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        ((Container)((Object)this)).add(this.dirTextField, gridBagConstraints1);
        this.browseDirButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browseDirButton.text"));
        this.browseDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSystemPanel.this.browseDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        ((Container)((Object)this)).add(this.browseDirButton, gridBagConstraints1);
        this.jarRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.jarRadioButton.text"));
        this.jarRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FileSystemPanel.this.jarRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        ((Container)((Object)this)).add(this.jarRadioButton, gridBagConstraints1);
        this.jarLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.jarLabel.text"));
        this.jarLabel.setLabelFor(this.jarTextField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints1.anchor = 17;
        ((Container)((Object)this)).add(this.jarLabel, gridBagConstraints1);
        this.jarTextField.setEnabled(false);
        this.jarTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FileSystemPanel.this.jarTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        ((Container)((Object)this)).add(this.jarTextField, gridBagConstraints1);
        this.browseJarButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browseJarButton.hint"));
        this.browseJarButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browseJarButton.text"));
        this.browseJarButton.setEnabled(false);
        this.browseJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSystemPanel.this.browseJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints1.anchor = 17;
        ((Container)((Object)this)).add(this.browseJarButton, gridBagConstraints1);
        this.otherRadioButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.otherRadioButton.text"));
        this.otherRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FileSystemPanel.this.otherRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        ((Container)((Object)this)).add(this.otherRadioButton, gridBagConstraints1);
        this.createLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.createLabel.text"));
        this.createLabel.setLabelFor(this.typeComboBox);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        ((Container)((Object)this)).add(this.createLabel, gridBagConstraints1);
        this.typeComboBox.setPreferredSize(new Dimension(200, 25));
        this.typeComboBox.setMinimumSize(new Dimension(200, 25));
        this.typeComboBox.setEnabled(false);
        this.typeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                FileSystemPanel.this.typeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.8;
        ((Container)((Object)this)).add(this.typeComboBox, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(24, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.propertySheet1, gridBagConstraints1);
    }

    private void jarTextFieldFocusLost(FocusEvent evt) {
        File f = new File(this.jarTextField.getText());
        if (f != null && !f.exists()) {
            if (this.jarFS != null) {
                this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
            } else {
                this.jarTextField.setText("");
            }
            return;
        }
        if (f != null && f.isFile()) {
            try {
                lastJarFolder = f.getParentFile();
                this.jarFS = new ExJarFileSystem();
                this.jarFS.setJarFile(f);
                this.createJarFSNode();
                this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
                this.jarTextField.setText(f.getAbsolutePath());
            }
            catch (IOException e) {
            }
            catch (PropertyVetoException ex) {
            }
            catch (IntrospectionException ex) {}
        } else if (this.jarFS != null) {
            this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
        } else {
            this.jarTextField.setText("");
        }
    }

    private void dirTextFieldFocusLost(FocusEvent evt) {
        File f = new File(this.dirTextField.getText());
        if (f != null && !f.exists()) {
            if (this.localFS != null) {
                this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
            } else {
                this.dirTextField.setText("");
            }
            return;
        }
        if (f != null && f.isDirectory()) {
            this.localFS = new ExLocalFileSystem();
            try {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                lastDirFolder = f;
                this.localFS.setRootDirectory(f);
                this.createLocalFSNode();
                this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
                this.dirTextField.setText(f.getAbsolutePath());
            }
            catch (IOException ex) {
            }
            catch (PropertyVetoException ex) {
            }
            catch (IntrospectionException ex) {}
        } else if (this.localFS != null) {
            this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
        } else {
            this.dirTextField.setText("");
        }
    }

    private void originalRadioButtonItemStateChanged(ItemEvent evt) {
        boolean selected = this.originalRadioButton.isSelected();
        if (selected) {
            if (this.originalNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.originalNode, this.originalFS);
            }
        }
    }

    private void browseJarButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = FileEditor.createHackedFileChooser();
        chooser.setDialogType(0);
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        chooser.setFileFilter(new JarAndZipFilter());
        if (lastJarFolder != null) {
            chooser.setCurrentDirectory(lastJarFolder);
        }
        chooser.setDialogTitle(FileSystemPanel.getString("CTL_FileSystemPanel.Jar_Dialog_Title"));
        while (Utilities.showJFileChooser((JFileChooser)chooser, (Component)WindowManager.getDefault().getMainWindow(), (String)FileSystemPanel.getString("CTL_FileSystemPanel.Approve_Button_Title")) == 0) {
            File f = chooser.getSelectedFile();
            if (f != null && f.isFile()) {
                try {
                    lastJarFolder = chooser.getCurrentDirectory();
                    this.jarFS = new ExJarFileSystem();
                    this.jarFS.setJarFile(f);
                    this.createJarFSNode();
                    this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
                    this.jarTextField.setText(f.getAbsolutePath());
                    return;
                }
                catch (IOException e) {
                }
                catch (PropertyVetoException ex) {
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FileSystemPanel.getString("MSG_WrongFileName")));
        }
    }

    private void browseDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = FileEditor.createHackedFileChooser();
        chooser.setDialogType(0);
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(FileSystemPanel.getString("CTL_FileSystemPanel.Local_Dialog_Title"));
        if (lastDirFolder != null) {
            chooser.setCurrentDirectory(lastDirFolder);
        }
        while (Utilities.showJFileChooser((JFileChooser)chooser, (Component)WindowManager.getDefault().getMainWindow(), (String)FileSystemPanel.getString("CTL_FileSystemPanel.Approve_Button_Title")) == 0) {
            File f = chooser.getSelectedFile();
            if (f != null && f.isDirectory()) {
                this.localFS = new ExLocalFileSystem();
                try {
                    lastDirFolder = chooser.getCurrentDirectory();
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ((ExLocalFileSystem)this.localFS).setRootDirectory(f);
                    this.createLocalFSNode();
                    this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
                    this.dirTextField.setText(f.getAbsolutePath());
                    return;
                }
                catch (IOException ex) {
                }
                catch (PropertyVetoException ex) {
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FileSystemPanel.getString("MSG_WrongFile")));
        }
    }

    private void jarRadioButtonItemStateChanged(ItemEvent evt) {
        boolean selected = this.jarRadioButton.isSelected();
        this.browseJarButton.setEnabled(selected);
        this.jarTextField.setEnabled(selected);
        if (selected) {
            if (this.jarFSNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.jarFSNode, (FileSystem)this.jarFS);
            }
        }
    }

    private void dirRadioButtonItemStateChanged(ItemEvent evt) {
        boolean selected = this.dirRadioButton.isSelected();
        this.browseDirButton.setEnabled(selected);
        this.dirTextField.setEnabled(selected);
        if (selected) {
            if (this.localFSNode == null) {
                this.setActiveFS(this.getEmptyNode(), null);
            } else {
                this.setActiveFS(this.localFSNode, (FileSystem)this.localFS);
            }
        }
    }

    private void typeComboBoxItemStateChanged(ItemEvent evt) {
        this.otherNode = this.createOtherNode();
        if (this.otherNode != null) {
            this.setActiveFS(this.otherNode, this.otherFS);
        }
    }

    private void otherRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.otherRadioButton.isSelected()) {
            this.typeComboBox.setEnabled(true);
            if (this.otherNode == null) {
                this.otherNode = this.createOtherNode();
            }
            if (this.otherNode != null) {
                this.setActiveFS(this.otherNode, this.otherFS);
            }
        } else {
            this.typeComboBox.setEnabled(false);
        }
    }

    private void selectExisting(ActionEvent evt) {
    }

    private void setActiveFS(Node n, FileSystem f) {
        this.fs = f;
        this.activeNode = n;
        this.propertySheet1.setNodes(new Node[]{n});
    }

    private Node getEmptyNode() {
        if (this.emptyNode == null) {
            this.emptyNode = new AbstractNode(Children.LEAF);
        }
        return this.emptyNode;
    }

    private void initialize() {
        Node n = RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
        this.newTypes = n.getNewTypes();
        ArrayList<String> c = new ArrayList<String>();
        int i = 0;
        while (i < this.newTypes.length) {
            c.add(this.newTypes[i].getName());
            ++i;
        }
        this.newTypeNames = c.toArray(new String[c.size()]);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(this.newTypeNames));
        this.dirRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.dirRadioButton.text_Mnemonic").charAt(0));
        this.jarRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.jarRadioButton.text_Mnemonic").charAt(0));
        this.otherRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.otherRadioButton.text_Mnemonic").charAt(0));
        this.dirLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.dirLabel.text_Mnemonic").charAt(0));
        this.jarLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.jarLabel.text_Mnemonic").charAt(0));
        this.createLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_FileSystemPanel.createLabel.text_Mnemonic").charAt(0));
        this.browseDirButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browseDirButton.text_Mnemonic").charAt(0));
        this.browseJarButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_FileSystemPanel.browseJarButton.text_Mnemonic").charAt(0));
        this.group.add(this.originalRadioButton);
        this.group.add(this.dirRadioButton);
        this.group.add(this.jarRadioButton);
        this.group.add(this.otherRadioButton);
        if (this.typeComboBox.getItemCount() == 0) {
            this.otherRadioButton.setEnabled(false);
        }
        this.setOriginalValueVisibility();
    }

    private Node createOtherNode() {
        int index = this.typeComboBox.getSelectedIndex();
        if (index >= 0 && index < this.newTypes.length && this.newTypes[index] instanceof ModuleFSSection) {
            ModuleFSSection mfss = (ModuleFSSection)this.newTypes[index];
            try {
                this.otherFS = mfss.createFileSystem();
                return new BeanNode((Object)this.otherFS);
            }
            catch (IntrospectionException x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
            catch (InstantiationException x) {
                ErrorManager.getDefault().notify((Throwable)x);
            }
        }
        return null;
    }

    private void createLocalFSNode() throws IntrospectionException, IntrospectionException {
        this.localFSNode = new BeanNode((Object)this.localFS);
        this.localFSNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                FileSystemPanel.this.setDirTextFieldText();
            }
        });
    }

    private void createJarFSNode() throws IntrospectionException, IntrospectionException {
        this.jarFSNode = new BeanNode((Object)this.jarFS);
        this.jarFSNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                FileSystemPanel.this.setJarTextFieldText();
            }
        });
    }

    public void setFileSystem(FileSystem f) {
        try {
            if (f != null && this.fs != f) {
                this.originalFS = f;
                this.originalNode = new BeanNode((Object)this.originalFS);
                this.setActiveFS(this.originalNode, this.originalFS);
            }
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        this.setOriginalValueVisibility();
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private void setDirTextFieldText() {
        if (this.localFS != null) {
            this.dirTextField.setText(this.localFS.getRootDirectory().getAbsolutePath());
        }
    }

    private void setJarTextFieldText() {
        if (this.jarFS != null) {
            this.jarTextField.setText(this.jarFS.getJarFile().getAbsolutePath());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getFileSystem();
    }

    private static final String getString(String s) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$FileSystemPanel == null ? (class$org$netbeans$beaninfo$editors$FileSystemPanel = FileSystemPanel.class$("org.netbeans.beaninfo.editors.FileSystemPanel")) : class$org$netbeans$beaninfo$editors$FileSystemPanel)).getString(s);
    }

    private void setOriginalValueVisibility() {
        if (this.originalFS == null) {
            this.originalRadioButton.setVisible(false);
        } else {
            this.originalRadioButton.setVisible(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

