/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.netbeans.beaninfo.editors.PointEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class PointCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$PointCustomEditor == null ? (class$org$netbeans$beaninfo$editors$PointCustomEditor = PointCustomEditor.class$("org.netbeans.beaninfo.editors.PointCustomEditor")) : class$org$netbeans$beaninfo$editors$PointCustomEditor));
    static final long serialVersionUID = -4067033871196801978L;
    private boolean dimensionMode = false;
    private JPanel insidePanel;
    private JLabel xLabel;
    private JTextField xField;
    private JLabel yLabel;
    private JTextField yField;
    private ArrayOfIntSupport editor;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$PointCustomEditor;

    public PointCustomEditor(PointEditor editor) {
        this.initComponents();
        this.editor = editor;
        Point point = (Point)editor.getValue();
        if (point == null) {
            point = new Point(0, 0);
        }
        this.xField.setText("" + point.x);
        this.yField.setText("" + point.y);
        this.xLabel.setDisplayedMnemonic(bundle.getString("CTL_X_Mnemonic").charAt(0));
        this.yLabel.setDisplayedMnemonic(bundle.getString("CTL_Y_Mnemonic").charAt(0));
        this.xField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_X"));
        this.yField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Y"));
        this.commonInit(bundle.getString("CTL_Point"));
    }

    public PointCustomEditor(DimensionEditor editor) {
        this.dimensionMode = true;
        this.initComponents();
        this.editor = editor;
        Dimension dimension = (Dimension)editor.getValue();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        this.xField.setText("" + dimension.width);
        this.yField.setText("" + dimension.height);
        this.xLabel.setText(bundle.getString("CTL_Width"));
        this.xLabel.setDisplayedMnemonic(bundle.getString("CTL_Width_mnemonic").charAt(0));
        this.xLabel.setLabelFor(this.xField);
        this.yLabel.setText(bundle.getString("CTL_Height"));
        this.yLabel.setDisplayedMnemonic(bundle.getString("CTL_Height_mnemonic").charAt(0));
        this.yLabel.setLabelFor(this.yField);
        this.xField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Width"));
        this.yField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Height"));
        this.commonInit(bundle.getString("CTL_Dimension"));
    }

    private void commonInit(String panelTitle) {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PointCustomEditor"));
        this.setBorder(new EmptyBorder(12, 12, 0, 11));
        this.insidePanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), " " + panelTitle + " "), new EmptyBorder(new Insets(5, 5, 5, 5))));
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            if (x < 0 || y < 0) {
                IllegalStateException ise = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)ise, 65536, null, bundle.getString("CTL_NegativeSize"), null, null);
                throw ise;
            }
            if (this.dimensionMode) {
                return new Dimension(x, y);
            }
            return new Point(x, y);
        }
        catch (NumberFormatException e) {
            IllegalStateException ise = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)ise, 65536, null, bundle.getString("CTL_InvalidValue"), null, null);
            throw ise;
        }
    }

    private void initComponents() {
        this.insidePanel = new JPanel();
        this.xLabel = new JLabel();
        this.xField = new JTextField();
        this.yLabel = new JLabel();
        this.yField = new JTextField();
        this.setLayout(new BorderLayout());
        this.insidePanel.setLayout(new GridBagLayout());
        this.xLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_X"));
        this.xLabel.setLabelFor(this.xField);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.insidePanel.add((Component)this.xLabel, gridBagConstraints1);
        this.xField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PointCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.insidePanel.add((Component)this.xField, gridBagConstraints1);
        this.yLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_Y"));
        this.yLabel.setLabelFor(this.yField);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.insidePanel.add((Component)this.yLabel, gridBagConstraints1);
        this.yField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PointCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.insidePanel.add((Component)this.yField, gridBagConstraints1);
        this.add((Component)this.insidePanel, "Center");
    }

    private void updateInsets(ActionEvent evt) {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            if (this.dimensionMode) {
                this.editor.setValue(new Dimension(x, y));
            } else {
                this.editor.setValue(new Point(x, y));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

