/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.netbeans.beaninfo.editors.PropertiesCustomEditor;
import org.openide.ErrorManager;

public class PropertiesEditor
extends PropertyEditorSupport {
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof Properties) {
            Properties prop = (Properties)value;
            StringBuffer buff = new StringBuffer();
            Enumeration enumeration = ((Hashtable)prop).keys();
            while (enumeration.hasMoreElements()) {
                if (buff.length() > 0) {
                    buff.append("; ");
                }
                Object key = enumeration.nextElement();
                buff.append(key + "=" + ((Hashtable)prop).get(key));
            }
            return buff.toString();
        }
        return "" + value;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            throw new IllegalArgumentException("Inserted value can't be null.");
        }
        try {
            Properties prop = new Properties();
            ByteArrayInputStream is = new ByteArrayInputStream(text.replace(';', '\n').getBytes("ISO8859_1"));
            prop.load(is);
            this.setValue(prop);
        }
        catch (IOException ioe) {
            throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException(), (Throwable)ioe);
        }
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new PropertiesCustomEditor(this);
    }
}

