/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.RootFolderNode;
import org.netbeans.core.ui.MountNode;
import org.openide.ErrorManager;
import org.openide.actions.NewTemplateAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public final class DataSystem
extends AbstractNode
implements RepositoryListener,
NewTemplateAction.Cookie {
    private static DataSystem def;
    private transient Repository fileSystemPool;
    DataFilter filter;
    static /* synthetic */ Class class$org$netbeans$core$DataSystem;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$MountAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$CustomizeAction;

    private DataSystem(Children ch, Repository fsp, DataFilter filter) {
        super(ch);
        this.fileSystemPool = fsp;
        this.filter = filter;
        this.initialize();
        this.setIconBase("org/netbeans/core/resources/repository");
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("dataSystemName"));
        this.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("CTL_Repository_Hint"));
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)fsp));
        this.getCookieSet().add((Node.Cookie)this);
    }

    private DataSystem(Children ch, DataFilter filter) {
        this(ch, Repository.getDefault(), filter);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == (class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = DataSystem.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index)) {
            return NbPlaces.getDefault().repositorySettings().getCookie(clazz);
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem);
    }

    public static Node getDataSystem(DataFilter filter) {
        if (filter == null) {
            if (def != null) {
                return def;
            }
            def = new DataSystem((Children)new DSMap(), DataFilter.ALL);
            return def;
        }
        return new DataSystem((Children)new DSMap(), filter);
    }

    public static Node getDataSystem() {
        return DataSystem.getDataSystem(null);
    }

    void initialize() {
        this.fileSystemPool.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)this.fileSystemPool));
        Enumeration en = this.fileSystemPool.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)fs));
        }
        this.refresh();
    }

    public Node.Handle getHandle() {
        return this.filter == DataFilter.ALL ? new DSHandle(null) : new DSHandle(this.filter);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = DataSystem.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), null, SystemAction.get((Class)(class$org$netbeans$core$actions$MountAction == null ? (class$org$netbeans$core$actions$MountAction = DataSystem.class$("org.netbeans.core.actions.MountAction")) : class$org$netbeans$core$actions$MountAction)), null, SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = DataSystem.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DataSystem.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$CustomizeAction == null ? (class$org$openide$actions$CustomizeAction = DataSystem.class$("org.openide.actions.CustomizeAction")) : class$org$openide$actions$CustomizeAction))};
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        ev.getFileSystem().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)ev.getFileSystem()));
        this.refresh();
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        this.refresh();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
        this.refresh();
    }

    void refresh() {
        this.refresh(null);
    }

    void refresh(FileSystem fs) {
        ((DSMap)this.getChildren()).refresh(this.fileSystemPool, fs);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        NbMainExplorer.SettingsTab nb = new NbMainExplorer.SettingsTab();
        nb.getExplorerManager().setRootContext(NbPlaces.getDefault().repositorySettings());
        nb.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("ACSD_DataSystemCustomizer"));
        return nb;
    }

    public TemplateWizard getTemplateWizard() {
        return MountNode.wizard();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class NbRepositoryNodeFactory
    extends RepositoryNodeFactory {
        public Node repository(DataFilter f) {
            return DataSystem.getDataSystem(f == DataFilter.ALL ? null : f);
        }
    }

    private static class DSHandle
    implements Node.Handle {
        DataFilter filter;
        static final long serialVersionUID = -2266375092419944364L;

        public DSHandle(DataFilter f) {
            this.filter = f;
        }

        public Node getNode() {
            return DataSystem.getDataSystem(this.filter);
        }
    }

    static class DSMap
    extends Children.Keys
    implements PropertyChangeListener {
        DSMap() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            DataSystem ds = this.getDS();
            if (ds == null) {
                return;
            }
            if (ev.getPropertyName().equals("hidden")) {
                ds.refresh();
            } else if (ev.getPropertyName().equals("root")) {
                FileSystem fs = (FileSystem)ev.getSource();
                ds.refresh(fs);
                ds.refresh();
            }
        }

        private DataSystem getDS() {
            return (DataSystem)this.getNode();
        }

        protected Node[] createNodes(Object key) {
            Node[] nodeArray;
            DataFolder df = (DataFolder)key;
            RootFolderNode n = new RootFolderNode(df, df.createNodeChildren(this.getDS().filter));
            try {
                n = MountNode.customize((Node)n, df.getPrimaryFile().getFileSystem());
            }
            catch (FileStateInvalidException fsi) {
                ErrorManager.getDefault().notify(1, (Throwable)fsi);
            }
            if (n != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            } else {
                nodeArray = new Node[]{};
            }
            Node[] retVal = nodeArray;
            return retVal;
        }

        public void refresh(Repository fileSystemPool, FileSystem fs) {
            Enumeration en = fileSystemPool.getFileSystems();
            ArrayList<DataObject> list = new ArrayList<DataObject>();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (fs == o || ((FileSystem)o).isHidden()) continue;
                DataObject root = null;
                try {
                    root = DataObject.find((FileObject)((FileSystem)o).getRoot());
                }
                catch (DataObjectNotFoundException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                if (!(root instanceof DataFolder) || !this.getDS().filter.acceptDataObject(root)) continue;
                list.add(root);
            }
            this.setKeys(list);
        }
    }
}

