/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.JarFileSystem;

public final class ExJarFileSystem
extends JarFileSystem {
    static final long serialVersionUID = 8682224601177674646L;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";

    public ExJarFileSystem() {
        InnerAttrs da = new InnerAttrs(new AttrImpl(this));
        ((AbstractFileSystem)this).attr = da;
        ((AbstractFileSystem)this).list = da;
    }

    public void setSystemName2(String name) throws PropertyVetoException {
        try {
            super.setSystemName(name);
        }
        catch (PropertyVetoException pvx) {
            ErrorManager.getDefault().annotate((Throwable)pvx, pvx.getMessage());
            throw pvx;
        }
    }

    private static class AttrImpl
    extends JarFileSystem.Impl
    implements PropertyChangeListener {
        static final String ATTR_NAME_EXT_XML = ".nbattrs";
        static final String ATTR_NAME_EXT_XML_SAFE = ".nbattrs~";
        private transient File attrFile = null;
        private transient File attrSafeFile = null;
        private transient String systemName = null;
        private JarFileSystem jfs = null;
        static final long serialVersionUID = -67233308132567123L;

        public AttrImpl(JarFileSystem fs) {
            super(fs);
            this.jfs = fs;
            this.jfs.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.jfs != null) {
                String sysName = this.jfs.getSystemName();
                if (sysName != null) {
                    this.systemName = sysName;
                    this.attrFile = new File(this.systemName + ATTR_NAME_EXT_XML);
                    this.attrSafeFile = new File(this.systemName + ATTR_NAME_EXT_XML_SAFE);
                }
                this.jfs.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("systemName".equals(evt.getPropertyName())) {
                this.systemName = (String)evt.getNewValue();
                if (this.systemName != null) {
                    this.attrFile = new File(this.systemName + ATTR_NAME_EXT_XML);
                    this.attrSafeFile = new File(this.systemName + ATTR_NAME_EXT_XML_SAFE);
                }
            }
        }

        private static void createAttributes(File file) throws IOException {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
        }

        public void createData(String name) throws IOException {
            if (this.attrFile != null && name.endsWith(ATTR_NAME_EXT_XML)) {
                AttrImpl.createAttributes(this.attrFile);
                return;
            }
            if (this.attrSafeFile != null && name.endsWith(ATTR_NAME_EXT_XML_SAFE)) {
                AttrImpl.createAttributes(this.attrSafeFile);
                return;
            }
            throw new IOException();
        }

        public long size(String name) {
            if (this.attrFile != null && name.endsWith(ATTR_NAME_EXT_XML)) {
                return this.attrFile.length();
            }
            if (this.attrSafeFile != null && name.endsWith(ATTR_NAME_EXT_XML_SAFE)) {
                return this.attrSafeFile.length();
            }
            return super.size(name);
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            if (this.attrFile != null && name.endsWith(ATTR_NAME_EXT_XML)) {
                return new FileInputStream(this.attrFile);
            }
            if (this.attrSafeFile != null && name.endsWith(ATTR_NAME_EXT_XML_SAFE)) {
                return new FileInputStream(this.attrSafeFile);
            }
            return super.inputStream(name);
        }

        public OutputStream outputStream(String name) throws IOException {
            if (this.attrFile != null && name.endsWith(ATTR_NAME_EXT_XML)) {
                AttrImpl.createAttributes(this.attrFile);
                return new FileOutputStream(this.attrFile);
            }
            if (this.attrSafeFile != null && name.endsWith(ATTR_NAME_EXT_XML_SAFE)) {
                AttrImpl.createAttributes(this.attrSafeFile);
                return new FileOutputStream(this.attrSafeFile);
            }
            return super.outputStream(name);
        }

        public void delete(String name) throws IOException {
            if (this.attrFile != null && name.endsWith(ATTR_NAME_EXT_XML)) {
                this.attrFile.delete();
                return;
            }
            if (this.attrSafeFile != null && name.endsWith(ATTR_NAME_EXT_XML_SAFE)) {
                this.attrSafeFile.delete();
                return;
            }
            super.delete(name);
        }

        public void rename(String oldName, String newName) throws IOException {
            if (this.attrFile != null && oldName.endsWith(ATTR_NAME_EXT_XML_SAFE) && newName.endsWith(ATTR_NAME_EXT_XML)) {
                this.attrSafeFile.renameTo(this.attrFile);
                return;
            }
            super.rename(oldName, newName);
        }
    }

    private static class InnerAttrs
    extends DefaultAttributes {
        static final long serialVersionUID = 1257351369229921994L;
        AttrImpl impl;

        public InnerAttrs(AttrImpl impl) {
            super((AbstractFileSystem.Info)impl, (AbstractFileSystem.Change)impl, (AbstractFileSystem.List)impl);
            this.impl = impl;
        }

        private String transformName(String name) {
            char replaceChar = '|';
            if (name.indexOf(replaceChar) != -1) {
                StringBuffer transformed = new StringBuffer(name.length());
                int i = 0;
                while (i < name.length()) {
                    transformed.append(name.charAt(i));
                    if (name.charAt(i) == replaceChar) {
                        transformed.append(replaceChar);
                    }
                    ++i;
                }
                name = transformed.toString();
            }
            return this.impl.systemName + "/" + name.replace('/', replaceChar);
        }

        public Object readAttribute(String name, String attrName) {
            if (attrName.equals(ExJarFileSystem.READONLY_ATTRIBUTES)) {
                return Boolean.FALSE;
            }
            return super.readAttribute(this.transformName(name), attrName);
        }

        public void deleteAttributes(String name) {
            super.deleteAttributes(this.transformName(name));
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            super.writeAttribute(this.transformName(name), attrName, value);
        }

        public void renameAttributes(String oldName, String newName) {
            super.renameAttributes(this.transformName(oldName), this.transformName(newName));
        }

        public Enumeration attributes(String name) {
            Enumeration retValue = super.attributes(this.transformName(name));
            return retValue;
        }
    }
}

