/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.MiniStatusBar;
import org.netbeans.core.windows.ModeImpl;
import org.openide.ErrorManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbMainExplorer
extends CloneableTopComponent
implements DeferredPerformer.DeferredCommand {
    static final long serialVersionUID = 6021472310669753679L;
    private List prevRoots;
    private Map rootsToTCs;
    private transient RootsListener rootsListener = new RootsListener();
    public static final int MIN_HEIGHT = 150;
    public static final int DEFAULT_WIDTH = 350;
    private static Map moduleTabs;
    private static NbMainExplorer explorer;
    static /* synthetic */ Class class$org$netbeans$core$NbMainExplorer;

    public NbMainExplorer() {
        NbPlaces p = NbPlaces.getDefault();
        p.addChangeListener(WeakListener.change((ChangeListener)this.rootsListener, (Object)p));
        this.refreshRoots();
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx((Node[])this.getActivatedNodes(), (HelpCtx)new HelpCtx(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer));
    }

    private static synchronized ModuleTab findModuleTab(Node root, ModuleTab tc) {
        ModuleTab tab;
        if (moduleTabs == null) {
            moduleTabs = new WeakHashMap(5);
        }
        if ((tab = (ModuleTab)moduleTabs.get(root)) != null) {
            return tab;
        }
        if (tc != null) {
            moduleTabs.put(root, tc);
            return tc;
        }
        ModuleTab newTC = new ModuleTab();
        moduleTabs.put(root, newTC);
        return newTC;
    }

    public void open(Workspace workspace) {
        DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(workspace, true));
    }

    public void performCommand(DeferredPerformer.DeferredContext context) {
        Workspace workspace = (Workspace)context.getData();
        if (workspace == null) {
            this.refreshRoots();
        } else {
            super.open(workspace);
            this.close(workspace);
            NbMainExplorer singleton = NbMainExplorer.getExplorer();
            singleton.openRoots(workspace);
        }
    }

    public void openRoots() {
        this.openRoots(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void openRoots(Workspace workspace) {
        ExplorerTab toBeActivated = MainTab.lastActivated;
        this.refreshRoots();
        Node[] rootsArray = NbMainExplorer.getRoots().toArray(new Node[0]);
        ExplorerTab tc = null;
        int i = 0;
        while (i < rootsArray.length) {
            tc = this.getRootPanel(rootsArray[i]);
            if (tc != null) {
                tc.open(workspace);
            }
            ++i;
        }
        if (toBeActivated == null) {
            toBeActivated = this.getRootPanel(rootsArray[0]);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ModeImpl mode;
            if (toBeActivated != null && (mode = (ModeImpl)workspace.findMode((TopComponent)toBeActivated)) != null) {
                mode.requestFocus((TopComponent)toBeActivated);
                toBeActivated.focusView();
            }
        } else if (toBeActivated != null) {
            final MainTab localActivated = toBeActivated;
            final Workspace localWorkspace = workspace;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl mode = (ModeImpl)localWorkspace.findMode((TopComponent)localActivated);
                    if (mode != null) {
                        mode.requestFocus((TopComponent)localActivated);
                        localActivated.focusView();
                    }
                }
            });
        }
    }

    final void refreshRoots() {
        List curRoots = NbMainExplorer.getRoots();
        if (this.prevRoots != null) {
            HashSet toRemove = new HashSet(this.prevRoots);
            toRemove.removeAll(curRoots);
            Iterator it = this.rootsToTCs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Node r = (Node)me.getKey();
                if (!toRemove.contains(r)) continue;
                NbMainExplorer.closeEverywhere((TopComponent)me.getValue());
            }
        } else {
            this.prevRoots();
        }
        List workspaces = NbMainExplorer.whereOpened(this.rootsToTCs().values().toArray(new TopComponent[0]));
        Iterator iter = curRoots.iterator();
        while (iter.hasNext()) {
            Node r = (Node)iter.next();
            ExplorerTab tc = this.getRootPanel(r);
            if (tc != null) continue;
            tc = this.createTC(r);
            Iterator iter2 = workspaces.iterator();
            while (iter2.hasNext()) {
                tc.open((Workspace)iter2.next());
            }
        }
        this.prevRoots = curRoots;
    }

    private static void closeEverywhere(TopComponent tc) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        int i = 0;
        while (i < workspaces.length) {
            if (tc.isOpened(workspaces[i])) {
                tc.close(workspaces[i]);
            }
            ++i;
        }
    }

    private static List whereOpened(TopComponent[] tcs) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        ArrayList<Workspace> result = new ArrayList<Workspace>(workspaces.length);
        int i = 0;
        while (i < workspaces.length) {
            int j = 0;
            while (j < tcs.length) {
                if (tcs[j].isOpened(workspaces[i])) {
                    result.add(workspaces[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static List getRoots() {
        NbPlaces places = NbPlaces.getDefault();
        LinkedList<Node> result = new LinkedList<Node>();
        result.add(RepositoryNodeFactory.getDefault().repository(DataFilter.ALL));
        result.addAll(Arrays.asList(places.roots()));
        result.add(places.environment());
        return result;
    }

    private ExplorerTab createTC(Node rc) {
        MainTab panel = null;
        NbPlaces places = NbPlaces.getDefault();
        panel = rc.equals(RepositoryNodeFactory.getDefault().repository(DataFilter.ALL)) ? RepositoryTab.getDefaultRepositoryTab() : (rc.equals(places.environment()) ? MainTab.getDefaultMainTab() : NbMainExplorer.findModuleTab(rc, null));
        panel.setRootContext(rc);
        this.rootsToTCs().put(rc, panel);
        return panel;
    }

    private Map rootsToTCs() {
        if (this.rootsToTCs == null) {
            this.rootsToTCs = new HashMap(7);
        }
        return this.rootsToTCs;
    }

    private List prevRoots() {
        if (this.prevRoots == null) {
            this.prevRoots = new LinkedList();
        }
        return this.prevRoots;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int cnt = in.readInt();
        int i = 0;
        while (i < cnt) {
            in.readObject();
            ++i;
        }
        in.readObject();
        in.readBoolean();
        in.readBoolean();
        in.readInt();
        in.readInt();
    }

    public final ExplorerTab getRootPanel(Node root) {
        return (ExplorerTab)this.rootsToTCs().get(root);
    }

    public static NbMainExplorer getExplorer() {
        if (explorer == null) {
            explorer = new NbMainExplorer();
        }
        return explorer;
    }

    private static Mode explorerMode(Workspace workspace) {
        Mode result = workspace.findMode("explorer");
        if (result == null) {
            String displayName = NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("CTL_ExplorerTitle");
            result = workspace.createMode("explorer", displayName, (class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer).getResource("/org/netbeans/core/resources/frames/explorer.gif"));
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        NbMainExplorer e = new NbMainExplorer();
        e.open();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RootsListener
    implements ChangeListener {
        RootsListener() {
        }

        public void stateChanged(ChangeEvent e) {
            DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)NbMainExplorer.getExplorer(), new DeferredPerformer.DeferredContext(null, true));
        }
    }

    public static class SettingsTab
    extends ExplorerTab {
        static final long serialVersionUID = 9087127908986061114L;
        static /* synthetic */ Class class$org$netbeans$core$NbMainExplorer;
        static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

        protected TreeView initGui() {
            BeanTreeView view = new BeanTreeView();
            SplittedPanel split = new SplittedPanel();
            PropertySheetView propertyView = new PropertySheetView();
            propertyView.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = SettingsTab.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerPropertySheetView"));
            propertyView.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = SettingsTab.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerPropertySheetView"));
            split.add((Component)view, SplittedPanel.ADD_LEFT);
            split.add((Component)propertyView, SplittedPanel.ADD_RIGHT);
            ((Container)((Object)this)).setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)split, "Center");
            return view;
        }

        protected void updateTitle() {
        }

        public HelpCtx getHelpCtx() {
            HelpCtx hlp = super.getHelpCtx();
            if (hlp == null || hlp.equals((Object)new HelpCtx(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = SettingsTab.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel))) {
                return this.getExplorerManager().getRootContext().getHelpCtx();
            }
            return hlp;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class ModuleTab
    extends MainTab {
        static final long serialVersionUID = 8089827754534653731L;

        public void setRootContext(Node root) {
            super.setRootContext(root);
            this.adjustComponentPersistence();
        }

        protected void validateRootContext() {
            Class<?> nodeClass = this.getExplorerManager().getRootContext().getClass();
            Node[] roots = NbPlaces.getDefault().roots();
            int i = 0;
            while (i < roots.length) {
                if (nodeClass.equals(roots[i].getClass())) {
                    this.setRootContext(roots[i]);
                    this.registerRootContext(roots[i]);
                    break;
                }
                ++i;
            }
        }

        public Object readResolve() throws ObjectStreamException {
            Node root = this.getExplorerManager().getRootContext();
            ModuleTab tc = NbMainExplorer.findModuleTab(root, this);
            if (tc == null) {
                throw new InvalidObjectException("Cannot deserialize ModuleTab for node " + root);
            }
            tc.scheduleValidation();
            return tc;
        }
    }

    public static class ProjectsTab
    extends RepositoryTab {
        static final long serialVersionUID = -8178367548546385799L;

        private ProjectsTab() {
        }

        public Object readResolve() throws ObjectStreamException {
            throw new InvalidObjectException("Old [NB3.2 ProjectsTab] component is not supported anymore.");
        }
    }

    public static class RepositoryTab
    extends MainTab
    implements OperationListener {
        static final long serialVersionUID = 4233454980309064344L;
        private RequestProcessor.Task previousTask;
        private static RepositoryTab DEFAULT;
        static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public RepositoryTab() {
            DataLoaderPool pool = (DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = RepositoryTab.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool);
            pool.addOperationListener(WeakListener.operation((OperationListener)this, (Object)pool));
        }

        public static synchronized RepositoryTab getDefaultRepositoryTab() {
            if (DEFAULT == null) {
                DEFAULT = new RepositoryTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static RepositoryTab createRepositoryTab() {
            return (RepositoryTab)NbMainExplorer.getExplorer().createTC(RepositoryNodeFactory.getDefault().repository(DataFilter.ALL));
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            RepositoryTab.getDefaultRepositoryTab().scheduleValidation();
            return RepositoryTab.getDefaultRepositoryTab();
        }

        public void operationPostCreate(OperationEvent ev) {
        }

        public void operationCopy(OperationEvent.Copy ev) {
        }

        public void operationMove(OperationEvent.Move ev) {
        }

        public void operationDelete(OperationEvent ev) {
        }

        public void operationRename(OperationEvent.Rename ev) {
        }

        public void operationCreateShadow(OperationEvent.Copy ev) {
            this.postTask(ev.getObject());
        }

        public void operationCreateFromTemplate(OperationEvent.Copy ev) {
            this.postTask(ev.getObject());
        }

        private void postTask(DataObject obj) {
            try {
                if (obj.getPrimaryFile().getFileSystem().isHidden()) {
                    return;
                }
            }
            catch (FileStateInvalidException fsie) {
                ErrorManager.getDefault().notify(1, (Throwable)fsie);
                return;
            }
            RequestProcessor.Task t = this.previousTask;
            if (t != null) {
                t.cancel();
            }
            this.previousTask = RequestProcessor.postRequest((Runnable)new Runnable(this, obj){
                private final /* synthetic */ DataObject val$obj;
                private final /* synthetic */ RepositoryTab this$0;
                {
                    this.this$0 = this$0;
                    this.val$obj = val$obj;
                }

                public void run() {
                    RepositoryTab.access$702(this.this$0, null);
                    if (!this.val$obj.isValid()) {
                        return;
                    }
                    this.this$0.doSelectNode(this.val$obj);
                }
            }, (int)100);
        }

        public void doSelectNode(DataObject obj) {
            this.selectNode(obj, null);
        }

        protected boolean selectNode(DataObject obj, DataFolder stop) {
            Stack<DataObject> stack = new Stack<DataObject>();
            while (obj != null && obj != stop) {
                stack.push(obj);
                obj = obj.getFolder();
            }
            if (obj != null) {
                stack.push(obj);
            }
            Node current = this.getExplorerManager().getRootContext();
            while (!stack.isEmpty()) {
                Node n = RepositoryTab.findDataObject(current, (DataObject)stack.pop());
                if (n == null) {
                    return false;
                }
                current = n;
            }
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{current});
            }
            catch (PropertyVetoException e) {
                throw new InternalError();
            }
            return true;
        }

        private static Node findDataObject(Node node, DataObject obj) {
            Node n = node.getChildren().findChild(obj.getNodeDelegate().getName());
            if (n != null) {
                return n;
            }
            Node[] arr = node.getChildren().getNodes();
            int i = 0;
            while (i < arr.length) {
                DataShadow ds = (DataShadow)arr[i].getCookie(class$org$openide$loaders$DataShadow == null ? RepositoryTab.class$("org.openide.loaders.DataShadow") : class$org$openide$loaders$DataShadow);
                if (ds != null && obj == ds.getOriginal()) {
                    return arr[i];
                }
                if (obj == arr[i].getCookie(class$org$openide$loaders$DataFolder == null ? RepositoryTab.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder)) {
                    return arr[i];
                }
                if (obj == arr[i].getCookie(class$org$openide$loaders$DataObject == null ? RepositoryTab.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) {
                    return arr[i];
                }
                ++i;
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ RequestProcessor.Task access$702(RepositoryTab x0, RequestProcessor.Task x1) {
            x0.previousTask = x1;
            return x0.previousTask;
        }
    }

    public static class MainTab
    extends ExplorerTab {
        static final long serialVersionUID = 4233454980309064344L;
        private static MainTab lastActivated;
        private static MainTab DEFAULT;

        public static synchronized MainTab getDefaultMainTab() {
            if (DEFAULT == null) {
                DEFAULT = new MainTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static MainTab createEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().environment());
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            MainTab.getDefaultMainTab().scheduleValidation();
            return MainTab.getDefaultMainTab();
        }

        public void open(Workspace workspace) {
            Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
            Mode ourMode = realWorkspace.findMode((TopComponent)this);
            if (ourMode == null) {
                NbMainExplorer.explorerMode(realWorkspace).dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        protected void updateTitle() {
        }

        protected void componentActivated() {
            super.componentActivated();
            lastActivated = this;
        }

        protected void validateRootContext() {
            super.validateRootContext();
            this.registerRootContext(this.getExplorerManager().getRootContext());
        }

        protected void registerRootContext(Node rc) {
            NbMainExplorer explorer = NbMainExplorer.getExplorer();
            explorer.prevRoots().add(rc);
            explorer.rootsToTCs().put(rc, this);
        }
    }

    public static class ExplorerTab
    extends ExplorerPanel
    implements DeferredPerformer.DeferredCommand,
    TopComponent.Cloneable {
        static final long serialVersionUID = -8202452314155464024L;
        protected TreeView view;
        private MiniStatusBar miniStatusBar;
        private PropertyChangeListener weakRcL;
        private PropertyChangeListener weakIdeL;
        private NodeListener weakNRcL;
        private IDESettings ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = ExplorerTab.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
        private NodeListener rcListener;
        private boolean valid = true;
        static /* synthetic */ Class class$org$netbeans$core$IDESettings;
        static /* synthetic */ Class class$org$netbeans$core$NbMainExplorer;

        public ExplorerTab() {
            ExplorerPanel.setConfirmDelete((boolean)this.ideSettings.getConfirmDelete());
            this.weakIdeL = WeakListener.propertyChange((PropertyChangeListener)this.rcListener(), (Object)((Object)this.ideSettings));
            this.ideSettings.addPropertyChangeListener(new MiniStatusBarStateListener());
        }

        protected void componentShowing() {
            super.componentShowing();
            if (this.view == null) {
                this.view = this.initGui();
                this.view.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = ExplorerTab.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerBeanTree"));
                this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = ExplorerTab.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerBeanTree"));
            }
        }

        public void addNotify() {
            super.addNotify();
            Workspace curWs = WindowManager.getDefault().getCurrentWorkspace();
            if (curWs != null && curWs.findMode((TopComponent)this) != null) {
                return;
            }
            this.componentShowing();
        }

        public void requestFocus() {
            super.requestFocus();
            if (this.view != null) {
                this.view.requestFocus();
            }
        }

        protected TreeView initGui() {
            BeanTreeView view = new BeanTreeView();
            ((Container)((Object)this)).setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)view);
            ((Container)((Object)this)).add(this.getMiniStatusBar(), "South");
            this.getMiniStatusBar().setVisible(MiniStatusBar.isMiniStatusBarEnabled());
            return view;
        }

        private void removeMiniStatusBar() {
            if (this.miniStatusBar != null) {
                this.getMiniStatusBar().setExplorerManager(null);
                this.getMiniStatusBar().setVisible(false);
                ((JComponent)((Object)this)).revalidate();
            }
        }

        private MiniStatusBar getMiniStatusBar() {
            if (this.miniStatusBar == null) {
                this.miniStatusBar = new MiniStatusBar(this.getExplorerManager());
            }
            return this.miniStatusBar;
        }

        void focusView() {
            if (this.view != null) {
                this.view.requestFocus();
            }
        }

        public void open(Workspace workspace) {
            this.performCommand(null);
            super.open(workspace);
        }

        public void setRootContext(Node rc) {
            Node oldRC = this.getExplorerManager().getRootContext();
            if (this.weakRcL != null) {
                oldRC.removePropertyChangeListener(this.weakRcL);
            }
            if (this.weakNRcL != null) {
                oldRC.removeNodeListener(this.weakNRcL);
            }
            this.getExplorerManager().setRootContext(rc);
            this.initializeWithRootContext(rc);
        }

        void adjustComponentPersistence() {
            Node.Handle handle = this.getExplorerManager().getRootContext().getHandle();
            if (handle == null) {
                ((JComponent)((Object)this)).putClientProperty("PersistenceType", "Never");
            } else {
                ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
            }
        }

        public Node getRootContext() {
            return this.getExplorerManager().getRootContext();
        }

        public Object readResolve() throws ObjectStreamException {
            this.scheduleValidation();
            return this;
        }

        public void performCommand(DeferredPerformer.DeferredContext context) {
            if (!this.valid) {
                this.valid = true;
                this.validateRootContext();
            }
        }

        protected void validateRootContext() {
            this.initializeWithRootContext(this.getExplorerManager().getRootContext());
        }

        protected void updateTitle() {
            this.setName(this.getExplorerManager().getRootContext().getDisplayName());
        }

        private NodeListener rcListener() {
            if (this.rcListener == null) {
                this.rcListener = new RootContextListener();
            }
            return this.rcListener;
        }

        private void initializeWithRootContext(Node rc) {
            if (this.miniStatusBar != null) {
                this.miniStatusBar.setExplorerManager(this.getExplorerManager());
            }
            this.setIcon(rc.getIcon(1));
            this.setToolTipText(rc.getShortDescription());
            this.setName(rc.getDisplayName());
            this.updateTitle();
            if (this.weakRcL == null) {
                this.weakRcL = WeakListener.propertyChange((PropertyChangeListener)this.rcListener(), (Object)rc);
            } else {
                rc.removePropertyChangeListener(this.weakRcL);
            }
            rc.addPropertyChangeListener(this.weakRcL);
            if (this.weakNRcL == null) {
                this.weakNRcL = WeakListener.node((NodeListener)this.rcListener(), (Object)rc);
            } else {
                rc.removeNodeListener(this.weakNRcL);
            }
            rc.addNodeListener(this.weakNRcL);
        }

        protected final void scheduleValidation() {
            this.valid = false;
            DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, null);
        }

        public void setName(String name) {
            super.setName(name);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleName(name);
            }
        }

        public void setToolTipText(String text) {
            super.setToolTipText(text);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleDescription(text);
            }
        }

        public TopComponent cloneComponent() {
            ExplorerTab nue = new ExplorerTab();
            nue.getExplorerManager().setRootContext(this.getExplorerManager().getRootContext());
            try {
                nue.getExplorerManager().setSelectedNodes(this.getExplorerManager().getSelectedNodes());
            }
            catch (PropertyVetoException pve) {
                ErrorManager.getDefault().notify((Throwable)pve);
            }
            return nue;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private final class RootContextListener
        implements NodeListener {
            RootContextListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                Object source = evt.getSource();
                if (source instanceof IDESettings) {
                    ExplorerPanel.setConfirmDelete((boolean)((IDESettings)((Object)source)).getConfirmDelete());
                    return;
                }
                Node n = (Node)source;
                if ("displayName".equals(propName) || "name".equals(propName)) {
                    ExplorerTab.this.setName(n.getDisplayName());
                } else if ("icon".equals(propName)) {
                    ExplorerTab.this.setIcon(n.getIcon(1));
                } else if ("shortDescription".equals(propName)) {
                    ExplorerTab.this.setToolTipText(n.getShortDescription());
                }
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                ExplorerTab.this.setCloseOperation(0);
                ExplorerTab.this.close();
            }

            public void childrenRemoved(NodeMemberEvent e) {
            }

            public void childrenReordered(NodeReorderEvent e) {
            }

            public void childrenAdded(NodeMemberEvent e) {
            }
        }

        private class MiniStatusBarStateListener
        implements PropertyChangeListener {
            MiniStatusBarStateListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("mini_status_bar_state".equals(evt.getPropertyName())) {
                    if (evt.getNewValue().equals(evt.getOldValue())) {
                        return;
                    }
                    if (((Boolean)evt.getOldValue()).booleanValue()) {
                        ExplorerTab.this.removeMiniStatusBar();
                    }
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        ExplorerTab.this.getMiniStatusBar().setExplorerManager(ExplorerTab.this.getExplorerManager());
                        ExplorerTab.this.getMiniStatusBar().setVisible(true);
                    }
                }
            }
        }
    }
}

