/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Font;
import java.awt.TextComponent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.text.JTextComponent;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.Main;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.NonGui;
import org.netbeans.core.TopLogging;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NonGuiMain
extends NonGui {
    public static final int CMD_OK = 0;
    public static final int CMD_FAIL = 1;
    public static boolean load = true;
    public static boolean interactiveMode = true;
    public static boolean startGui = false;
    public static final String PROMPT = "[localhost]";
    private static String interpName = "BeanShell";
    private static PrintStream out = System.out;
    private static InputStream in = System.in;
    private static boolean showStatusLine = false;
    private static boolean showNotifyText = true;
    static /* synthetic */ Class class$org$netbeans$core$NonGui;
    static /* synthetic */ Class class$org$netbeans$core$NonGuiMain;

    public static void info() {
        String sysInfo = NbBundle.getBundle((Class)(class$org$netbeans$core$NonGui == null ? (class$org$netbeans$core$NonGui = NonGuiMain.class$("org.netbeans.core.NonGui")) : class$org$netbeans$core$NonGui)).getString("CTL_System_info");
        out.println("-- " + sysInfo + " ----------------------------------------------------------------");
        TopLogging.printSystemInfo(out);
        out.println("-------------------------------------------------------------------------------");
    }

    public static void showHelp2() {
        NonGui.showHelp();
        System.out.println(NonGuiMain.getStringX("CTL_INPUT_option"));
        System.out.println(NonGuiMain.getStringX("CTL_OUTPUT_option"));
        System.out.println(NonGuiMain.getStringX("CTL_INFO_option"));
        System.out.println(NonGuiMain.getStringX("CTL_NOLOAD_option"));
        System.out.println(NonGuiMain.getStringX("CTL_FP_option"));
        System.out.println(NonGuiMain.getStringX("CTL_ENV_option"));
    }

    public static int processArgs(String[] args) {
        String _methodName = "processArgs";
        boolean showInfo = false;
        ArrayList<String> newArgs = new ArrayList<String>(2);
        int argNo = 0;
        while (argNo < args.length) {
            String argvOrig = args[argNo];
            if (argvOrig.startsWith("-")) {
                String fname;
                String argv = argvOrig.substring(1);
                if (argv.equals("info")) {
                    showInfo = true;
                    ++argNo;
                    continue;
                }
                if (argv.equals("gui")) {
                    startGui = true;
                    ++argNo;
                    continue;
                }
                if (argv.startsWith("t")) {
                    if (argv.length() == 1) {
                        if (++argNo >= args.length) {
                            out.println(NonGuiMain.getStringX("MSG_NoInputFile"));
                            return 1;
                        }
                        interpName = args[argNo];
                    } else {
                        interpName = argv.substring(1);
                    }
                    ++argNo;
                    continue;
                }
                if (argv.startsWith("i")) {
                    String inFile;
                    if (argv.length() == 1) {
                        if (++argNo >= args.length) {
                            out.println(NonGuiMain.getStringX("MSG_NoInputFile"));
                            return 1;
                        }
                        inFile = args[argNo];
                    } else {
                        inFile = argv.substring(1);
                    }
                    if (inFile.compareTo("%stdin") == 0) {
                        in = System.in;
                        interactiveMode = true;
                    } else {
                        interactiveMode = false;
                        try {
                            in = new FileInputStream(inFile);
                        }
                        catch (FileNotFoundException fnf) {
                            out.println(NonGuiMain.getStringX("MSG_NoInputScript", inFile));
                            NonGuiMain.printException("processArgs", fnf);
                        }
                    }
                    ++argNo;
                    continue;
                }
                if (argv.startsWith("o")) {
                    if (argv.length() == 1) {
                        if (++argNo >= args.length) {
                            out.println(NonGuiMain.getStringX("MSG_NoOutputFile"));
                            return 1;
                        }
                        fname = args[argNo];
                    } else {
                        fname = argv.substring(1);
                    }
                    ++argNo;
                    if (fname == null) continue;
                    if (fname.compareTo("%stdout") == 0) {
                        out = System.out;
                        continue;
                    }
                    try {
                        out = new PrintStream(new FileOutputStream(fname));
                    }
                    catch (FileNotFoundException fnf) {
                        out.println(NonGuiMain.getStringX("MSG_NoInputScript", fname));
                        NonGuiMain.printException("processArgs", fnf);
                    }
                    continue;
                }
                if (argv.startsWith("D")) {
                    int eqSign = argv.indexOf(61);
                    if (eqSign <= 0) {
                        out.println(NonGuiMain.getStringX("MSG_InvalidProperty", argv));
                    } else {
                        String propName = argv.substring(1, eqSign);
                        String propValue = argv.substring(eqSign + 1);
                        System.setProperty(propName, propValue);
                    }
                    ++argNo;
                    continue;
                }
                if (argv.startsWith("fp")) {
                    if (argv.length() == 2) {
                        if (++argNo >= args.length) {
                            out.println(NonGuiMain.getStringX("MSG_NoPropFile"));
                            return 1;
                        }
                        fname = args[argNo];
                    } else {
                        fname = argv.substring(2);
                    }
                    ++argNo;
                    NonGuiMain.loadPropertyFile(fname);
                    continue;
                }
                if (argv.equals("e")) {
                    fname = System.getProperty("netbeans.osenv");
                    ++argNo;
                    continue;
                }
                if (argv.equals("noload")) {
                    load = false;
                    ++argNo;
                    continue;
                }
                newArgs.add(argvOrig);
                ++argNo;
                continue;
            }
            newArgs.add(argvOrig);
            ++argNo;
        }
        int size = newArgs.size();
        String[] tmpArgs = new String[size];
        if (size > 0) {
            int i = 0;
            while (i < newArgs.size()) {
                tmpArgs[i] = (String)newArgs.get(i);
                ++i;
            }
        }
        if (startGui) {
            NonGuiMain.startGui(tmpArgs);
        } else {
            NonGui.parseCommandLine(tmpArgs);
        }
        if (showInfo) {
            NonGuiMain.info();
        }
        return 0;
    }

    static void startGui(String[] args) {
        ((Hashtable)System.getProperties()).put("org.openide.TopManager", "org.netbeans.core.Main");
        ((Hashtable)System.getProperties()).put("netbeans.full.hack", "true");
        Main.main(args);
    }

    public static void main(String[] args) {
        ((Hashtable)System.getProperties()).put("org.openide.TopManager", "org.netbeans.core.NonGuiMain");
        ((Hashtable)System.getProperties()).put("netbeans.design.time", "true");
        if (NonGuiMain.processArgs(args) == 1) {
            NonGuiMain.showHelp2();
            TopSecurityManager.exit((int)0);
        }
        new Font("Dialog", 0, NonGui.uiFontSize);
        if (load) {
            NbTopManager.get();
        }
        NonGuiMain.myExit(0);
    }

    public static void myExit(int status) {
        if (NbTopManager.isInitialized()) {
            LifecycleManager.getDefault().exit();
        }
        TopSecurityManager.exit((int)status);
    }

    static String getStringX(String resName) {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$NonGuiMain == null ? (class$org$netbeans$core$NonGuiMain = NonGuiMain.class$("org.netbeans.core.NonGuiMain")) : class$org$netbeans$core$NonGuiMain)).getString(resName);
    }

    static String getStringX(String resName, Object arg) {
        MessageFormat mf = new MessageFormat(NonGuiMain.getStringX(resName));
        return mf.format(new Object[]{arg});
    }

    static String getStringX(String resName, Object arg1, Object arg2) {
        MessageFormat mf = new MessageFormat(NonGuiMain.getStringX(resName));
        return mf.format(new Object[]{arg1, arg2});
    }

    private static void printException(String methodName, Throwable exc) {
        out.println(NonGuiMain.getStringX("MSG_ExceptionIn", methodName));
        exc.printStackTrace(out);
    }

    public Object notify(NotifyDescriptor n) {
        if (!showNotifyText) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        Object msg = n.getMessage();
        String display = null;
        if (msg instanceof TextComponent) {
            display = ((TextComponent)msg).getText();
        } else if (msg instanceof JTextComponent) {
            display = ((JTextComponent)msg).getText();
        } else if (msg instanceof Component) {
            try {
                Method getText = msg.getClass().getMethod("getText", null);
                Object rval = getText.invoke(msg, null);
                if (rval instanceof String) {
                    display = (String)rval;
                } else if (rval instanceof String[]) {
                    String[] arr = (String[])rval;
                    out.println("NOTIFICATION:");
                    int i = 0;
                    while (i < arr.length) {
                        out.println("\t" + arr[i]);
                        ++i;
                    }
                    return NotifyDescriptor.CLOSED_OPTION;
                }
            }
            catch (Exception e) {
                display = msg.toString();
            }
        } else {
            display = msg.toString();
        }
        out.println("NOTIFICATION: " + display);
        return NotifyDescriptor.CLOSED_OPTION;
    }

    protected void setStatusTextImpl(String text) {
        if (showStatusLine) {
            out.println("STATUS LINE : " + text);
        }
    }

    public static boolean showStatusLine(boolean val) {
        boolean oldVal = showStatusLine;
        showStatusLine = val;
        return oldVal;
    }

    public static boolean showNotifyText(boolean val) {
        boolean oldVal = showNotifyText;
        showNotifyText = val;
        return oldVal;
    }

    public void showUrl(URL url) {
        try {
            out.println("SHOW URL " + url.toString() + " START: ");
            InputStream is = url.openStream();
            FileUtil.copy((InputStream)is, (OutputStream)out);
            out.println("SHOW URL - END");
        }
        catch (IOException ex) {
            out.println("Exception in showUrl: " + ex.getMessage());
        }
    }

    public static int loadPropertyFile(String fileName) {
        String methodName = "NonGuiMain.loadPropertyFile";
        Exception exc = null;
        if (fileName != null) {
            try {
                FileInputStream fis = null;
                fis = new FileInputStream(fileName);
                System.getProperties().load(fis);
            }
            catch (FileNotFoundException e) {
                exc = e;
                out.println(NonGui.getString("MSG_NoPropFile", fileName));
                NonGuiMain.printException("NonGuiMain.loadPropertyFile", e);
            }
            catch (IOException e) {
                exc = e;
                out.println(NonGui.getString("MSG_IOPropFile", fileName));
                NonGuiMain.printException("NonGuiMain.loadPropertyFile", e);
            }
            catch (IllegalArgumentException e) {
                exc = e;
                out.println(NonGui.getString("MSG_ErrPropFile", fileName));
                NonGuiMain.printException("NonGuiMain.loadPropertyFile", e);
            }
            if (exc != null) {
                return 1;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

