/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.netbeans.beaninfo.ExJarFileSystemBeanInfo;
import org.netbeans.beaninfo.ExLocalFileSystemBeanInfo;
import org.netbeans.beaninfo.JarFileSystemBeanInfo;
import org.netbeans.beaninfo.LocalFileSystemBeanInfo;
import org.netbeans.core.UnmountFSCookie;
import org.netbeans.core.ui.MountNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

final class RootFolderNode
extends DataFolder.FolderNode
implements UnmountFSCookie,
PropertyChangeListener {
    private static MessageFormat formatRoot;
    private FileSystem fs;
    private DataFolder df;
    private Image iconCache;
    static /* synthetic */ Class class$org$netbeans$core$RootFolderNode;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$UnmountFSAction;
    static /* synthetic */ Class class$org$netbeans$core$UnmountFSCookie;

    public RootFolderNode(DataFolder df, Children ch) {
        super(df, ch);
        this.df = df;
        this.init();
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        s.remove("properties");
        Sheet.Set sortSet = s.remove("sorting");
        try {
            Object helpID;
            BeanInfo bi = Introspector.getBeanInfo(this.fs.getClass());
            BeanNode.Descriptor d = BeanNode.computeProperties((Object)this.fs, (BeanInfo)bi);
            BeanDescriptor bd = bi.getBeanDescriptor();
            Sheet.Set set = Sheet.createPropertiesSet();
            set.put(d.property);
            if (bd != null && (helpID = bd.getValue("propertiesHelpID")) != null && helpID instanceof String) {
                set.setValue("helpID", helpID);
            }
            s.put(set);
            if (d.expert != null) {
                set = Sheet.createExpertSet();
                set.put(d.expert);
                if (bd != null && (helpID = bd.getValue("expertHelpID")) != null && helpID instanceof String) {
                    set.setValue("helpID", helpID);
                }
                s.put(set);
            }
        }
        catch (IntrospectionException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        s.put(sortSet);
        return s;
    }

    public String getName() {
        return this.fs == null ? "" : this.fs.getSystemName();
    }

    private void init() {
        try {
            this.fs = this.df.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new InternalError();
        }
        this.fs.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.fs));
        this.setIconBase("org/netbeans/core/resources/defaultFS");
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$RootFolderNode == null ? (class$org$netbeans$core$RootFolderNode = RootFolderNode.class$("org.netbeans.core.RootFolderNode")) : class$org$netbeans$core$RootFolderNode));
        formatRoot = new MessageFormat(bundle.getString("dataFolderRootName"));
        this.initDisplayName();
    }

    private void initDisplayName() {
        String s = formatRoot.format(new Object[]{this.fs.getDisplayName(), this.fs.getSystemName()});
        this.setDisplayName(s);
    }

    public Image getIcon(int type) {
        if (this.iconCache != null) {
            return this.iconCache;
        }
        Class<?> klass = this.fs.getClass();
        BeanInfo bi = RootFolderNode.getBeanInfoForClass(klass.getName());
        if (bi != null) {
            this.iconCache = bi.getIcon(type);
            return this.iconCache;
        }
        try {
            bi = Utilities.getBeanInfo(this.fs.getClass());
        }
        catch (IntrospectionException e) {
            this.iconCache = super.getIcon(type);
            return this.iconCache;
        }
        Image ret = bi.getIcon(type);
        this.iconCache = ret == null ? super.getIcon(type) : ret;
        return this.iconCache;
    }

    public String getShortDescription() {
        BeanDescriptor bd;
        Class<?> klass = this.fs.getClass();
        BeanInfo bi = RootFolderNode.getBeanInfoForClass(klass.getName());
        if (bi == null) {
            try {
                bi = Utilities.getBeanInfo(this.fs.getClass());
            }
            catch (IntrospectionException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        if ((bd = bi.getBeanDescriptor()) == null) {
            return null;
        }
        String sd = bd.getShortDescription();
        if (sd == null || sd.equals(bd.getName())) {
            return null;
        }
        return sd;
    }

    private static BeanInfo getBeanInfoForClass(String klassName) {
        if (klassName.equals("org.openide.filesystems.LocalFileSystem")) {
            return new LocalFileSystemBeanInfo();
        }
        if (klassName.equals("org.netbeans.core.ExLocalFileSystem")) {
            return new ExLocalFileSystemBeanInfo();
        }
        if (klassName.equals("org.netbeans.core.ExJarFileSystem")) {
            return new ExJarFileSystemBeanInfo();
        }
        if (klassName.equals("org.openide.filesystems.JarFileSystem")) {
            return new JarFileSystemBeanInfo();
        }
        return null;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public SystemAction[] getActions() {
        ArrayList<SystemAction> actions = new ArrayList<SystemAction>(Arrays.asList(super.getActions()));
        actions.remove(SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = RootFolderNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)));
        actions.remove(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = RootFolderNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
        actions.remove(SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = RootFolderNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)));
        int i = actions.lastIndexOf(SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = RootFolderNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)));
        SystemAction ufsa = SystemAction.get((Class)(class$org$netbeans$core$actions$UnmountFSAction == null ? (class$org$netbeans$core$actions$UnmountFSAction = RootFolderNode.class$("org.netbeans.core.actions.UnmountFSAction")) : class$org$netbeans$core$actions$UnmountFSAction));
        if (i == -1) {
            actions.add(null);
            actions.add(ufsa);
        } else {
            if (i > 0 && actions.get(i - 1) == null) {
                --i;
            }
            if (actions.get(i) != null) {
                actions.add(i, null);
            }
            actions.add(i, ufsa);
            actions.add(i, null);
        }
        return actions.toArray(new SystemAction[actions.size()]);
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean hasCustomizer() {
        try {
            BeanInfo info = Introspector.getBeanInfo(this.fs.getClass());
            return info.getBeanDescriptor().getCustomizerClass() != null;
        }
        catch (IntrospectionException ex) {
            return false;
        }
    }

    public Component getCustomizer() {
        try {
            BeanInfo info = Introspector.getBeanInfo(this.fs.getClass());
            Class<?> c = info.getBeanDescriptor().getCustomizerClass();
            Object i = c.newInstance();
            if (i instanceof Customizer) {
                Customizer cust = (Customizer)i;
                cust.setObject(this.fs);
            }
            if (i instanceof Component) {
                return (Component)i;
            }
            if (i instanceof DialogDescriptor) {
                DialogDescriptor dd = (DialogDescriptor)i;
                return DialogDisplayer.getDefault().createDialog(dd);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return null;
    }

    public Node.Cookie getCookie(Class cl) {
        Node.Cookie ret = super.getCookie(cl);
        if (ret != null) {
            return ret;
        }
        if ((class$org$netbeans$core$UnmountFSCookie == null ? (class$org$netbeans$core$UnmountFSCookie = RootFolderNode.class$("org.netbeans.core.UnmountFSCookie")) : class$org$netbeans$core$UnmountFSCookie) == cl && !this.fs.isDefault()) {
            return this;
        }
        return null;
    }

    public void unmount() {
        MountNode.unmount(this.fs);
        Repository.getDefault().removeFileSystem(this.fs);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        boolean isDispName = "displayName".equals(ev.getPropertyName());
        boolean isSystName = "systemName".equals(ev.getPropertyName());
        if (isSystName || isDispName) {
            this.initDisplayName();
            this.fireShortDescriptionChange(null, null);
        }
        this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
    }

    public HelpCtx getHelpCtx() {
        HelpCtx h = InstanceSupport.findHelp((InstanceCookie)new InstanceSupport.Instance((Object)this.fs));
        if (h != null) {
            return h;
        }
        return super.getHelpCtx();
    }

    public Node.Handle getHandle() {
        return new RootFolderHandle(this.fs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RootFolderHandle
    implements Node.Handle {
        private String fs;
        private transient FileSystem legacyFS;
        private static final long serialVersionUID = -703297683479416470L;

        public RootFolderHandle(FileSystem fs) {
            this.legacyFS = fs;
            this.fs = fs.getSystemName();
        }

        public Node getNode() throws IOException {
            if (this.legacyFS == null) {
                if (this.fs == null) {
                    throw new IOException("RootFolderHandle: Field fs is null.");
                }
                this.legacyFS = Repository.getDefault().findFileSystem(this.fs);
                if (this.legacyFS == null) {
                    throw new IOException("FileSystem " + this.fs + " not found");
                }
            }
            DataFolder df = DataFolder.findFolder((FileObject)this.legacyFS.getRoot());
            return new RootFolderNode(df, df.createNodeChildren(DataFilter.ALL));
        }

        private void readObject(ObjectInputStream ios) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ios.readFields();
            Object o = gf.get("fs", null);
            if (o instanceof FileSystem) {
                this.fs = ((FileSystem)o).getSystemName();
            }
            if (o instanceof String) {
                this.fs = (String)o;
            }
        }
    }
}

