/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.io.NbMarshalledObject;

public final class Services
extends ServiceType.Registry
implements LookupListener {
    static final long serialVersionUID = -7558069607307508327L;
    private Lookup.Result allTypes;
    private Map name2Service = new HashMap();
    static /* synthetic */ Class class$org$openide$ServiceType$Registry;
    static /* synthetic */ Class class$org$openide$ServiceType;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public static Services getDefault() {
        return (Services)((Object)Lookup.getDefault().lookup(class$org$openide$ServiceType$Registry == null ? (class$org$openide$ServiceType$Registry = Services.class$("org.openide.ServiceType$Registry")) : class$org$openide$ServiceType$Registry));
    }

    public ServiceType find(Class clazz) {
        return (ServiceType)Lookup.getDefault().lookup(clazz);
    }

    public ServiceType find(String name) {
        ServiceType ret;
        Map lookupMap;
        Map map = lookupMap = this.name2Service;
        synchronized (map) {
            ret = (ServiceType)lookupMap.get(name);
        }
        if (ret == null) {
            ret = super.find(name);
            Map map2 = lookupMap;
            synchronized (map2) {
                lookupMap.put(name, ret);
            }
        }
        return ret;
    }

    private Lookup.Result getTypesResult() {
        boolean init = false;
        Services services = this;
        synchronized (services) {
            if (this.allTypes == null) {
                this.allTypes = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = Services.class$("org.openide.ServiceType")) : class$org$openide$ServiceType));
                this.allTypes.addLookupListener((LookupListener)this);
                init = true;
            }
        }
        if (init) {
            this.resultChanged(null);
        }
        return this.allTypes;
    }

    public void resultChanged(LookupEvent ev) {
        Map map = this.name2Service;
        synchronized (map) {
            this.name2Service.clear();
        }
    }

    public List getServiceTypes() {
        return new ArrayList(this.getTypesResult().allInstances());
    }

    public synchronized void setServiceTypes(List arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        arr = this.ensureSingleness(arr);
        HashMap services = new HashMap(20);
        NbPlaces.getDefault();
        this.searchServices(NbPlaces.findSessionFolder("Services").getPrimaryFile(), services);
        HashMap<DataFolder, ArrayList<DataObject>> order = new HashMap<DataFolder, ArrayList<DataObject>>(10);
        Iterator<Object> it = arr.iterator();
        while (it.hasNext()) {
            ServiceType st = (ServiceType)it.next();
            DataObject dobj = (DataObject)services.get(st);
            if (dobj != null) {
                try {
                    dobj = InstanceDataObject.create((DataFolder)dobj.getFolder(), (String)dobj.getPrimaryFile().getName(), (Object)st, null);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                services.remove(st);
            } else {
                dobj = this.storeNewServiceType(st);
            }
            if (dobj == null) continue;
            DataFolder parent = dobj.getFolder();
            ArrayList<DataObject> orderedFiles = (ArrayList<DataObject>)order.get(parent);
            if (orderedFiles == null) {
                orderedFiles = new ArrayList<DataObject>(6);
                order.put(parent, orderedFiles);
            }
            orderedFiles.add(dobj);
        }
        it = order.keySet().iterator();
        while (it.hasNext()) {
            DataObject parent = (DataObject)it.next();
            List orderedFiles = (List)order.get(parent);
            if (orderedFiles.size() < 2) continue;
            Iterator files = orderedFiles.iterator();
            StringBuffer orderAttr = new StringBuffer(64);
            while (files.hasNext()) {
                DataObject file = (DataObject)files.next();
                orderAttr.append(file.getPrimaryFile().getNameExt()).append('/');
            }
            orderAttr.deleteCharAt(orderAttr.length() - 1);
            try {
                parent.getPrimaryFile().setAttribute("OpenIDE-Folder-Order", (Object)orderAttr.toString());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        it = services.values().iterator();
        while (it.hasNext()) {
            DataObject dobj = (DataObject)it.next();
            try {
                dobj.delete();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private DataObject storeNewServiceType(ServiceType st) {
        Class<?> stype = st.getClass();
        while (stype.getSuperclass() != (class$org$openide$ServiceType == null ? Services.class$("org.openide.ServiceType") : class$org$openide$ServiceType)) {
            stype = stype.getSuperclass();
        }
        try {
            String folder = Utilities.getShortClassName(stype);
            NbPlaces.getDefault();
            DataFolder dfServices = NbPlaces.findSessionFolder("Services");
            DataFolder dfTarget = DataFolder.create((DataFolder)dfServices, (String)folder);
            return InstanceDataObject.create((DataFolder)dfTarget, null, (Object)st, null);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    private List ensureSingleness(List l) {
        ArrayList<ServiceType> newList = new ArrayList<ServiceType>(l.size());
        Iterator it = l.iterator();
        while (it.hasNext()) {
            ServiceType stype = (ServiceType)it.next();
            if (newList.contains(stype)) continue;
            newList.add(stype);
        }
        return newList;
    }

    private void searchServices(FileObject folder, Map services) {
        FileObject[] fobjs = folder.getChildren();
        int i = 0;
        while (i < fobjs.length) {
            if (fobjs[i].isValid()) {
                if (fobjs[i].isFolder()) {
                    this.searchServices(fobjs[i], services);
                } else {
                    try {
                        DataObject dobj = DataObject.find((FileObject)fobjs[i]);
                        InstanceCookie inst = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie == null ? Services.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                        if (inst != null && Services.instanceOf(inst, class$org$openide$ServiceType == null ? Services.class$("org.openide.ServiceType") : class$org$openide$ServiceType)) {
                            ServiceType ser = (ServiceType)inst.instanceCreate();
                            services.put(ser, dobj);
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            }
            ++i;
        }
    }

    private static boolean instanceOf(InstanceCookie inst, Class clazz) {
        if (inst instanceof InstanceCookie.Of) {
            return ((InstanceCookie.Of)inst).instanceOf(clazz);
        }
        try {
            return clazz.isAssignableFrom(inst.instanceClass());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    public Enumeration services() {
        return Collections.enumeration(this.getServiceTypes());
    }

    public Enumeration services(Class clazz) {
        if (clazz == null) {
            new EmptyEnumeration();
        }
        Collection res = Lookup.getDefault().lookup(new Lookup.Template(clazz)).allInstances();
        return Collections.enumeration(res);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Enumeration en = this.services();
        while (en.hasMoreElements()) {
            NbMarshalledObject obj;
            ServiceType s = (ServiceType)en.nextElement();
            try {
                obj = new NbMarshalledObject((Object)s);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                obj = null;
            }
            if (obj == null) continue;
            oos.writeObject(obj);
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        NbMarshalledObject obj;
        LinkedList<ServiceType> ll = new LinkedList<ServiceType>();
        while ((obj = (NbMarshalledObject)oos.readObject()) != null) {
            try {
                ServiceType s = (ServiceType)obj.get();
                ll.add(s);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Services.getDefault().setServiceTypes(ll);
    }

    private Object readResolve() {
        return Services.getDefault();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

