/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.NbPlaces;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ShortcutsFolder
extends FolderInstance {
    static ShortcutsFolder shortcutsFolder = null;
    public static final String PROPERTIES_FILE = "Shortcuts";
    public static final String DEFAULT_KEYS_FILE = "Default";
    public static final String USER_KEYS_FILE = "UserDefined";
    private static final String KEYS_EXT = "keys";
    static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String XML_BINDING = "Binding";
    private static final String ATTR_BINDING_KEY = "key";
    private static final String ATTR_BINDING_ACTION = "action";
    static /* synthetic */ Class class$javax$swing$text$Keymap;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public ShortcutsFolder(DataFolder f) {
        super(f);
        this.recreate();
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        HashMap<KeyStroke, Action> map = new HashMap<KeyStroke, Action>(80);
        int i = 0;
        while (i < cookies.length) {
            String keyname = cookies[i].instanceName();
            KeyStroke stroke = Utilities.stringToKey((String)keyname);
            if (stroke == null) {
                ErrorManager.getDefault().getInstance("org.netbeans.core.ShortcutsFolder").log("Warning: unparsable keystroke: " + keyname);
            } else {
                Action action = (Action)cookies[i].instanceCreate();
                map.put(stroke, action);
            }
            ++i;
        }
        Keymap globalMap = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = ShortcutsFolder.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        globalMap.removeBindings();
        if (globalMap instanceof NbKeymap) {
            ((NbKeymap)globalMap).addActionForKeyStrokeMap(map);
        } else {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                KeyStroke key = (KeyStroke)it.next();
                globalMap.addActionForKeyStroke(key, (Action)map.get(key));
            }
        }
        return null;
    }

    protected InstanceCookie acceptDataObject(DataObject dob) {
        InstanceCookie ic = super.acceptDataObject(dob);
        if (ic != null) {
            try {
                Object o = ic.instanceCreate();
                if (o instanceof Action) {
                    KeyActionPair pair = new KeyActionPair(dob.getName(), (Action)o);
                    return pair;
                }
            }
            catch (IOException x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
            catch (ClassNotFoundException x) {
                ErrorManager.getDefault().notify(1, (Throwable)x);
            }
        }
        return null;
    }

    static String getKeyStrokeName(KeyStroke stroke) {
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = ShortcutsFolder.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        Action action = map.getAction(stroke);
        if (action instanceof SystemAction) {
            String name = ((SystemAction)action).getName();
            name = Utilities.replaceString((String)name, (String)"&", (String)"");
            name = Utilities.replaceString((String)name, (String)"...", (String)"");
            return ShortcutsFolder.getKeyText(stroke) + " [" + name + "]";
        }
        if (action == null) {
            return ShortcutsFolder.getKeyText(stroke);
        }
        return ShortcutsFolder.getKeyText(stroke) + " [" + action.getValue("Name") + "]";
    }

    static String getActionName(SystemAction action) {
        String name = Utilities.replaceString((String)action.getName(), (String)"&", (String)"");
        name = Utilities.replaceString((String)name, (String)"...", (String)"");
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = ShortcutsFolder.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        KeyStroke[] strokes = map.getKeyStrokesForAction((Action)action);
        if (strokes.length > 0) {
            name = name + " [";
            int i = 0;
            while (i < strokes.length) {
                name = name + ShortcutsFolder.getKeyText(strokes[i]);
                if (i != strokes.length - 1) {
                    name = name + ", ";
                }
                ++i;
            }
            return name + "]";
        }
        return name;
    }

    static String getKeyText(int keyCode, int modifiers) {
        String modifText = KeyEvent.getKeyModifiersText(modifiers);
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyCode);
        }
        if (keyCode == 18 || keyCode == 65406 || keyCode == 17 || keyCode == 16) {
            return modifText + "+";
        }
        return modifText + "+" + KeyEvent.getKeyText(keyCode);
    }

    static String getKeyText(KeyStroke stroke) {
        if (stroke == null) {
            return "";
        }
        String modifText = KeyEvent.getKeyModifiersText(stroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(stroke.getKeyCode());
        }
        return modifText + "+" + KeyEvent.getKeyText(stroke.getKeyCode());
    }

    static Document parseKeysFile(URL url) throws SAXException, IOException {
        return XMLDataObject.parse((URL)url, (ErrorHandler)new ErrorHandler(){

            public void error(SAXParseException e) {
            }

            public void warning(SAXParseException e) {
            }

            public void fatalError(SAXParseException e) {
            }
        });
    }

    private static void transformOldFiles() {
        try {
            FileObject propsFO;
            FileObject mainFO;
            FileSystem systemFS = Repository.getDefault().getDefaultFileSystem();
            boolean defaultsUsed = false;
            HashMap<String, FileObject> moduleKeyFiles = new HashMap<String, FileObject>(11);
            FileObject shortcutsFolder = systemFS.getRoot().getFileObject("Shortcuts");
            if (shortcutsFolder == null) {
                shortcutsFolder = FileUtil.createFolder((FileObject)systemFS.getRoot(), (String)"Shortcuts");
            }
            if ((mainFO = shortcutsFolder.getFileObject(USER_KEYS_FILE, KEYS_EXT)) == null) {
                defaultsUsed = true;
                mainFO = shortcutsFolder.getFileObject(DEFAULT_KEYS_FILE, KEYS_EXT);
            }
            FileObject[] files = shortcutsFolder.getChildren();
            int i = 0;
            while (i < files.length) {
                String fName = files[i].getName();
                if (files[i].hasExt(KEYS_EXT) && !fName.equals(DEFAULT_KEYS_FILE) && !fName.equals(USER_KEYS_FILE)) {
                    moduleKeyFiles.put(fName, files[i]);
                }
                ++i;
            }
            if (!defaultsUsed && (propsFO = shortcutsFolder.getFileObject("Shortcuts", "properties")) != null) {
                Properties props = new Properties();
                try {
                    props.load(propsFO.getInputStream());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                Enumeration items = ((Hashtable)props).keys();
                while (items.hasMoreElements()) {
                    moduleKeyFiles.remove(items.nextElement());
                }
            }
            HashMap allBindings = ShortcutsFolder.processKeysFiles(mainFO, moduleKeyFiles.values());
            ShortcutsFolder.installBindings(allBindings);
        }
        catch (Exception e2) {
            ErrorManager.getDefault().notify((Throwable)e2);
        }
    }

    public static void installBindings(HashMap strokesMap) throws IOException {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Shortcuts");
        DataFolder f = DataFolder.findFolder((FileObject)fo);
        Iterator it = strokesMap.keySet().iterator();
        while (it.hasNext()) {
            Class<?> clazz;
            KeyStroke key = (KeyStroke)it.next();
            Action a = (Action)strokesMap.get(key);
            String name = Utilities.keyToString((KeyStroke)key);
            InstanceDataObject obj = InstanceDataObject.find((DataFolder)f, (String)name, clazz = a.getClass());
            if (obj != null) continue;
            InstanceDataObject.create((DataFolder)f, (String)name, clazz);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap processKeysFiles(FileObject mainKeysFile, Collection moduleKeysFiles) {
        FileLock lock;
        HashMap bindings;
        block11: {
            bindings = new HashMap(79);
            lock = null;
            if (mainKeysFile != null) {
                try {
                    Object var6_4;
                    try {
                        lock = mainKeysFile.lock();
                        ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(mainKeysFile.getURL()), bindings);
                        mainKeysFile.delete(lock);
                    }
                    catch (Exception x) {
                        ErrorManager.getDefault().notify((Throwable)x);
                        var6_4 = null;
                        lock.releaseLock();
                        break block11;
                    }
                    var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
            }
        }
        Iterator it = moduleKeysFiles.iterator();
        while (it.hasNext()) {
            Object var8_11;
            try {
                try {
                    FileObject fo = (FileObject)it.next();
                    lock = fo.lock();
                    ShortcutsFolder.addBindings(ShortcutsFolder.parseKeysFile(fo.getURL()), bindings);
                    fo.delete(lock);
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                    var8_11 = null;
                    lock.releaseLock();
                    continue;
                }
                var8_11 = null;
            }
            catch (Throwable throwable) {
                var8_11 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
        }
        return bindings;
    }

    private static void addBindings(Document doc, HashMap map) {
        NodeList nl = doc.getElementsByTagName(XML_BINDING);
        int i = 0;
        while (i < nl.getLength()) {
            String act = "<unknown>";
            try {
                String key = nl.item(i).getAttributes().getNamedItem(ATTR_BINDING_KEY).getNodeValue();
                act = nl.item(i).getAttributes().getNamedItem(ATTR_BINDING_ACTION).getNodeValue();
                KeyStroke stroke = Utilities.stringToKey((String)key);
                SystemAction action = SystemAction.get(Class.forName(act, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? ShortcutsFolder.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader)));
                map.put(stroke, action);
            }
            catch (ClassNotFoundException cnfe) {
                ErrorManager.getDefault().log(16, "Warning: action " + act + " not found to add key binding for.");
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ++i;
        }
    }

    public static void initShortcuts() {
        ShortcutsFolder.transformOldFiles();
        NbPlaces.getDefault();
        DataFolder f = NbPlaces.findSessionFolder("Shortcuts");
        shortcutsFolder = new ShortcutsFolder(f);
    }

    public static void refreshGlobalMap() {
        if (shortcutsFolder != null) {
            shortcutsFolder.recreate();
        }
    }

    public static void applyChanges(List changes) {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Shortcuts");
        DataFolder f = DataFolder.findFolder((FileObject)fo);
        ListIterator it = changes.listIterator();
        while (it.hasNext()) {
            ChangeRequest r = (ChangeRequest)it.next();
            try {
                if (r.add) {
                    if (InstanceDataObject.find((DataFolder)f, (String)r.instanceName(), (Class)r.instanceClass()) != null) continue;
                    InstanceDataObject.create((DataFolder)f, (String)r.instanceName(), (Class)r.instanceClass());
                    continue;
                }
                InstanceDataObject.remove((DataFolder)f, (String)r.instanceName(), (Class)r.instanceClass());
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ChangeRequest
    extends KeyActionPair {
        public boolean add;

        public ChangeRequest(KeyStroke key, Action action, boolean add) {
            super(Utilities.keyToString((KeyStroke)key), action);
            this.add = add;
        }
    }

    private static class KeyActionPair
    implements InstanceCookie {
        private String name;
        private Action action;

        public KeyActionPair(String name, Action action) {
            this.name = name;
            this.action = action;
        }

        public String instanceName() {
            return this.name;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.action.getClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.action;
        }
    }
}

