/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class FrameResidenceAction
extends CallableSystemAction
implements Presenter.Menu {
    private static final String FRAME_INSIDE = "inside";
    private static final String FRAME_OUTSIDE = "outside";
    static /* synthetic */ Class class$org$netbeans$core$actions$AttachFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$DetachFrameAction;

    protected String iconResource() {
        return "org/netbeans/core/resources/actions/frameResides.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$actions$AttachFrameAction == null ? (class$org$netbeans$core$actions$AttachFrameAction = FrameResidenceAction.class$("org.netbeans.core.actions.AttachFrameAction")) : class$org$netbeans$core$actions$AttachFrameAction);
    }

    public String getName() {
        return FrameResidenceAction.getBundleString("CTL_FrameResidenceAction");
    }

    public JMenuItem getMenuPresenter() {
        return this.createMenuPresenter(false);
    }

    public JMenuItem getPopupPresenter() {
        return this.createMenuPresenter(true);
    }

    public boolean isEnabled() {
        return WindowUtils.isMdi() && WindowUtils.getActiveMode() != null;
    }

    public void performAction() {
        WindowUtils.changeActiveMode(null, "org.netbeans.core.windows.frames.InternalFrameTypeImpl");
    }

    private JMenuItem createMenuPresenter(boolean popup) {
        JMenuPlus mainItem = new JMenuPlus();
        Actions.connect((JMenuItem)mainItem, (SystemAction)this, (boolean)popup);
        mainItem.addMenuListener(new ResidenceTypeListener());
        return mainItem;
    }

    private static final String getBundleString(String bundleStr) {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$actions$DetachFrameAction == null ? (class$org$netbeans$core$actions$DetachFrameAction = FrameResidenceAction.class$("org.netbeans.core.actions.DetachFrameAction")) : class$org$netbeans$core$actions$DetachFrameAction)).getString(bundleStr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ResidenceTypeListener
    implements MenuListener,
    ActionListener,
    Runnable {
        private ActionEvent evt;

        ResidenceTypeListener() {
        }

        public void menuCanceled(MenuEvent evt) {
        }

        public void menuSelected(MenuEvent evt) {
            ModeImpl activeMode = WindowUtils.getActiveMode();
            if (activeMode == null) {
                return;
            }
            String activeFrameType = activeMode.getFrameType();
            boolean isInside = "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(activeFrameType) || "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(activeFrameType);
            JMenu menu = (JMenu)evt.getSource();
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem();
            Actions.setMenuText((AbstractButton)mi, (String)FrameResidenceAction.getBundleString("CTL_FrameInside"), (boolean)true);
            mi.setActionCommand(FrameResidenceAction.FRAME_INSIDE);
            mi.addActionListener(this);
            mi.setSelected(isInside);
            menu.add(mi);
            mi = new JRadioButtonMenuItem();
            Actions.setMenuText((AbstractButton)mi, (String)FrameResidenceAction.getBundleString("CTL_FrameOutside"), (boolean)true);
            mi.setActionCommand(FrameResidenceAction.FRAME_OUTSIDE);
            mi.addActionListener(this);
            mi.setSelected(!isInside);
            menu.add(mi);
        }

        public void menuDeselected(MenuEvent evt) {
            ((JMenu)evt.getSource()).removeAll();
        }

        public synchronized void actionPerformed(ActionEvent evt) {
            this.evt = evt;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public synchronized void run() {
            if (this.evt == null) {
                return;
            }
            String resultType = null;
            ModeImpl activeMode = WindowUtils.getActiveMode();
            if (FrameResidenceAction.FRAME_INSIDE.equals(this.evt.getActionCommand())) {
                Object constr = activeMode.getCurrentConstraints();
                if (WindowUtils.findConstrainedMode(activeMode.getWorkspace(), constr) == null) {
                    activeMode.setConstraints(constr);
                }
                resultType = (constr = activeMode.getConstraints()) == null || "CENTER".equals(constr) ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : "org.netbeans.core.windows.frames.DesktopFrameTypeImpl";
            } else {
                activeMode.setCurrentConstraints(activeMode.getConstraints());
                activeMode.setConstraints(null);
                resultType = "org.netbeans.core.windows.frames.TopFrameTypeImpl";
            }
            activeMode.setFrameType(resultType);
            this.evt = null;
        }
    }
}

