/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.Util;
import org.openide.util.Utilities;

final class ChangeFirer {
    private final ModuleManager mgr;
    private final Set changes = new HashSet(100);
    private final Set modulesCreated = new HashSet(100);
    private final Set modulesDeleted = new HashSet(10);

    public ChangeFirer(ModuleManager mgr) {
        this.mgr = mgr;
    }

    public void change(Change c) {
        this.changes.add(c);
    }

    public void created(Module m) {
        this.modulesCreated.add(m);
    }

    public void deleted(Module m) {
        if (!this.modulesCreated.remove((Object)m)) {
            this.modulesDeleted.add(m);
        }
    }

    public void fire() {
        this.mgr.readOnly(true);
        try {
            try {
                TreeSet orderedChanges = new TreeSet(new OrderChanges());
                orderedChanges.addAll(this.changes);
                Iterator it = orderedChanges.iterator();
                while (it.hasNext()) {
                    Change c = (Change)it.next();
                    if (c.source instanceof Module) {
                        ((Module)((Object)c.source)).firePropertyChange0(c.prop, c.old, c.nue);
                        continue;
                    }
                    if (c.source == this.mgr) {
                        this.mgr.firePropertyChange(c.prop, c.old, c.nue);
                        continue;
                    }
                    throw new IllegalStateException("Strange source: " + c.source);
                }
                this.changes.clear();
                if (!this.modulesCreated.isEmpty() || !this.modulesDeleted.isEmpty()) {
                    this.mgr.fireModulesCreatedDeleted(this.modulesCreated, this.modulesDeleted);
                }
                this.modulesCreated.clear();
                this.modulesDeleted.clear();
            }
            catch (RuntimeException e) {
                Util.err.notify((Throwable)e);
                Object var5_6 = null;
                this.mgr.readOnly(false);
            }
            Object var5_5 = null;
            this.mgr.readOnly(false);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.mgr.readOnly(false);
            throw throwable;
        }
    }

    public static final class Change {
        private static int globalCount = 0;
        public final String prop;
        public final Object source;
        public final Object old;
        public final Object nue;
        final int count;

        public Change(Object source, String prop, Object old, Object nue) {
            this.source = source;
            this.prop = prop;
            this.old = old;
            this.nue = nue;
            this.count = globalCount++;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Change)) {
                return false;
            }
            Change c = (Change)o;
            return Utilities.compareObjects((Object)this.prop, (Object)c.prop) && Utilities.compareObjects((Object)this.source, (Object)c.source) && Utilities.compareObjects((Object)this.old, (Object)c.old) && Utilities.compareObjects((Object)this.nue, (Object)c.nue);
        }

        public int hashCode() {
            return this.source.hashCode() ^ (this.prop == null ? 0 : this.prop.hashCode());
        }

        public String toString() {
            return "Change[" + this.source + ":" + this.prop + ";" + this.old + "->" + this.nue + "]";
        }
    }

    private static final class OrderChanges
    implements Comparator {
        OrderChanges() {
        }

        public int compare(Object o1, Object o2) {
            Change c1 = (Change)o1;
            Change c2 = (Change)o2;
            int r = c1.count - c2.count;
            if (r != 0) {
                return r;
            }
            return System.identityHashCode(c1) - System.identityHashCode(c2);
        }
    }
}

