/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public final class InstalledFileLocatorImpl
extends InstalledFileLocator {
    public File locate(String relativePath, String codeNameBase, boolean localized) {
        File f = this.locate(relativePath, localized, System.getProperty("netbeans.user"));
        if (f != null) {
            return f;
        }
        f = this.locate(relativePath, localized, System.getProperty("netbeans.home"));
        if (f != null) {
            return f;
        }
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                f = this.locate(relativePath, localized, tok.nextToken());
                if (f == null) continue;
                return f;
            }
        }
        return null;
    }

    private File locate(String relativePath, boolean localized, String dir) {
        if (localized) {
            String ext;
            String basePath;
            int i = relativePath.lastIndexOf(46);
            if (i == -1 || i < relativePath.lastIndexOf(47)) {
                basePath = relativePath;
                ext = "";
            } else {
                basePath = relativePath.substring(0, i);
                ext = relativePath.substring(i);
            }
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                String locPath = basePath + (String)it.next() + ext;
                File f = new File(dir, locPath.replace('/', File.separatorChar));
                if (!f.exists()) continue;
                return f;
            }
            return null;
        }
        File f = new File(dir, relativePath.replace('/', File.separatorChar));
        if (f.exists()) {
            return f;
        }
        return null;
    }
}

