/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.core.projects.MemoryFileSystem;
import org.openide.filesystems.AbstractFileSystem;

public final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private Date created = new Date();
    private Hashtable entries = new Hashtable();

    private Entry e(String n) {
        Entry x;
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        if ((x = (Entry)this.entries.get(n)) == null) {
            x = new Entry();
            this.entries.put(n, x);
        }
        return x;
    }

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this.setSystemName("MemoryFileSystem");
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] resources) {
        this();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < resources.length) {
            sb.append(resources[i]);
            this.e((String)resources[i]).data = (byte[])(resources[i].endsWith("/") ? null : new byte[0]);
            ++i;
        }
    }

    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    public boolean isReadOnly() {
        return false;
    }

    public Enumeration attributes(String name) {
        return Collections.enumeration(this.e((String)name).attrs.keySet());
    }

    public String[] children(String f) {
        if (f.startsWith("/")) {
            f = f.substring(1);
        }
        if (f.length() > 0 && !f.endsWith("/")) {
            f = f + "/";
        }
        HashSet<String> l = new HashSet<String>();
        Iterator it = this.entries.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith(f) && f.trim().length() != 0) continue;
            int i = name.indexOf(47, f.length());
            String child = null;
            child = i > 0 ? name.substring(f.length(), i) : name.substring(f.length());
            if (child.trim().length() <= 0) continue;
            l.add(child);
        }
        return ((AbstractCollection)l).toArray(new String[0]);
    }

    public void createData(String name) throws IOException {
        this.e((String)name).data = new byte[0];
    }

    public void createFolder(String name) throws IOException {
        this.e((String)name).data = null;
    }

    public void delete(String name) throws IOException {
        this.entries.remove(name);
    }

    public void deleteAttributes(String name) {
    }

    public boolean folder(String name) {
        return this.e((String)name).data == null;
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        byte[] arr = this.e((String)name).data;
        if (arr == null) {
            arr = new byte[]{};
        }
        return new ByteArrayInputStream(arr);
    }

    public Date lastModified(String name) {
        Date d = this.e((String)name).last;
        return d == null ? this.created : d;
    }

    public void lock(String name) throws IOException {
    }

    public void markUnimportant(String name) {
    }

    public String mimeType(String name) {
        return (String)this.e((String)name).attrs.get("mimeType");
    }

    public OutputStream outputStream(String name) throws IOException {
        class Out
        extends ByteArrayOutputStream {
            private final /* synthetic */ String val$name;
            private final /* synthetic */ MemoryFileSystem this$0;

            Out(MemoryFileSystem this$0, String val$name) {
                this.this$0 = this$0;
                this.val$name = val$name;
            }

            public void close() throws IOException {
                super.close();
                MemoryFileSystem.access$000((MemoryFileSystem)this.this$0, (String)this.val$name).data = this.toByteArray();
                MemoryFileSystem.access$000((MemoryFileSystem)this.this$0, (String)this.val$name).last = new Date();
            }
        }
        return new Out(this, name);
    }

    public Object readAttribute(String name, String attrName) {
        return this.e((String)name).attrs.get(attrName);
    }

    public boolean readOnly(String name) {
        return false;
    }

    public void rename(String oldName, String newName) throws IOException {
        this.entries.put(newName, this.e(oldName));
    }

    public void renameAttributes(String oldName, String newName) {
    }

    public long size(String name) {
        byte[] d = this.e((String)name).data;
        return d == null ? 0L : (long)d.length;
    }

    public void unlock(String name) {
    }

    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        this.e((String)name).attrs.put(attrName, value);
    }

    public static void main(String[] args) {
        String[] res = new String[]{"/testFolder1/testFolder1/test.txt1", "/testFolder0/testFolder1/test.txt1", "/testFolder1/testFolder0/test.txt1", "/testFolder1/testFolder1/test.txt0", "/testFolder1/test.txt1", "/testFolder0/testFolder1/test.txt0", "/testFolder0/testFolder0/test.txt1", "/testFolder1/testFolder0/test.txt0", "/testFolder0/test.txt1", "/testFolder0/testFolder0/test.txt0", "/testFolder1/test.txt0", "/test.txt1", "/testFolder0/test.txt0", "/test.txt0", "/testFolder1/testFolder1/testFolder1/", "/testFolder0/testFolder1/testFolder1/", "/testFolder1/testFolder0/testFolder1/", "/testFolder1/testFolder1/testFolder0/", "/testFolder0/testFolder1/testFolder0/", "/testFolder0/testFolder0/testFolder1/", "/testFolder1/testFolder0/testFolder0/", "/testFolder1/testFolder1/", "/testFolder0/testFolder1/", "/testFolder0/testFolder0/testFolder0/", "/testFolder1/testFolder0/", "/testFolder1/", "/testFolder0/testFolder0/", "/testFolder0/"};
        new MemoryFileSystem(res);
    }

    static /* synthetic */ Entry access$000(MemoryFileSystem x0, String x1) {
        return x0.e(x1);
    }

    static final class Entry {
        public HashMap attrs = new HashMap();
        public byte[] data;
        public Date last;

        Entry() {
        }
    }
}

