/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.io.NbObjectInputStream;

public class BinaryFS
extends FileSystem {
    static final byte[] MAGIC = "org.netbeans.core.projects.cache.BinaryFS".getBytes();
    static final SystemAction[] NO_ACTIONS = new SystemAction[0];
    static final FileObject[] NO_CHILDREN = new FileObject[0];
    String binaryFile;
    byte[] content;
    private FileObject root;
    private Date lastModified = new Date();

    public BinaryFS(String binaryFile) {
        this.binaryFile = binaryFile;
        try {
            RandomAccessFile file = new RandomAccessFile(binaryFile, "r");
            byte[] magic = new byte[MAGIC.length];
            file.read(magic);
            int i = 0;
            while (i < MAGIC.length) {
                if (magic[i] != MAGIC[i]) {
                    throw new IOException("Bad magic header: " + new String(magic));
                }
                ++i;
            }
            this.content = new byte[(int)file.length() - MAGIC.length];
            file.readFully(this.content);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.root = new BFSFolder("", null, 0);
    }

    public FileObject findResource(String name) {
        if (name.length() == 0) {
            return this.root;
        }
        StringTokenizer st = new StringTokenizer(name, "/");
        FileObject fo = this.root;
        while (fo != null && st.hasMoreTokens()) {
            String next = st.nextToken();
            fo = fo.getFileObject(next, null);
        }
        return fo;
    }

    public SystemAction[] getActions() {
        return NO_ACTIONS;
    }

    public String getDisplayName() {
        return "BinaryFS[" + this.binaryFile + "]";
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isReadOnly() {
        return true;
    }

    private class BFSFolder
    extends BFSBase {
        Map childrenMap = Collections.EMPTY_MAP;

        public BFSFolder(String name, FileObject parent, int offset) {
            super(name, parent, offset);
        }

        public boolean isData() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException("Is a directory: " + (Object)((Object)this));
        }

        public FileObject[] getChildren() {
            this.initialize();
            return this.childrenMap.values().toArray(NO_CHILDREN);
        }

        public FileObject getFileObject(String name, String ext) {
            this.initialize();
            String fullName = ext == null ? name : name + "." + ext;
            return (FileObject)this.childrenMap.get(fullName);
        }

        protected void doInitialize(Pointer ptr) throws Exception {
            int files = ptr.getInt();
            if (files > 0) {
                this.childrenMap = new HashMap(files);
                int i = 0;
                while (i < files) {
                    String name = ptr.getString();
                    byte isFolder = ptr.getByte();
                    int off = ptr.getInt();
                    this.childrenMap.put(name, isFolder == 0 ? new BFSFile(name, this, off) : new BFSFolder(name, this, off));
                    ++i;
                }
            }
        }

        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFolder)) {
                return false;
            }
            BFSFolder f = (BFSFolder)_f;
            this.initialize();
            return this.childrenMap.equals(f.childrenMap);
        }
    }

    final class BFSFile
    extends BFSBase {
        private int len;
        private int contentOffset;
        private String uri;

        public BFSFile(String name, FileObject parent, int offset) {
            super(name, parent, offset);
        }

        public FileObject[] getChildren() {
            return NO_CHILDREN;
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        private byte[] data() throws IOException {
            if (this.len == -1) {
                throw new IllegalArgumentException();
            }
            return new Pointer(this.contentOffset).getBytes(this.len);
        }

        public InputStream getInputStream() throws FileNotFoundException {
            this.initialize();
            try {
                return this.len == -1 ? new URL(this.uri).openConnection().getInputStream() : new ByteArrayInputStream(this.data());
            }
            catch (Exception e) {
                FileNotFoundException x = new FileNotFoundException(e.getMessage());
                ErrorManager.getDefault().annotate((Throwable)x, (Throwable)e);
                throw x;
            }
        }

        public long getSize() {
            this.initialize();
            try {
                return this.len == -1 ? (long)new URL(this.uri).openConnection().getContentLength() : (long)this.len;
            }
            catch (Exception e) {
                System.err.println("exception in getSize() on " + this.name + ": " + e);
                return 0L;
            }
        }

        protected void doInitialize(Pointer ptr) throws Exception {
            this.len = ptr.getInt();
            this.contentOffset = ptr.getOffset();
            if (this.len == -1) {
                this.uri = ptr.getString();
            }
        }

        protected boolean specificEquals(BFSBase _f) {
            if (!(_f instanceof BFSFile)) {
                return false;
            }
            BFSFile f = (BFSFile)_f;
            this.initialize();
            f.initialize();
            if (this.len == -1 && f.len == -1) {
                return this.uri.equals(f.uri);
            }
            if (this.len != -1 && f.len != -1) {
                byte[] fdata;
                byte[] data;
                try {
                    data = this.data();
                    fdata = f.data();
                }
                catch (IOException ioe) {
                    return false;
                }
                if (data.length != fdata.length) {
                    return false;
                }
                int i = 0;
                while (i < data.length) {
                    if (data[i] != fdata[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    }

    final class AttrImpl {
        private int index;
        private String value;
        static /* synthetic */ Class class$org$openide$util$SharedClassObject;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        AttrImpl(int type, String textValue) {
            this.index = type;
            this.value = textValue;
        }

        public Object getValue(FileObject fo, String attrName) {
            try {
                switch (this.index) {
                    case 0: {
                        return Byte.valueOf(this.value);
                    }
                    case 1: {
                        return Short.valueOf(this.value);
                    }
                    case 2: {
                        return Integer.valueOf(this.value);
                    }
                    case 3: {
                        return Long.valueOf(this.value);
                    }
                    case 4: {
                        return Float.valueOf(this.value);
                    }
                    case 5: {
                        return Double.valueOf(this.value);
                    }
                    case 6: {
                        return Boolean.valueOf(this.value);
                    }
                    case 7: {
                        if (this.value.trim().length() != 1) break;
                        return new Character(this.value.charAt(0));
                    }
                    case 8: {
                        return this.value;
                    }
                    case 9: {
                        return new URL(this.value);
                    }
                    case 10: {
                        return this.methodValue(this.value, fo, attrName);
                    }
                    case 11: {
                        Class cls = this.findClass(this.value);
                        if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = AttrImpl.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(cls)) {
                            return SharedClassObject.findObject((Class)cls, (boolean)true);
                        }
                        return cls.newInstance();
                    }
                    case 12: {
                        return this.decodeValue(this.value);
                    }
                    default: {
                        throw new IllegalStateException("Bad index: " + this.index);
                    }
                }
            }
            catch (Exception exc) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate((Throwable)exc, "value = " + this.value);
                em.notify(1, (Throwable)exc);
            }
            return null;
        }

        private Object methodValue(String method, FileObject fo, String attr) throws Exception {
            int i = method.lastIndexOf(46);
            if (i != -1) {
                String methodName = this.value.substring(i + 1);
                String className = this.value.substring(0, i);
                Class cls = this.findClass(className);
                Object[][] objArray = new Object[][]{null, null, null};
                Method[] methArray = new Method[]{null, null, null};
                Class<?> fParam = fo.getClass();
                Class<?> sParam = attr.getClass();
                Method[] allMethods = cls.getDeclaredMethods();
                int j = 0;
                while (j < allMethods.length) {
                    if (allMethods[j].getName().equals(methodName)) {
                        Class<?>[] paramClss = allMethods[j].getParameterTypes();
                        if (paramClss.length == 0) {
                            if (methArray[0] == null) {
                                methArray[0] = allMethods[j];
                                objArray[0] = new Object[0];
                            }
                        } else if (paramClss.length == 2 && methArray[2] == null) {
                            if (paramClss[0].isAssignableFrom(fParam) && paramClss[1].isAssignableFrom(sParam)) {
                                methArray[2] = allMethods[j];
                                objArray[2] = new Object[]{fo, attr};
                                break;
                            }
                            if (paramClss[0].isAssignableFrom(sParam) && paramClss[1].isAssignableFrom(fParam)) {
                                methArray[2] = allMethods[j];
                                objArray[2] = new Object[]{attr, fo};
                                break;
                            }
                        } else if (paramClss.length == 1 && methArray[1] == null) {
                            if (paramClss[0].isAssignableFrom(fParam)) {
                                methArray[1] = allMethods[j];
                                objArray[1] = new Object[]{fo};
                            } else if (paramClss[0].isAssignableFrom(sParam)) {
                                methArray[1] = allMethods[j];
                                objArray[1] = new Object[]{attr};
                            }
                        }
                    }
                    ++j;
                }
                int k = 2;
                while (k >= 0) {
                    if (methArray[k] != null) {
                        ((AccessibleObject)methArray[k]).setAccessible(true);
                        return methArray[k].invoke(null, objArray[k]);
                    }
                    --k;
                }
            }
            throw new InstantiationException(this.value);
        }

        private Object decodeValue(String value) throws Exception {
            if (value == null || value.length() == 0) {
                return null;
            }
            byte[] bytes = new byte[value.length() / 2];
            int count = 0;
            int i = 0;
            while (i < value.length()) {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                i += 2;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
            return new NbObjectInputStream((InputStream)bis).readObject();
        }

        private Class findClass(String name) throws ClassNotFoundException {
            ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AttrImpl.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            String tname = Utilities.translate((String)name);
            if (c == null) {
                return Class.forName(tname);
            }
            return Class.forName(tname, true, c);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private abstract class BFSBase
    extends FileObject {
        private final FileObject parent;
        protected final String name;
        protected final int offset;
        private boolean initialized = false;
        private Map attrs = Collections.EMPTY_MAP;

        public BFSBase(String name, FileObject parent, int offset) {
            this.name = name;
            this.parent = parent;
            this.offset = offset;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof BFSBase)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            BFSBase f = (BFSBase)((Object)o);
            return f.getPath().equals(this.getPath()) && this.specificEquals(f);
        }

        public final int hashCode() {
            return this.getPath().hashCode();
        }

        protected abstract boolean specificEquals(BFSBase var1);

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        public boolean isReadOnly() {
            return true;
        }

        public void setImportant(boolean b) {
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            throw new IOException();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return BinaryFS.this;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isValid() {
            return true;
        }

        public Date lastModified() {
            return BinaryFS.this.lastModified;
        }

        public String getName() {
            int i = this.name.lastIndexOf(46);
            return i <= 0 ? this.name : this.name.substring(0, i);
        }

        public String getExt() {
            int i = this.name.lastIndexOf(46) + 1;
            return i <= 1 || i == this.name.length() ? "" : this.name.substring(i);
        }

        public String getNameExt() {
            return this.name;
        }

        public Object getAttribute(String attrName) {
            this.initialize();
            AttrImpl attr = (AttrImpl)this.attrs.get(attrName);
            if (attr != null) {
                FileObject topFO = null;
                try {
                    Class<?> mfoClass = Class.forName("org.openide.filesystems.MultiFileObject");
                    Field field = mfoClass.getDeclaredField("attrAskedFileObject");
                    ((AccessibleObject)field).setAccessible(true);
                    ThreadLocal attrAskedFileObject = (ThreadLocal)field.get(null);
                    topFO = (FileObject)attrAskedFileObject.get();
                    attrAskedFileObject.set(null);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                return attr.getValue(topFO == null ? this : topFO, attrName);
            }
            return null;
        }

        public Enumeration getAttributes() {
            this.initialize();
            if (this.attrs == null) {
                return EmptyEnumeration.EMPTY;
            }
            return Collections.enumeration(this.attrs.keySet());
        }

        protected final void initialize() {
            if (this.initialized) {
                return;
            }
            try {
                Pointer ptr = new Pointer(this.offset);
                int attrCount = ptr.getInt();
                if (attrCount > 0) {
                    this.attrs = new HashMap(attrCount);
                }
                int i = 0;
                while (i < attrCount) {
                    String name = ptr.getString();
                    byte type = ptr.getByte();
                    String value = ptr.getString();
                    this.attrs.put(name, new AttrImpl(type, value));
                    ++i;
                }
                this.doInitialize(ptr);
            }
            catch (Exception e) {
                System.err.println("exception in initialize() on " + this.name + ": " + e);
            }
            this.initialized = true;
        }

        protected abstract void doInitialize(Pointer var1) throws Exception;
    }

    class Pointer {
        int offset;

        public Pointer(int start) {
            this.offset = start;
        }

        public int getOffset() {
            return this.offset;
        }

        public void shift(int len) {
            this.offset += len;
        }

        public String toString() {
            return "Ptr[" + this.offset + "]";
        }

        public int getInt() throws IOException {
            int retVal = BinaryFS.this.content[this.offset++] & 0xFF | (BinaryFS.this.content[this.offset++] & 0xFF) << 8 | (BinaryFS.this.content[this.offset++] & 0xFF) << 16 | (BinaryFS.this.content[this.offset++] & 0xFF) << 24;
            return retVal;
        }

        protected byte getByte() throws IOException {
            return BinaryFS.this.content[this.offset++];
        }

        protected String getString() throws IOException {
            int len = this.getInt();
            String s = new String(BinaryFS.this.content, this.offset, len, "UTF-8");
            this.offset += len;
            return s;
        }

        private byte[] getBytes(int len) throws IOException {
            byte[] ret = new byte[len];
            System.arraycopy(BinaryFS.this.content, this.offset, ret, 0, len);
            this.offset += len;
            return ret;
        }
    }
}

