/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects.cache;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.netbeans.core.projects.cache.NonCacheManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NotImplementedException;

public abstract class LayerCacheManager {
    static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.projects.cache");
    private final File cacheDir;
    private static LayerCacheManager emptyManager = null;

    public static LayerCacheManager emptyManager() {
        if (emptyManager == null) {
            emptyManager = new NonCacheManager();
        }
        return emptyManager;
    }

    protected LayerCacheManager(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public final File getCacheDirectory() {
        return this.cacheDir;
    }

    public abstract boolean cacheExists();

    public abstract void cleanupCache() throws IOException;

    public boolean supportsLoad() {
        return true;
    }

    public FileSystem createEmptyFileSystem() throws IOException {
        if (this.supportsLoad()) {
            throw new NotImplementedException();
        }
        return new XMLFileSystem();
    }

    public FileSystem createLoadedFileSystem() throws IOException {
        if (!this.supportsLoad()) {
            throw new IOException("Does not support loading!");
        }
        FileSystem fs = this.createEmptyFileSystem();
        this.load(fs);
        return fs;
    }

    public void load(FileSystem fs) throws IOException {
        throw new NotImplementedException();
    }

    public void store(FileSystem fs, List urls) throws IOException {
        throw new NotImplementedException();
    }

    public FileSystem store(List urls) throws IOException {
        throw new NotImplementedException();
    }
}

