/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import org.openide.awt.JPopupMenuPlus;

public class ArrowsTabbedPaneUI
extends TabbedPaneUI {
    public static final int TAB_LIST_INDICATE_NONE = 0;
    public static final int TAB_LIST_INDICATE_CHECKBOX = 1;
    public static final int TAB_LIST_INDICATE_CHECKBOXALL = 2;
    public static final int TAB_LIST_INDICATE_RADIOBUTTON = 3;
    public static final int TAB_LIST_INDICATE_RADIOBUTTONALL = 4;
    private static final int TAB_LIST_INDICATE_DEFAULT = 3;
    private static final int TAB_LIST_INDICATE_MIN = 0;
    private static final int TAB_LIST_INDICATE_MAX = 4;
    private static final boolean SORT_TABLIST_DEFAULT = false;
    private static final String SORT_TEXT_DEFAULT = null;
    private static final int SIZE_MINIMUM = 1;
    private static final int SIZE_MAXIMUM = 2;
    private static final int SIZE_PREFERRED = 3;
    private static final int TAB_SPACEX = 2;
    private static final int TAB_SPACEY = 2;
    private static final int TAB_2SPACEX = 4;
    private static final int TAB_2SPACEY = 4;
    private static final int SPACE_TAB = 0;
    private static final int SPACE_ARROWS = 2;
    private static final int SPACE_TAB_BORDER_LEFT = 3;
    private static final int SPACE_TAB_BORDER_RIGHT = 3;
    private static final int SPACE_TAB_BORDER_TOP = 2;
    private static final int SPACE_TAB_BORDER_BOTTOM = 2;
    private static final int SPACE_TAB_TEXTICON = 3;
    private static final int SPACE_TAB_BORDER_LEFT_RIGHT = 6;
    private static final int SPACE_TAB_BORDER_TOP_BOTTOM = 4;
    private static final int SPACE_TAB_BORDER_LEFT_TEXTICON = 6;
    private static final Color COLOR_BORDER_LEFTTOP = UIManager.getColor("TabbedPane.lightHighlight");
    private static final Color COLOR_BORDER_RIGHTBOTTOM = UIManager.getColor("TabbedPane.darkShadow");
    private static final Color COLOR_BORDER_TABNOACTUAL = UIManager.getColor("TabbedPane.highlight");
    private static final Color COLOR_BACKGROUND_TABNOACTUAL = UIManager.getColor("TabbedPane.shadow");
    private static final Color COLOR_BORDER_FOCUS = UIManager.getColor("TabbedPane.focus");
    private static final String IMAGE_PACKAGE = "org/netbeans/core/resources/";
    private static final String IMAGE_ARROW_PREVIOUS_HORIZONTAL = "org/netbeans/core/resources/arrowleft.gif";
    private static final String IMAGE_ARROW_PREVIOUS_VERTICAL = "org/netbeans/core/resources/arrowtop.gif";
    private static final String IMAGE_ARROW_NEXT_HORIZONTAL = "org/netbeans/core/resources/arrowright.gif";
    private static final String IMAGE_ARROW_NEXT_VERTICAL = "org/netbeans/core/resources/arrowbottom.gif";
    private static final String IMAGE_LIST = "org/netbeans/core/resources/listoftabs.gif";
    private boolean sortTabsList = false;
    private int tabStart = 0;
    private boolean explicitTabStart = false;
    private int listTabIndicate = 3;
    private String sortText = SORT_TEXT_DEFAULT;
    private JPopupMenuPlus popupMenu = null;
    private JTabbedPane tabbedPane = null;
    private LayoutManager layoutManager = null;
    private Rectangle[] tabBounds = null;
    private Rectangle boundsArrowPrevious = null;
    private Rectangle boundsArrowNext = null;
    private Rectangle boundsArrowList = null;
    private Map images = new HashMap();
    private ChangeListener changeListener = new TabbedPaneChangeListener();
    private TabbedPaneMouseListener mouseListener = new TabbedPaneMouseListener();
    private TabbedPaneFocusListener focusListener = new TabbedPaneFocusListener();
    private MenuItemComparator comparator = null;
    private boolean recursePaintTabs = false;

    public ArrowsTabbedPaneUI() {
        this(false, 3, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(boolean sortTabsList) {
        this(sortTabsList, 3, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(int listTabIndicate) {
        this(false, listTabIndicate, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(String sortText) {
        this(false, 3, sortText);
    }

    public ArrowsTabbedPaneUI(boolean sortTabsList, int listTabIndicate) {
        this(sortTabsList, listTabIndicate, SORT_TEXT_DEFAULT);
    }

    public ArrowsTabbedPaneUI(boolean sortTabsList, String sortText) {
        this(sortTabsList, 3, sortText);
    }

    public ArrowsTabbedPaneUI(int listTabIndicate, String sortText) {
        this(false, listTabIndicate, sortText);
    }

    public ArrowsTabbedPaneUI(boolean sortTabsList, int listTabIndicate, String sortText) {
        this.setSortTabsList(sortTabsList);
        this.setListTabIndicate(listTabIndicate);
        this.setSortText(sortText);
    }

    public int tabForCoordinate(JTabbedPane tabbedPane, int x, int y) {
        int count = this.tabBounds != null ? this.tabBounds.length : 0;
        int i = 0;
        while (i < count) {
            if (this.tabBounds[i] != null && this.tabBounds[i].contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Rectangle getTabBounds(JTabbedPane tabbedPane, int index) {
        if (this.tabBounds != null && index >= 0 && index < this.tabBounds.length) {
            return this.tabBounds[index];
        }
        return null;
    }

    public int getTabRunCount(JTabbedPane tabbedPane) {
        return 1;
    }

    public static ComponentUI createUI(JComponent component) {
        return new ArrowsTabbedPaneUI();
    }

    public void installUI(JComponent component) {
        this.tabbedPane = (JTabbedPane)component;
        this.layoutManager = this.tabbedPane.getLayout();
        this.tabbedPane.setLayout(this.createLayoutManager());
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent component) {
        this.tabbedPane.setLayout(this.layoutManager);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
        }
        this.tabbedPane = null;
    }

    public void paint(Graphics graphics, JComponent component) {
        this.paintTabs(graphics);
        this.paintBorder(graphics);
    }

    public void setSortTabsList(boolean sortTabsList) {
        this.sortTabsList = sortTabsList;
    }

    public boolean getSortTabsList() {
        return this.sortTabsList;
    }

    private void changeSortTabsList(int popupMenuX, int popupMenuY) {
        this.sortTabsList = !this.sortTabsList;
        this.displayTabList(popupMenuX, popupMenuY);
    }

    public boolean setListTabIndicate(int listTabIndicate) {
        if (listTabIndicate < 0 || listTabIndicate > 4) {
            return false;
        }
        this.listTabIndicate = listTabIndicate;
        return true;
    }

    public int getListTabIndicate() {
        return this.listTabIndicate;
    }

    public void setSortText(String sortText) {
        this.sortText = sortText;
    }

    public String getSortText() {
        return this.sortText;
    }

    private LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    private void installListeners() {
        this.tabbedPane.addChangeListener(this.changeListener);
        this.tabbedPane.addMouseListener(this.mouseListener);
        this.tabbedPane.addFocusListener(this.focusListener);
    }

    private void uninstallListeners() {
        this.tabbedPane.removeChangeListener(this.changeListener);
        this.tabbedPane.removeMouseListener(this.mouseListener);
        this.tabbedPane.removeFocusListener(this.focusListener);
    }

    private void installKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, (InputMap)UIManager.get("TabbedPane.ancestorInputMap"));
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, (InputMap)UIManager.get("TabbedPane.focusInputMap"));
        SwingUtilities.replaceUIActionMap(this.tabbedPane, this.createActionMap());
    }

    private void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabbedPane, 0, null);
        SwingUtilities.replaceUIActionMap(this.tabbedPane, null);
    }

    private ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateRight", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                if (ArrowsTabbedPaneUI.this.tabbedPane.hasFocus() && ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() + 1 < ArrowsTabbedPaneUI.this.tabbedPane.getTabCount()) {
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() + 1);
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            }
        });
        map.put("navigateLeft", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                if (ArrowsTabbedPaneUI.this.tabbedPane.hasFocus() && ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() > 0) {
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() - 1);
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            }
        });
        map.put("requestFocus", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                ArrowsTabbedPaneUI.this.tabbedPane.requestFocus();
            }
        });
        return map;
    }

    private void paintTabs(Graphics graphics) {
        boolean display = true;
        int count = this.tabbedPane.getTabCount();
        if (this.tabStart >= count && count > 0) {
            this.tabStart = count - 1;
        }
        int actual = this.tabbedPane.getSelectedIndex();
        FontMetrics fontmetrics = graphics.getFontMetrics();
        Dimension maxdimension = this.calculateTabsDimension(fontmetrics);
        Rectangle rectangle = new Rectangle(0, 0, this.tabbedPane.getWidth(), this.tabbedPane.getHeight());
        Rectangle tabrectangle = new Rectangle(2, 2, 0, 0);
        this.tabBounds = new Rectangle[count];
        int firstDisplayed = -1;
        int lastDisplayed = -1;
        int i = 0;
        while (i < count) {
            if (i < this.tabStart) {
                this.tabBounds[i] = null;
            } else if (display && (display = this.calculateTabBounds(rectangle, i, maxdimension, fontmetrics, tabrectangle))) {
                this.tabBounds[i] = new Rectangle(tabrectangle);
                if (firstDisplayed == -1) {
                    firstDisplayed = i;
                }
                lastDisplayed = i;
            } else {
                this.tabBounds[i] = null;
            }
            ++i;
        }
        if (!this.explicitTabStart && firstDisplayed != -1 && !this.recursePaintTabs && this.tabBounds[actual] == null) {
            if (actual < firstDisplayed) {
                this.tabStart = actual;
                this.recursePaintTabs = true;
                try {
                    this.paintTabs(graphics);
                    Object var13_12 = null;
                    this.recursePaintTabs = false;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.recursePaintTabs = false;
                    throw throwable;
                }
                return;
            }
            if (actual > lastDisplayed) {
                if (this.tabStart + 1 < count) {
                    ++this.tabStart;
                    this.paintTabs(graphics);
                    return;
                }
            } else {
                throw new IllegalStateException("tabStart=" + this.tabStart + " actual=" + actual + " firstDisplayed=" + firstDisplayed + " lastDisplayed=" + lastDisplayed);
            }
        }
        this.calculateTabsCorrection(rectangle, maxdimension, this.tabStart > 0, !display);
        int index = this.tabStart;
        while (index < count && this.tabBounds[index] != null) {
            this.paintTab(graphics, index, index == actual, this.tabBounds[index], fontmetrics);
            ++index;
        }
        this.paintArrows(graphics, rectangle, maxdimension, this.tabStart > 0, !display);
    }

    private void paintBorder(Graphics graphics) {
        if (this.tabBounds != null && this.tabStart >= 0 && this.tabStart < this.tabBounds.length && this.tabBounds[this.tabStart] != null) {
            switch (this.tabbedPane.getTabPlacement()) {
                case 3: {
                    this.paintBorderBottom(graphics);
                    break;
                }
                case 2: {
                    this.paintBorderLeft(graphics);
                    break;
                }
                case 4: {
                    this.paintBorderRight(graphics);
                    break;
                }
                default: {
                    this.paintBorderTop(graphics);
                }
            }
        }
    }

    private void paintBorderTop(Graphics graphics) {
        int xstart = 0;
        int xend = this.tabbedPane.getWidth() - 1;
        int ystart = this.tabBounds[this.tabStart].y + this.tabBounds[this.tabStart].height;
        int yend = this.tabbedPane.getHeight() - 1;
        int xtabstart = this.calculateTabBoundsHorizontalStart();
        int xtabend = this.calculateTabBoundsHorizontalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(xstart, ystart, xtabstart, ystart);
        graphics.drawLine(xtabend, ystart, xend, ystart);
        graphics.drawLine(xstart, ystart, xstart, yend);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(xstart, yend, xend, yend);
        graphics.drawLine(xend, ystart, xend, yend);
        graphics.setColor(color);
    }

    private void paintBorderBottom(Graphics graphics) {
        int xstart = 0;
        int xend = this.tabbedPane.getWidth() - 1;
        int ystart = 0;
        int yend = this.tabBounds[this.tabStart].y;
        int xtabstart = this.calculateTabBoundsHorizontalStart();
        int xtabend = this.calculateTabBoundsHorizontalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(xstart, ystart, xend, ystart);
        graphics.drawLine(xstart, ystart, xstart, yend);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(xstart, yend, xtabstart, yend);
        graphics.drawLine(xtabend, yend, xend, yend);
        graphics.drawLine(xend, ystart, xend, yend);
        graphics.setColor(color);
    }

    private void paintBorderLeft(Graphics graphics) {
        int xstart = this.tabBounds[this.tabStart].x + this.tabBounds[this.tabStart].width;
        int xend = this.tabbedPane.getWidth() - 1;
        int ystart = 0;
        int yend = this.tabbedPane.getHeight() - 1;
        int ytabstart = this.calculateTabBoundsVerticalStart();
        int ytabend = this.calculateTabBoundsVerticalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(xstart, ystart, xend, ystart);
        graphics.drawLine(xstart, ystart, xstart, ytabstart);
        graphics.drawLine(xstart, ytabend, xstart, yend);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(xstart, yend, xend, yend);
        graphics.drawLine(xend, ystart, xend, yend);
        graphics.setColor(color);
    }

    private void paintBorderRight(Graphics graphics) {
        int xstart = 0;
        int xend = this.tabBounds[this.tabStart].x;
        int ystart = 0;
        int yend = this.tabbedPane.getHeight() - 1;
        int ytabstart = this.calculateTabBoundsVerticalStart();
        int ytabend = this.calculateTabBoundsVerticalEnd();
        Color color = graphics.getColor();
        graphics.setColor(COLOR_BORDER_LEFTTOP);
        graphics.drawLine(xstart, ystart, xend, ystart);
        graphics.drawLine(xstart, ystart, xstart, yend);
        graphics.setColor(COLOR_BORDER_RIGHTBOTTOM);
        graphics.drawLine(xstart, yend, xend, yend);
        graphics.drawLine(xend, ystart, xend, ytabstart);
        graphics.drawLine(xend, ytabend, xend, yend);
        graphics.setColor(color);
    }

    private int calculateTabBoundsHorizontalStart() {
        int actual = this.tabbedPane.getSelectedIndex();
        if (actual < 0 || this.tabBounds[actual] == null) {
            return 0;
        }
        return this.tabBounds[actual].x;
    }

    private int calculateTabBoundsHorizontalEnd() {
        int actual = this.tabbedPane.getSelectedIndex();
        if (actual < 0 || this.tabBounds[actual] == null) {
            return 0;
        }
        return this.tabBounds[actual].x + this.tabBounds[actual].width;
    }

    private int calculateTabBoundsVerticalStart() {
        int actual = this.tabbedPane.getSelectedIndex();
        if (actual < 0 || this.tabBounds[actual] == null) {
            return 0;
        }
        return this.tabBounds[actual].y;
    }

    private int calculateTabBoundsVerticalEnd() {
        int actual = this.tabbedPane.getSelectedIndex();
        if (actual < 0 || this.tabBounds[actual] == null) {
            return 0;
        }
        return this.tabBounds[actual].y + this.tabBounds[actual].height;
    }

    private void paintTab(Graphics graphics, int index, boolean istabactual, Rectangle tabrectangle, FontMetrics fontmetrics) {
        String text = this.tabbedPane.getTitleAt(index);
        this.paintTabBorder(graphics, istabactual, tabrectangle);
        int iconendx = this.paintTabIcon(graphics, index, tabrectangle);
        graphics.drawString(text, iconendx + this.calculateCenter(tabrectangle.width + tabrectangle.x - iconendx, fontmetrics.stringWidth(text)) - 1, tabrectangle.y + fontmetrics.getHeight() + this.calculateCenter(tabrectangle.height, fontmetrics.getHeight() + fontmetrics.getDescent()) - fontmetrics.getDescent());
    }

    private void paintTabBorder(Graphics graphics, boolean istabactual, Rectangle tabrectangle) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                this.paintTabBorderBottom(graphics, istabactual, this.tabbedPane.hasFocus(), tabrectangle);
                break;
            }
            case 2: {
                this.paintTabBorderLeft(graphics, istabactual, this.tabbedPane.hasFocus(), tabrectangle);
                break;
            }
            case 4: {
                this.paintTabBorderRight(graphics, istabactual, this.tabbedPane.hasFocus(), tabrectangle);
                break;
            }
            default: {
                this.paintTabBorderTop(graphics, istabactual, this.tabbedPane.hasFocus(), tabrectangle);
            }
        }
    }

    private void paintTabBorderTop(Graphics graphics, boolean istabactual, boolean hastabbedpanefocus, Rectangle tabrectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int slait = this.calculateTabSlait(tabrectangle);
        int[] x = new int[]{tabrectangle.x, tabrectangle.x, tabrectangle.x + slait, tabrectangle.x + tabrectangle.width, tabrectangle.x + tabrectangle.width};
        int[] y = new int[]{tabrectangle.y + tabrectangle.height, tabrectangle.y + slait, tabrectangle.y, tabrectangle.y, tabrectangle.y + tabrectangle.height};
        Color color = graphics.getColor();
        if (istabactual) {
            if (hastabbedpanefocus) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colors = colorArray3;
        if (!istabactual) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(x, y, x.length);
        }
        int i = 0;
        while (i < colors.length) {
            graphics.setColor(colors[i]);
            graphics.drawLine(x[0] + i, y[0] - i / 2, x[1] + i, y[1]);
            graphics.drawLine(x[1] + i, y[1], x[2], y[2] + i);
            graphics.drawLine(x[2], y[2] + i, x[3], y[3] + i);
            ++i;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray7 = new Color[2];
            colorArray7[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray7;
            colorArray7[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray8 = new Color[1];
            colorArray2 = colorArray8;
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colors = colorArray2;
        int i2 = 0;
        while (i2 < colors.length) {
            graphics.setColor(colors[i2]);
            graphics.drawLine(x[3] - i2, y[3] + 2 * i2, x[4] - i2, y[4] - i2);
            ++i2;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray9 = new Color[1];
            colorArray = colorArray9;
            colorArray9[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colors = colorArray;
        int i3 = 0;
        while (i3 < colors.length) {
            graphics.setColor(colors[i3]);
            graphics.drawLine(x[0] + 2, y[0] - i3 - 1, x[4], y[4] - i3 - 1);
            ++i3;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderBottom(Graphics graphics, boolean istabactual, boolean hastabbedpanefocus, Rectangle tabrectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int slait = this.calculateTabSlait(tabrectangle);
        int[] x = new int[]{tabrectangle.x, tabrectangle.x, tabrectangle.x + slait, tabrectangle.x + tabrectangle.width, tabrectangle.x + tabrectangle.width};
        int[] y = new int[]{tabrectangle.y, tabrectangle.y + tabrectangle.height - slait - 1, tabrectangle.y + tabrectangle.height - 1, tabrectangle.y + tabrectangle.height - 1, tabrectangle.y};
        Color color = graphics.getColor();
        if (istabactual) {
            if (hastabbedpanefocus) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colors = colorArray3;
        if (!istabactual) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(x, y, x.length);
        }
        int i = 0;
        while (i < colors.length) {
            graphics.setColor(colors[i]);
            graphics.drawLine(x[0] + i, y[0] + i / 2, x[1] + i, y[1]);
            graphics.drawLine(x[1] + i, y[1], x[2] + i, y[2]);
            ++i;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray7 = new Color[2];
            colorArray7[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray7;
            colorArray7[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray8 = new Color[1];
            colorArray2 = colorArray8;
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colors = colorArray2;
        int i2 = 0;
        while (i2 < colors.length) {
            graphics.setColor(colors[i2]);
            graphics.drawLine(x[2] + i2, y[2] - i2, x[3] - i2, y[3] - i2);
            graphics.drawLine(x[3] - i2, y[3] - i2, x[4] - i2, y[4] - i2 + 2 * i2);
            ++i2;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray9 = new Color[1];
            colorArray = colorArray9;
            colorArray9[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colors = colorArray;
        int i3 = 0;
        while (i3 < colors.length) {
            graphics.setColor(colors[i3]);
            graphics.drawLine(x[0] + 2, y[0] - i3 + 1, x[4], y[4] - i3 + 1);
            ++i3;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderLeft(Graphics graphics, boolean istabactual, boolean hastabbedpanefocus, Rectangle tabrectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int slait = this.calculateTabSlait(tabrectangle);
        int[] x = new int[]{tabrectangle.x + tabrectangle.width, tabrectangle.x + slait, tabrectangle.x, tabrectangle.x, tabrectangle.x + tabrectangle.width};
        int[] y = new int[]{tabrectangle.y, tabrectangle.y, tabrectangle.y + slait, tabrectangle.y + tabrectangle.height, tabrectangle.y + tabrectangle.height};
        Color color = graphics.getColor();
        if (istabactual) {
            if (hastabbedpanefocus) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colors = colorArray3;
        if (!istabactual) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(x, y, x.length);
        }
        int i = 0;
        while (i < colors.length) {
            graphics.setColor(colors[i]);
            graphics.drawLine(x[0] - i / 2, y[0] + i, x[1], y[1] + i);
            graphics.drawLine(x[1], y[1] + i, x[2] + i, y[2]);
            graphics.drawLine(x[2] + i, y[2], x[3] + i, y[3]);
            ++i;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray7 = new Color[2];
            colorArray7[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray7;
            colorArray7[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray8 = new Color[1];
            colorArray2 = colorArray8;
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colors = colorArray2;
        int i2 = 0;
        while (i2 < colors.length) {
            graphics.setColor(colors[i2]);
            graphics.drawLine(x[3] + 2 * i2, y[3] - i2, x[4] - i2, y[4] - i2);
            ++i2;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray9 = new Color[1];
            colorArray = colorArray9;
            colorArray9[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colors = colorArray;
        int i3 = 0;
        while (i3 < colors.length) {
            graphics.setColor(colors[i3]);
            graphics.drawLine(x[0] - 1, y[0] + 2, x[4] - 1, y[4]);
            ++i3;
        }
        graphics.setColor(color);
    }

    private void paintTabBorderRight(Graphics graphics, boolean istabactual, boolean hastabbedpanefocus, Rectangle tabrectangle) {
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        int slait = this.calculateTabSlait(tabrectangle);
        int[] x = new int[]{tabrectangle.x, tabrectangle.x + tabrectangle.width - slait, tabrectangle.x + tabrectangle.width, tabrectangle.x + tabrectangle.width, tabrectangle.x};
        int[] y = new int[]{tabrectangle.y, tabrectangle.y, tabrectangle.y + slait, tabrectangle.y + tabrectangle.height, tabrectangle.y + tabrectangle.height};
        Color color = graphics.getColor();
        if (istabactual) {
            if (hastabbedpanefocus) {
                Color[] colorArray4 = new Color[3];
                colorArray4[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray4[1] = COLOR_BORDER_LEFTTOP;
                colorArray3 = colorArray4;
                colorArray4[2] = COLOR_BORDER_FOCUS;
            } else {
                Color[] colorArray5 = new Color[2];
                colorArray5[0] = COLOR_BORDER_RIGHTBOTTOM;
                colorArray3 = colorArray5;
                colorArray5[1] = COLOR_BORDER_LEFTTOP;
            }
        } else {
            Color[] colorArray6 = new Color[2];
            colorArray6[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray3 = colorArray6;
            colorArray6[1] = COLOR_BORDER_TABNOACTUAL;
        }
        Color[] colors = colorArray3;
        if (!istabactual) {
            graphics.setColor(COLOR_BACKGROUND_TABNOACTUAL);
            graphics.fillPolygon(x, y, x.length);
        }
        int i = 0;
        while (i < colors.length) {
            graphics.setColor(colors[i]);
            graphics.drawLine(x[0] + i / 2, y[0] + i, x[1] - 1, y[1] + i);
            graphics.drawLine(x[1] - 1, y[1] + i, x[2] - i - 1, y[2]);
            ++i;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray7 = new Color[2];
            colorArray7[0] = COLOR_BORDER_RIGHTBOTTOM;
            colorArray2 = colorArray7;
            colorArray7[1] = COLOR_BORDER_FOCUS;
        } else {
            Color[] colorArray8 = new Color[1];
            colorArray2 = colorArray8;
            colorArray8[0] = COLOR_BORDER_RIGHTBOTTOM;
        }
        colors = colorArray2;
        int i2 = 0;
        while (i2 < colors.length) {
            graphics.setColor(colors[i2]);
            graphics.drawLine(x[2] - i2 - 1, y[2] + i2, x[3] - i2 - 1, y[3] - 2 * i2);
            graphics.drawLine(x[3] - i2 - 1, y[3] - i2, x[4] + 1, y[4] - i2);
            ++i2;
        }
        if (istabactual && hastabbedpanefocus) {
            Color[] colorArray9 = new Color[1];
            colorArray = colorArray9;
            colorArray9[0] = COLOR_BORDER_FOCUS;
        } else {
            colorArray = new Color[]{};
        }
        colors = colorArray;
        int i3 = 0;
        while (i3 < colors.length) {
            graphics.setColor(colors[i3]);
            graphics.drawLine(x[0] + 1, y[0] + 2, x[4] + 1, y[4]);
            ++i3;
        }
        graphics.setColor(color);
    }

    private int paintTabIcon(Graphics graphics, int index, Rectangle tabrectangle) {
        int slait = this.calculateTabSlait(tabrectangle);
        Icon icon = this.tabbedPane.getIconAt(index);
        if (icon == null) {
            return tabrectangle.x + slait;
        }
        icon.paintIcon(this.tabbedPane, graphics, tabrectangle.x + 3 + slait, tabrectangle.y + 2);
        return tabrectangle.x + slait + icon.getIconWidth() + 6;
    }

    private void paintArrows(Graphics graphics, Rectangle rectangle, Dimension maxdimension, boolean arrowprevious, boolean arrownext) {
        Point point1 = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        boolean ishorizontal = this.calculateArrowsPoints(rectangle, maxdimension, point1, point2, point3);
        this.paintArrowPrevious(graphics, arrowprevious && arrownext ? point1 : (arrowprevious ? point2 : null), ishorizontal);
        this.paintArrowNext(graphics, arrownext ? point3 : null, ishorizontal);
        this.paintArrowList(graphics, arrownext ? point2 : (arrowprevious ? point3 : null));
    }

    private void paintArrowPrevious(Graphics graphics, Point point, boolean ishorizontal) {
        if (point == null) {
            this.boundsArrowPrevious = null;
        } else {
            Image image = this.getImage(ishorizontal ? IMAGE_ARROW_PREVIOUS_HORIZONTAL : IMAGE_ARROW_PREVIOUS_VERTICAL);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowPrevious = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private void paintArrowNext(Graphics graphics, Point point, boolean ishorizontal) {
        if (point == null) {
            this.boundsArrowNext = null;
        } else {
            Image image = this.getImage(ishorizontal ? IMAGE_ARROW_NEXT_HORIZONTAL : IMAGE_ARROW_NEXT_VERTICAL);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowNext = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private void paintArrowList(Graphics graphics, Point point) {
        if (point == null) {
            this.boundsArrowList = null;
        } else {
            Image image = this.getImage(IMAGE_LIST);
            graphics.drawImage(image, point.x, point.y, this.tabbedPane);
            this.boundsArrowList = new Rectangle(point.x, point.y, this.getImageWidth(image), this.getImageHeight(image));
        }
    }

    private Image getImage(String imageType) {
        URL url;
        Image image = (Image)this.images.get(imageType);
        if (image == null && (url = this.getClass().getClassLoader().getResource(imageType)) != null && (image = Toolkit.getDefaultToolkit().getImage(url)) != null) {
            this.images.put(imageType, image);
        }
        return image;
    }

    private int getImageWidth(Image image) {
        return image.getWidth(this.tabbedPane);
    }

    private int getImageWidth(String image) {
        return this.getImage(image).getWidth(this.tabbedPane);
    }

    private int getImageHeight(Image image) {
        return image.getHeight(this.tabbedPane);
    }

    private int getImageHeight(String image) {
        return this.getImage(image).getHeight(this.tabbedPane);
    }

    private boolean calculateArrowsPoints(Rectangle rectangle, Dimension maxdimension, Point point1, Point point2, Point point3) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                return this.calculateArrowsPointsBottom(rectangle, maxdimension, point1, point2, point3);
            }
            case 2: {
                return this.calculateArrowsPointsLeft(rectangle, maxdimension, point1, point2, point3);
            }
            case 4: {
                return this.calculateArrowsPointsRight(rectangle, maxdimension, point1, point2, point3);
            }
        }
        return this.calculateArrowsPointsTop(rectangle, maxdimension, point1, point2, point3);
    }

    private boolean calculateArrowsPointsTop(Rectangle rectangle, Dimension maxdimension, Point point1, Point point2, Point point3) {
        int imageWidth = this.getImageWidth(IMAGE_ARROW_PREVIOUS_HORIZONTAL);
        point1.x = rectangle.x + rectangle.width - imageWidth - this.getImageWidth(IMAGE_ARROW_NEXT_HORIZONTAL) - this.getImageWidth(IMAGE_LIST) - 4;
        point1.y = rectangle.y + this.calculateCenter(maxdimension.height, this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL));
        point2.x = point1.x + imageWidth + 2;
        point2.y = point1.y;
        point3.x = point2.x + imageWidth + 2;
        point3.y = point1.y;
        return true;
    }

    private boolean calculateArrowsPointsBottom(Rectangle rectangle, Dimension maxdimension, Point point1, Point point2, Point point3) {
        int imageWidth = this.getImageWidth(IMAGE_ARROW_PREVIOUS_HORIZONTAL);
        point1.x = rectangle.x + rectangle.width - imageWidth - this.getImageWidth(IMAGE_ARROW_NEXT_HORIZONTAL) - this.getImageWidth(IMAGE_LIST) - 4;
        point1.y = rectangle.y + rectangle.height - maxdimension.height + this.calculateCenter(maxdimension.height, this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL));
        point2.x = point1.x + imageWidth + 2;
        point2.y = point1.y;
        point3.x = point2.x + imageWidth + 2;
        point3.y = point1.y;
        return true;
    }

    private boolean calculateArrowsPointsLeft(Rectangle rectangle, Dimension maxdimension, Point point1, Point point2, Point point3) {
        int imageHeight = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL);
        point1.x = rectangle.x + this.calculateCenter(maxdimension.width, this.getImageWidth(IMAGE_ARROW_PREVIOUS_VERTICAL));
        point1.y = rectangle.y + rectangle.height - imageHeight - this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) - this.getImageHeight(IMAGE_LIST) - 4;
        point2.x = point1.x;
        point2.y = point1.y + imageHeight + 2;
        point3.x = point1.x;
        point3.y = point2.y + imageHeight + 2;
        return false;
    }

    private boolean calculateArrowsPointsRight(Rectangle rectangle, Dimension maxdimension, Point point1, Point point2, Point point3) {
        int imageHeight = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL);
        point1.x = rectangle.x + rectangle.width - maxdimension.width + this.calculateCenter(maxdimension.width, this.getImageWidth(IMAGE_ARROW_PREVIOUS_VERTICAL));
        point1.y = rectangle.y + rectangle.height - imageHeight - this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) - this.getImageHeight(IMAGE_LIST) - 4;
        point2.x = point1.x;
        point2.y = point1.y + imageHeight + 2;
        point3.x = point1.x;
        point3.y = point2.y + imageHeight + 2;
        return false;
    }

    private Dimension calculateTabsDimension(FontMetrics fontmetrics) {
        int count = this.tabbedPane.getTabCount();
        if (fontmetrics == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = new Dimension(0, 0);
        int i = 0;
        while (i < count) {
            int temp = this.calculateTabWidth(i, fontmetrics);
            if (temp > dimension.width) {
                dimension.width = temp;
            }
            if ((temp = this.calculateTabHeight(i, fontmetrics)) > dimension.height) {
                dimension.height = temp;
            }
            ++i;
        }
        return dimension;
    }

    private void calculateTabsCorrection(Rectangle rectangle, Dimension maxdimension, boolean arrowleft, boolean arrowright) {
        int count = this.tabBounds.length;
        int tabend = this.tabStart;
        Point point1 = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        if (arrowleft || arrowright) {
            while (tabend < count && this.tabBounds[tabend] != null) {
                ++tabend;
            }
            if (tabend == count || this.tabBounds[tabend] == null) {
                --tabend;
            }
            if (tabend >= this.tabStart && this.tabBounds[tabend] != null) {
                this.calculateArrowsPoints(rectangle, maxdimension, point1, point2, point3);
                switch (this.tabbedPane.getTabPlacement()) {
                    case 2: 
                    case 4: {
                        this.calculateTabsCorrectionVertical(tabend, arrowleft && arrowright ? point1.x : point2.x);
                        break;
                    }
                    default: {
                        this.calculateTabsCorrectionHorizontal(tabend, arrowleft && arrowright ? point1.y : point2.y);
                    }
                }
            }
        }
    }

    private void calculateTabsCorrectionHorizontal(int tabend, int maxx) {
    }

    private void calculateTabsCorrectionVertical(int tabend, int maxy) {
    }

    private int calculateTabWidth(int index, FontMetrics fontmetrics) {
        Icon icon = this.tabbedPane.getIconAt(index);
        return fontmetrics.stringWidth(this.tabbedPane.getTitleAt(index)) + 6 + this.calculateTabSlait(this.calculateTabHeight(index, fontmetrics)) + (icon == null ? 0 : icon.getIconWidth() + 3);
    }

    private int calculateTabHeight(int index, FontMetrics fontmetrics) {
        int iconheight;
        int fontheight = fontmetrics.getHeight();
        Icon icon = this.tabbedPane.getIconAt(index);
        return (icon == null || fontheight > (iconheight = icon.getIconHeight()) ? fontheight : iconheight) + 4;
    }

    private boolean calculateTabBounds(Rectangle rectangle, int index, Dimension maxdimension, FontMetrics fontmetrics, Rectangle tabrectangle) {
        switch (this.tabbedPane.getTabPlacement()) {
            case 3: {
                return this.calculateTabBoundsBottom(rectangle, maxdimension, index, fontmetrics, tabrectangle);
            }
            case 2: {
                return this.calculateTabBoundsLeft(rectangle, maxdimension, index, fontmetrics, tabrectangle);
            }
            case 4: {
                return this.calculateTabBoundsRight(rectangle, maxdimension, index, fontmetrics, tabrectangle);
            }
        }
        return this.calculateTabBoundsTop(rectangle, maxdimension, index, fontmetrics, tabrectangle);
    }

    private boolean calculateTabBoundsTop(Rectangle rectangle, Dimension maxdimension, int index, FontMetrics fontmetrics, Rectangle tabrectangle) {
        tabrectangle.x += tabrectangle.width;
        tabrectangle.width = this.calculateTabWidth(index, fontmetrics) - 2;
        tabrectangle.y = rectangle.y;
        tabrectangle.height = maxdimension.height + 4 - 2;
        return this.canDisplayHorizontal(index, rectangle, tabrectangle);
    }

    private boolean calculateTabBoundsBottom(Rectangle rectangle, Dimension maxdimension, int index, FontMetrics fontmetrics, Rectangle tabrectangle) {
        tabrectangle.x += tabrectangle.width;
        tabrectangle.width = this.calculateTabWidth(index, fontmetrics) - 2;
        tabrectangle.height = maxdimension.height + 2 - 2;
        tabrectangle.y = rectangle.y + rectangle.height - tabrectangle.height;
        return this.canDisplayHorizontal(index, rectangle, tabrectangle);
    }

    private boolean calculateTabBoundsLeft(Rectangle rectangle, Dimension maxdimension, int index, FontMetrics fontmetrics, Rectangle tabrectangle) {
        tabrectangle.x = rectangle.x;
        tabrectangle.width = maxdimension.width + 6 - 2;
        tabrectangle.y += tabrectangle.height;
        tabrectangle.height = this.calculateTabHeight(index, fontmetrics) - 2;
        return this.canDisplayVertical(index, rectangle, tabrectangle);
    }

    private boolean calculateTabBoundsRight(Rectangle rectangle, Dimension maxdimension, int index, FontMetrics fontmetrics, Rectangle tabrectangle) {
        tabrectangle.width = maxdimension.width + 6 - 2;
        tabrectangle.x = rectangle.x + rectangle.width - tabrectangle.width;
        tabrectangle.y += tabrectangle.height;
        tabrectangle.height = this.calculateTabHeight(index, fontmetrics) - 2;
        return this.canDisplayVertical(index, rectangle, tabrectangle);
    }

    private int calculateTabSlait(Rectangle rectangle) {
        return this.calculateTabSlait(rectangle.height);
    }

    private int calculateTabSlait(int height) {
        return height / 4;
    }

    private boolean canDisplayHorizontal(int index, Rectangle rectangle, Rectangle tabrectangle) {
        int count = this.tabbedPane.getTabCount();
        int space = 0;
        if (this.tabStart > 0 && index + 1 < count) {
            space = this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL) + this.getImageHeight(IMAGE_ARROW_NEXT_HORIZONTAL) + this.getImageHeight(IMAGE_LIST) + 4;
        } else if (this.tabStart > 0 || index + 1 < count) {
            space = this.getImageHeight(IMAGE_ARROW_PREVIOUS_HORIZONTAL) + this.getImageHeight(IMAGE_LIST) + 2;
        }
        return tabrectangle.x + tabrectangle.width + space < rectangle.x + rectangle.width;
    }

    private boolean canDisplayVertical(int index, Rectangle rectangle, Rectangle tabrectangle) {
        int count = this.tabbedPane.getTabCount();
        int space = 0;
        if (this.tabStart > 0 && index + 1 < count) {
            space = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL) + this.getImageHeight(IMAGE_ARROW_NEXT_VERTICAL) + this.getImageHeight(IMAGE_LIST) + 4;
        } else if (this.tabStart > 0 || index + 1 < count) {
            space = this.getImageHeight(IMAGE_ARROW_PREVIOUS_VERTICAL) + this.getImageHeight(IMAGE_LIST) + 2;
        }
        return tabrectangle.y + tabrectangle.height + space < rectangle.y + rectangle.height;
    }

    private int getComponentWidth(Component component, int sizetype) {
        switch (sizetype) {
            case 1: {
                return component.getMinimumSize().width;
            }
            case 2: {
                return component.getMaximumSize().width;
            }
            case 3: {
                return component.getPreferredSize().width;
            }
        }
        return 0;
    }

    private int getComponentHeight(Component component, int sizetype) {
        switch (sizetype) {
            case 1: {
                return component.getMinimumSize().height;
            }
            case 2: {
                return component.getMaximumSize().height;
            }
            case 3: {
                return component.getPreferredSize().height;
            }
        }
        return 0;
    }

    private Dimension calculateSize(int sizetype) {
        int count = this.tabbedPane.getComponentCount();
        Dimension dimensiontab = new Dimension(0, 0);
        int i = 0;
        while (i < count) {
            Component component = this.tabbedPane.getComponent(i);
            int temp = this.getComponentWidth(component, sizetype);
            if (temp > dimensiontab.width) {
                dimensiontab.width = temp;
            }
            if ((temp = this.getComponentHeight(component, sizetype)) > dimensiontab.height) {
                dimensiontab.height = temp;
            }
            ++i;
        }
        return dimensiontab;
    }

    private int calculateCenter(int length, int in) {
        if (in >= length) {
            return 0;
        }
        return (length - in) / 2;
    }

    private Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new MenuItemComparator();
        }
        return this.comparator;
    }

    private void displayTabList(int x, int y) {
        JCheckBoxMenuItem menuitem;
        int count = this.tabbedPane.getTabCount();
        int actual = this.tabbedPane.getSelectedIndex();
        Object[] items = this.sortTabsList ? new Object[count] : null;
        this.initPopupMenu();
        if (this.sortText != null) {
            menuitem = new JCheckBoxMenuItem(this.sortText, this.sortTabsList);
            final int positionX = x;
            final int positionY = y;
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ArrowsTabbedPaneUI.this.changeSortTabsList(positionX, positionY);
                }
            });
            this.popupMenu.add(menuitem);
            this.popupMenu.add(new JSeparator());
        }
        int i = 0;
        while (i < count) {
            final int index = i;
            menuitem = this.listTabIndicate == 2 || this.listTabIndicate == 1 && i == actual ? new JCheckBoxMenuItem(this.tabbedPane.getTitleAt(i), i == actual) : (this.listTabIndicate == 4 || this.listTabIndicate == 3 && i == actual ? new JRadioButtonMenuItem(this.tabbedPane.getTitleAt(i), i == actual) : new JMenuItem(this.tabbedPane.getTitleAt(i)));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    ArrowsTabbedPaneUI.this.popupMenu.setVisible(false);
                    ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(index);
                    ArrowsTabbedPaneUI.this.explicitTabStart = false;
                    ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                    ArrowsTabbedPaneUI.this.tabbedPane.repaint();
                }
            });
            if (this.sortTabsList) {
                items[i] = menuitem;
            } else {
                this.popupMenu.add(menuitem);
            }
            ++i;
        }
        if (this.sortTabsList) {
            Arrays.sort(items, this.getComparator());
            int i2 = 0;
            while (i2 < count) {
                this.popupMenu.add((JMenuItem)items[i2]);
                ++i2;
            }
        }
        try {
            this.popupMenu.show((Component)this.tabbedPane, x, y);
        }
        catch (Exception exception) {
            this.popupMenu.setLocation(x, y);
            this.popupMenu.setVisible(true);
        }
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenuPlus();
        } else {
            this.popupMenu.removeAll();
        }
    }

    private class MenuItemComparator
    implements Comparator {
        MenuItemComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((JMenuItem)obj1).getText().toUpperCase().compareTo(((JMenuItem)obj2).getText().toUpperCase());
        }
    }

    private class TabbedPaneChangeListener
    implements ChangeListener {
        TabbedPaneChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            ArrowsTabbedPaneUI.this.explicitTabStart = false;
            ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }
    }

    private class TabbedPaneFocusListener
    implements FocusListener {
        TabbedPaneFocusListener() {
        }

        public void focusLost(FocusEvent event) {
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }

        public void focusGained(FocusEvent event) {
            ArrowsTabbedPaneUI.this.tabbedPane.repaint();
        }
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        TabbedPaneMouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            boolean dorepaint = false;
            int x = event.getX();
            int y = event.getY();
            if ((event.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowPrevious != null && ArrowsTabbedPaneUI.this.boundsArrowPrevious.contains(x, y)) {
                ArrowsTabbedPaneUI.this.tabStart--;
                dorepaint = true;
                ArrowsTabbedPaneUI.this.explicitTabStart = true;
            } else if ((event.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowNext != null && ArrowsTabbedPaneUI.this.boundsArrowNext.contains(x, y)) {
                ArrowsTabbedPaneUI.this.tabStart++;
                dorepaint = true;
                ArrowsTabbedPaneUI.this.explicitTabStart = true;
            } else if ((event.getModifiers() & 0x10) > 0 && ArrowsTabbedPaneUI.this.boundsArrowList != null && ArrowsTabbedPaneUI.this.boundsArrowList.contains(x, y)) {
                ArrowsTabbedPaneUI.this.displayTabList(x, y);
            } else {
                int index = ArrowsTabbedPaneUI.this.tabForCoordinate(ArrowsTabbedPaneUI.this.tabbedPane, x, y);
                if (index >= 0) {
                    if (ArrowsTabbedPaneUI.this.tabbedPane.getSelectedIndex() == index) {
                        ArrowsTabbedPaneUI.this.tabbedPane.requestFocus();
                    } else {
                        ArrowsTabbedPaneUI.this.tabbedPane.setSelectedIndex(index);
                        dorepaint = true;
                    }
                }
            }
            if (dorepaint) {
                ArrowsTabbedPaneUI.this.tabbedPane.revalidate();
                ArrowsTabbedPaneUI.this.tabbedPane.repaint();
            }
        }
    }

    private class TabbedPaneLayout
    implements LayoutManager {
        private TabbedPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(1);
        }

        public Dimension maximumLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return ArrowsTabbedPaneUI.this.calculateSize(3);
        }

        public void layoutContainer(Container container) {
            Rectangle boundstab = new Rectangle(0, 0, 0, 0);
            if (ArrowsTabbedPaneUI.this.tabbedPane != null) {
                int count = ArrowsTabbedPaneUI.this.tabbedPane.getTabCount();
                Dimension maxdimension = ArrowsTabbedPaneUI.this.calculateTabsDimension(ArrowsTabbedPaneUI.this.tabbedPane.getGraphics() != null ? ArrowsTabbedPaneUI.this.tabbedPane.getGraphics().getFontMetrics() : null);
                Insets insetstabbedpane = ArrowsTabbedPaneUI.this.tabbedPane.getInsets();
                if (insetstabbedpane == null) {
                    insetstabbedpane = new Insets(0, 0, 0, 0);
                }
                Rectangle rectangle = new Rectangle(2 + insetstabbedpane.left, 2 + insetstabbedpane.top, ArrowsTabbedPaneUI.this.tabbedPane.getWidth() - 4 - insetstabbedpane.left - insetstabbedpane.right, ArrowsTabbedPaneUI.this.tabbedPane.getHeight() - 4 - insetstabbedpane.top - insetstabbedpane.bottom);
                int i = 0;
                while (i < count) {
                    ArrowsTabbedPaneUI.this.tabbedPane.getComponent(i).setVisible(false);
                    ++i;
                }
                Component component = ArrowsTabbedPaneUI.this.tabbedPane.getSelectedComponent();
                if (component != null) {
                    switch (ArrowsTabbedPaneUI.this.tabbedPane.getTabPlacement()) {
                        case 3: {
                            this.calculateBoundsBottom(rectangle, maxdimension, boundstab);
                            break;
                        }
                        case 2: {
                            this.calculateBoundsLeft(rectangle, maxdimension, boundstab);
                            break;
                        }
                        case 4: {
                            this.calculateBoundsRight(rectangle, maxdimension, boundstab);
                            break;
                        }
                        default: {
                            this.calculateBoundsTop(rectangle, maxdimension, boundstab);
                        }
                    }
                    component.setVisible(true);
                    component.setBounds(boundstab);
                }
            }
        }

        private void calculateBoundsTop(Rectangle rectangle, Dimension maxdimension, Rectangle boundstab) {
            boundstab.x = rectangle.x;
            boundstab.width = rectangle.width;
            boundstab.y = rectangle.y + maxdimension.height + 0;
            boundstab.height = rectangle.height - boundstab.y;
        }

        private void calculateBoundsBottom(Rectangle rectangle, Dimension maxdimension, Rectangle boundstab) {
            boundstab.x = rectangle.x;
            boundstab.width = rectangle.width;
            boundstab.y = rectangle.y;
            boundstab.height = rectangle.height - boundstab.y - maxdimension.height - 0;
        }

        private void calculateBoundsLeft(Rectangle rectangle, Dimension maxdimension, Rectangle boundstab) {
            boundstab.x = rectangle.x + maxdimension.width + 0;
            boundstab.width = rectangle.width - boundstab.x;
            boundstab.y = rectangle.y;
            boundstab.height = rectangle.height;
        }

        private void calculateBoundsRight(Rectangle rectangle, Dimension maxdimension, Rectangle boundstab) {
            boundstab.x = rectangle.x;
            boundstab.width = rectangle.width - boundstab.x - maxdimension.width - 0;
            boundstab.y = rectangle.y;
            boundstab.height = rectangle.height;
        }
    }
}

