/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.IDESettings;
import org.netbeans.core.ui.ModuleBean;
import org.netbeans.core.ui.ModuleNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.windows.WindowManager;

public class ModuleNode
extends AbstractNode {
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ui$ModuleNode == null ? (class$org$netbeans$core$ui$ModuleNode = ModuleNode.class$("org.netbeans.core.ui.ModuleNode")) : class$org$netbeans$core$ui$ModuleNode));
    private static final String MODULE_ITEM_ICON_BASE = "org/netbeans/core/resources/moduleItem";
    private static final String MODULE_ITEM_DISABLED_BASE = "org/netbeans/core/resources/moduleItemDisabled";
    private static final String MODULE_ITEM_ERROR_BASE = "org/netbeans/core/resources/moduleItemError";
    private static final String MODULE_TEST_ITEM_ICON_BASE = "org/netbeans/core/resources/testModuleItem";
    private static final String MODULES_ICON_BASE = "org/netbeans/core/resources/modules";
    private static File lastChosenDir = null;
    private static NewType[] newTypes = null;
    private static ModuleBean.AllModulesBean allModules = ModuleBean.AllModulesBean.getDefault();
    static /* synthetic */ Class class$org$netbeans$core$ui$ModuleNode;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$core$ModuleNode$ModuleNewType;

    public ModuleNode() {
        super((Children)new Modules());
        this.setName("Modules");
        this.setDisplayName(bundle.getString("CTL_Modules_name"));
        this.setShortDescription(bundle.getString("CTL_Modules_hint"));
        this.setIconBase(MODULES_ICON_BASE);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$ui$ModuleNode == null ? (class$org$netbeans$core$ui$ModuleNode = ModuleNode.class$("org.netbeans.core.ui.ModuleNode")) : class$org$netbeans$core$ui$ModuleNode);
    }

    public Node cloneNode() {
        return new ModuleNode();
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = ModuleNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ModuleNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ModuleNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    protected Sheet createSheet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("sorting");
        set.setDisplayName(bundle.getString("LBL_ModuleNode_sheet_sorting"));
        set.put(((Modules)this.getChildren()).createSortingProperty());
        Sheet sheet = new Sheet();
        sheet.put(set);
        return sheet;
    }

    public NewType[] getNewTypes() {
        if (newTypes == null) {
            int size = Boolean.getBoolean("netbeans.module.test") ? 2 : 1;
            Lookup lkp = Lookup.getDefault();
            Lookup.Result result = lkp.lookup(new Lookup.Template(class$org$netbeans$core$ModuleNode$ModuleNewType == null ? (class$org$netbeans$core$ModuleNode$ModuleNewType = ModuleNode.class$("org.netbeans.core.ModuleNode$ModuleNewType")) : class$org$netbeans$core$ModuleNode$ModuleNewType));
            newTypes = new NewType[size + result.allInstances().size()];
            ModuleNode.newTypes[0] = new NewType(){

                public String getName() {
                    return bundle.getString("CTL_NewModuleByFile");
                }

                public void create() throws IOException {
                    ModuleNode.this.addFile(false);
                }
            };
            if (Boolean.getBoolean("netbeans.module.test")) {
                ModuleNode.newTypes[1] = new NewType(){

                    public String getName() {
                        return bundle.getString("CTL_NewTestModule");
                    }

                    public void create() throws IOException {
                        ModuleNode.this.addFile(true);
                    }
                };
            }
            Iterator instances = result.allInstances().iterator();
            while (instances.hasNext()) {
                ModuleNode.newTypes[size] = (NewType)instances.next();
                ++size;
            }
        }
        return newTypes;
    }

    void addFile(boolean reloadable) {
        ActionMap parent;
        ActionMap map;
        KeyStroke enter;
        Object value;
        final JFileChooser chooser = new JFileChooser();
        chooser.setFileHidingEnabled(false);
        InputMap im = chooser.getInputMap(1);
        if (im != null && (value = im.get(enter = KeyStroke.getKeyStroke(10, 0))) == null) {
            im.put(enter, "approveSelection");
        }
        if ((map = chooser.getActionMap()) != null && (parent = map.getParent()) != null) {
            final Action original = parent.get("approveSelection");
            parent.put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    File file = chooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        chooser.setCurrentDirectory(file);
                    } else if (original != null) {
                        original.actionPerformed(evt);
                    }
                }
            });
        }
        if (lastChosenDir != null) {
            chooser.setCurrentDirectory(lastChosenDir);
        }
        chooser.setFileSelectionMode(0);
        chooser.setApproveButtonText(bundle.getString("CTL_ModuleSelect"));
        chooser.setApproveButtonToolTipText(bundle.getString("CTL_ModuleSelectToolTip"));
        chooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return bundle.getString("CTL_ModuleSelectFilter");
            }

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar");
            }
        });
        int result = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        lastChosenDir = chooser.getCurrentDirectory();
        if (result == 0) {
            File jar = chooser.getSelectedFile();
            allModules.create(jar, reloadable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BooleanPropertyEditor
    extends PropertyEditorSupport {
        public String getAsText() {
            if (this.getValue() == null) {
                return null;
            }
            return (Boolean)this.getValue() != false ? "True" : "False";
        }

        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null) {
                this.setValue(null);
            } else if ("true".equalsIgnoreCase(text)) {
                this.setValue(Boolean.TRUE);
            } else if ("false".equalsIgnoreCase(text)) {
                this.setValue(Boolean.FALSE);
            } else {
                throw new IllegalArgumentException(text);
            }
        }

        public String[] getTags() {
            return new String[]{"True", "False"};
        }
    }

    private static final class CategoryNode
    extends AbstractNode {
        private final boolean libraries;
        private final boolean bridges;
        static /* synthetic */ Class class$org$netbeans$core$ui$ModuleNode$CategoryNode;

        public CategoryNode(boolean bridgeNotLib) {
            super((Children)new CategoryChildren(bridgeNotLib));
            this.setName(bridgeNotLib ? "bridges" : "libraries");
            this.setDisplayName(bundle.getString(bridgeNotLib ? "LBL_ModuleNode_bridges" : "LBL_ModuleNode_libraries"));
            this.setIconBase(ModuleNode.MODULES_ICON_BASE);
            this.libraries = !bridgeNotLib;
            this.bridges = bridgeNotLib;
        }

        public CategoryNode(String category) {
            super((Children)new CategoryChildren(category));
            this.setName(category);
            this.setIconBase(ModuleNode.MODULES_ICON_BASE);
            this.libraries = false;
            this.bridges = false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$core$ui$ModuleNode$CategoryNode == null ? (class$org$netbeans$core$ui$ModuleNode$CategoryNode = CategoryNode.class$("org.netbeans.core.ui.ModuleNode$CategoryNode")) : class$org$netbeans$core$ui$ModuleNode$CategoryNode);
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            if (this.libraries || this.bridges) {
                return s;
            }
            Sheet.Set ss = s.get("properties");
            class EnabledProp
            extends PropertySupport.ReadWrite
            implements PropertyChangeListener {
                private Set modules;
                private final String category;
                private final /* synthetic */ CategoryNode this$0;

                public EnabledProp(CategoryNode this$0, String category) {
                    super("enabled", Boolean.TYPE, ModuleNode.access$000().getString("PROP_modules_enabled"), ModuleNode.access$000().getString("HINT_modules_enabled"));
                    this.this$0 = this$0;
                    this.modules = new HashSet<E>();
                    this.category = category;
                    this.calculateModules();
                    ModuleNode.access$300().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)ModuleNode.access$300()));
                }

                public Object getValue() {
                    Boolean val = null;
                    Iterator<E> it = this.modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        if (m.isEnabled()) {
                            if (val == null) {
                                val = Boolean.TRUE;
                                continue;
                            }
                            if (val.booleanValue()) continue;
                            return null;
                        }
                        if (val == null) {
                            val = Boolean.FALSE;
                            continue;
                        }
                        if (!val.booleanValue()) continue;
                        return null;
                    }
                    return val;
                }

                public void setValue(Object val) {
                    boolean e = (Boolean)val;
                    Iterator<E> it = this.modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        m.setEnabled(e);
                    }
                }

                public boolean canWrite() {
                    Iterator<E> it = this.modules.iterator();
                    while (it.hasNext()) {
                        ModuleBean m = (ModuleBean)it.next();
                        if (m.isAutoload() || m.getJar() == null || m.isEager()) {
                            throw new IllegalStateException();
                        }
                        if (!m.isProblematic()) continue;
                        return false;
                    }
                    return true;
                }

                private void calculateModules() {
                    HashSet<ModuleBean> modules2 = new HashSet<ModuleBean>();
                    ModuleBean[] testing = ModuleNode.access$300().getModules();
                    int i = 0;
                    while (i < testing.length) {
                        if (testing[i].getJar() != null && !testing[i].isAutoload() && !testing[i].isEager() && this.category.equals(testing[i].getCategory())) {
                            modules2.add(testing[i]);
                            if (!this.modules.contains(testing[i])) {
                                testing[i].addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)testing[i]));
                            }
                        }
                        ++i;
                    }
                    this.modules = modules2;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    CategoryNode.access$701(this.this$0, "enabled", null, null);
                    this.calculateModules();
                }

                public PropertyEditor getPropertyEditor() {
                    return new BooleanPropertyEditor();
                }
            }
            ss.put((Node.Property)new EnabledProp(this, ((FeatureDescriptor)((Object)this)).getName()));
            return s;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$701(CategoryNode x0, String x1, Object x2, Object x3) {
            super.firePropertyChange(x1, x2, x3);
        }

        private static final class CategoryChildren
        extends Children.Keys
        implements PropertyChangeListener {
            private final String category;
            private final boolean bridgeNotLib;

            public CategoryChildren(boolean bridgeNotLib) {
                this.category = null;
                this.bridgeNotLib = bridgeNotLib;
            }

            public CategoryChildren(String category) {
                this.category = category;
                this.bridgeNotLib = false;
            }

            protected void addNotify() {
                this.refreshKeys();
                allModules.addPropertyChangeListener(this);
            }

            protected void removeNotify() {
                allModules.removePropertyChangeListener(this);
                this.setKeys(Collections.EMPTY_SET);
            }

            public Node findChild(String name) {
                allModules.waitForModules().waitFinished();
                this.refreshKeys();
                return super.findChild(name);
            }

            private void refreshKeys() {
                ArrayList<ModuleBean> keys = new ArrayList<ModuleBean>();
                ModuleBean[] modules = allModules.getModules();
                int i = 0;
                while (i < modules.length) {
                    boolean lib = modules[i].getJar() == null || modules[i].isAutoload();
                    boolean bridge = modules[i].isEager();
                    if (this.category != null && !lib && !bridge && this.category.equals(modules[i].getCategory())) {
                        keys.add(modules[i]);
                    } else if (this.category == null && !this.bridgeNotLib && lib) {
                        keys.add(modules[i]);
                    } else if (this.category == null && this.bridgeNotLib && bridge) {
                        keys.add(modules[i]);
                    }
                    ++i;
                }
                Collections.sort(keys, new Comparator(this){
                    private final /* synthetic */ CategoryChildren this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public int compare(Object o1, Object o2) {
                        ModuleBean m1 = (ModuleBean)o1;
                        ModuleBean m2 = (ModuleBean)o2;
                        return m1.getDisplayName().compareTo(m2.getDisplayName());
                    }
                });
                this.setKeys(keys);
            }

            protected Node[] createNodes(Object key) {
                return new Node[]{new Item((ModuleBean)key)};
            }

            public void propertyChange(PropertyChangeEvent ev) {
                this.refreshKeys();
            }
        }
    }

    private static class Modules
    extends Children.Keys
    implements PropertyChangeListener {
        private static final Object LIBRARY_KEY = new Object();
        private static final Object BRIDGE_KEY = new Object();
        private IDESettings settings;
        static /* synthetic */ Class class$org$netbeans$core$IDESettings;

        private void refreshKeys() {
            if (this.settings == null) {
                this.addNotify();
            }
            Object[] items = allModules.getModules();
            if (this.settings.getModulesSortMode() == 5) {
                class CategoryComparator
                implements Comparator {
                    private final /* synthetic */ Modules this$0;

                    CategoryComparator(Modules this$0) {
                        this.this$0 = this$0;
                    }

                    public int compare(Object o1, Object o2) {
                        if (o1 == Modules.access$400()) {
                            if (o2 == Modules.access$400()) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == Modules.access$400()) {
                            return -1;
                        }
                        if (o1 == Modules.access$500()) {
                            if (o2 == Modules.access$500()) {
                                return 0;
                            }
                            return 1;
                        }
                        if (o2 == Modules.access$500()) {
                            return -1;
                        }
                        String name1 = o1 instanceof ModuleBean ? ((ModuleBean)o1).getDisplayName() : (String)o1;
                        String name2 = o2 instanceof ModuleBean ? ((ModuleBean)o2).getDisplayName() : (String)o2;
                        return name1.compareTo(name2);
                    }
                }
                TreeSet<Object> categories = new TreeSet<Object>(new CategoryComparator(this));
                int i = 0;
                while (i < items.length) {
                    if (((ModuleBean)items[i]).getJar() == null || ((ModuleBean)items[i]).isAutoload()) {
                        categories.add(LIBRARY_KEY);
                    } else if (((ModuleBean)items[i]).isEager()) {
                        categories.add(BRIDGE_KEY);
                    } else {
                        String category = ((ModuleBean)items[i]).getCategory();
                        if (category != null) {
                            categories.add(category);
                        } else {
                            categories.add(items[i]);
                        }
                    }
                    ++i;
                }
                this.setKeys(categories);
            } else if (this.settings.getModulesSortMode() != 0) {
                if (this.settings.getModulesSortMode() == 3) {
                    int i = 0;
                    while (i < items.length) {
                        ((ModuleBean)items[i]).addPropertyChangeListener(this);
                        ++i;
                    }
                }
                ArrayList<Object> itemsL = new ArrayList<Object>(Arrays.asList(items));
                Collections.sort(itemsL, new Comparator(this){
                    private final /* synthetic */ Modules this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public int compare(Object o1, Object o2) {
                        ModuleBean m1 = (ModuleBean)o1;
                        ModuleBean m2 = (ModuleBean)o2;
                        switch (Modules.access$600(this.this$0).getModulesSortMode()) {
                            case 2: {
                                return m1.getCodeName().compareTo(m2.getCodeName());
                            }
                            case 3: {
                                int k1 = (m1.isReloadable() ? 0 : 4) + (m1.isAutoload() || m1.isEager() || m1.getJar() == null ? 2 : 0) + (m1.isEnabled() ? 0 : 1);
                                int k2 = (m2.isReloadable() ? 0 : 4) + (m2.isAutoload() || m2.isEager() || m2.getJar() == null ? 2 : 0) + (m2.isEnabled() ? 0 : 1);
                                if (k1 != k2) {
                                    return k1 - k2;
                                }
                            }
                            case 1: {
                                return m1.getDisplayName().compareTo(m2.getDisplayName());
                            }
                            case 4: {
                                File j1 = m1.getJar();
                                File j2 = m2.getJar();
                                if (j1 != null) {
                                    if (j2 != null) {
                                        return j1.compareTo(j2);
                                    }
                                    return 1;
                                }
                                if (j2 != null) {
                                    return -1;
                                }
                                return 0;
                            }
                        }
                        return 0;
                    }
                });
                this.setKeys(itemsL);
            } else {
                this.setKeys(items);
            }
        }

        Node.Property createSortingProperty() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = Modules.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            return new PropertySupport.ReadWrite(this, "sorted", Integer.TYPE, bundle.getString("PROP_ModuleNode_sorted"), bundle.getString("HINT_ModuleNode_sorted")){
                private final /* synthetic */ Modules this$0;
                {
                    this.this$0 = this$0;
                }

                public Object getValue() {
                    return new Integer(Modules.access$600(this.this$0).getModulesSortMode());
                }

                public void setValue(Object o) {
                    Modules.access$600(this.this$0).setModulesSortMode((Integer)o);
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public void restoreDefaultValue() {
                    this.setValue(new Integer(5));
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortingModeEditor();
                }
            };
        }

        public void addNotify() {
            this.settings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = Modules.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            allModules.addPropertyChangeListener(this);
            this.settings.addPropertyChangeListener(this);
            this.refreshKeys();
        }

        public void removeNotify() {
            this.settings.removePropertyChangeListener(this);
            allModules.removePropertyChangeListener(this);
            ModuleBean[] items = allModules.getModules();
            int i = 0;
            while (i < items.length) {
                items[i].removePropertyChangeListener(this);
                ++i;
            }
        }

        public Node findChild(String name) {
            allModules.waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(name);
        }

        public void propertyChange(PropertyChangeEvent ev) {
            this.refreshKeys();
        }

        protected Node[] createNodes(Object key) {
            if (key == LIBRARY_KEY) {
                return new Node[]{new CategoryNode(false)};
            }
            if (key == BRIDGE_KEY) {
                return new Node[]{new CategoryNode(true)};
            }
            if (key instanceof String) {
                return new Node[]{new CategoryNode((String)key)};
            }
            return new Node[]{new Item((ModuleBean)key)};
        }

        static /* synthetic */ Object access$400() {
            return LIBRARY_KEY;
        }

        static /* synthetic */ Object access$500() {
            return BRIDGE_KEY;
        }

        static /* synthetic */ IDESettings access$600(Modules x0) {
            return x0.settings;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static final class SortingModeEditor
        extends PropertyEditorSupport {
            private final String[] tags = new String[]{ModuleNode.access$000().getString("LBL_ModuleNode_SORT_UNSORTED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_DISPLAYNAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CODENAME"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_ENABLED"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_URL"), ModuleNode.access$000().getString("LBL_ModuleNode_SORT_CATEGORY")};

            public String[] getTags() {
                return this.tags;
            }

            public String getAsText() {
                return this.tags[(Integer)this.getValue()];
            }

            public void setAsText(String text) {
                int i = 0;
                while (i < this.tags.length) {
                    if (this.tags[i].equals(text)) {
                        this.setValue(new Integer(i));
                        return;
                    }
                    ++i;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    static class Item
    extends AbstractNode
    implements PropertyChangeListener {
        private ModuleBean item;
        static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
        static /* synthetic */ Class class$org$netbeans$core$ui$ModuleNode$Item;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$ToolsAction;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class array$Ljava$lang$String;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        public Item(ModuleBean item) {
            super(Children.LEAF);
            this.item = item;
            this.setName(item.getCodeNameBase());
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = Item.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            item.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)item));
            this.updateDisplayStuff();
            this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)item));
            String filename = "Modules/" + item.getCodeNameBase().replace('.', '-') + ".xml";
            FileObject xml = Repository.getDefault().getDefaultFileSystem().findResource(filename);
            if (xml != null) {
                try {
                    this.getCookieSet().add((Node.Cookie)DataObject.find((FileObject)xml));
                }
                catch (DataObjectNotFoundException donfe) {
                    ErrorManager.getDefault().notify(16, (Throwable)donfe);
                }
            } else if (item.getJar() != null) {
                ErrorManager.getDefault().log(16, "WARNING - ModuleNode.Item could not find " + filename);
            }
        }

        private void updateDisplayStuff() {
            this.setDisplayName(this.item.getDisplayName());
            this.setShortDescription(this.item.getShortDescription());
            this.setIconBase(this.item.isEnabled() ? (this.item.isReloadable() ? ModuleNode.MODULE_TEST_ITEM_ICON_BASE : ModuleNode.MODULE_ITEM_ICON_BASE) : (this.item.isProblematic() ? ModuleNode.MODULE_ITEM_ERROR_BASE : ModuleNode.MODULE_ITEM_DISABLED_BASE));
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateDisplayStuff();
            this.firePropertyChange(null, null, null);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$core$ui$ModuleNode$Item == null ? (class$org$netbeans$core$ui$ModuleNode$Item = Item.class$("org.netbeans.core.ui.ModuleNode$Item")) : class$org$netbeans$core$ui$ModuleNode$Item);
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = Item.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = Item.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = Item.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        public void destroy() {
            this.item.delete();
        }

        public boolean canDestroy() {
            return !this.item.isAutoscan() && this.item.getJar() != null;
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("properties");
            Sheet.Set sse = Sheet.createExpertSet();
            s.put(sse);
            try {
                PropertySupport.Reflection p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getDisplayName", null);
                p.setName("displayName");
                p.setDisplayName(bundle.getString("PROP_modules_name"));
                p.setShortDescription(bundle.getString("HINT_modules_name"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getSpecificationVersion", null);
                p.setName("specificationVersion");
                p.setDisplayName(bundle.getString("PROP_modules_specversion"));
                p.setShortDescription(bundle.getString("HINT_modules_specversion"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getImplementationVersion", null);
                p.setName("implementationVersion");
                p.setDisplayName(bundle.getString("PROP_modules_implversion"));
                p.setShortDescription(bundle.getString("HINT_modules_implversion"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getShortDescription", null);
                p.setName("shortDescription");
                p.setDisplayName(bundle.getString("PROP_modules_shortDescription"));
                p.setShortDescription(bundle.getString("HINT_modules_shortDescription"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getLongDescription", null);
                p.setName("longDescription");
                p.setDisplayName(bundle.getString("PROP_modules_longDescription"));
                p.setShortDescription(bundle.getString("HINT_modules_longDescription"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getCategory", null);
                p.setName("category");
                p.setDisplayName(bundle.getString("PROP_modules_category"));
                p.setShortDescription(bundle.getString("HINT_modules_category"));
                ss.put((Node.Property)p);
                class EnabledOrReloadableProp
                extends PropertySupport.Reflection {
                    private final /* synthetic */ Item this$0;

                    public EnabledOrReloadableProp(Item this$0, String getter, String setter) throws NoSuchMethodException {
                        super((Object)Item.access$100(this$0), Boolean.TYPE, getter, setter);
                        this.this$0 = this$0;
                    }

                    public boolean canWrite() {
                        if (!super.canWrite()) {
                            return false;
                        }
                        if (((FeatureDescriptor)((Object)this)).getName().equals("enabled")) {
                            return Item.access$100(this.this$0).getJar() != null && !Item.access$100(this.this$0).isProblematic() && !Item.access$100(this.this$0).isAutoload() && !Item.access$100(this.this$0).isEager();
                        }
                        if (((FeatureDescriptor)((Object)this)).getName().equals("reloadable")) {
                            return Item.access$100(this.this$0).getJar() != null && (Item.access$100(this.this$0).isReloadable() || Item.access$100(this.this$0).getJar().getParentFile().canWrite());
                        }
                        throw new IllegalStateException();
                    }
                }
                p = new EnabledOrReloadableProp(this, "isEnabled", "setEnabled");
                p.setName("enabled");
                p.setDisplayName(bundle.getString("PROP_modules_enabled"));
                p.setShortDescription(bundle.getString("HINT_modules_enabled"));
                ss.put((Node.Property)p);
                if (Boolean.getBoolean("netbeans.module.test")) {
                    p = new EnabledOrReloadableProp(this, "isReloadable", "setReloadable");
                    p.setName("reloadable");
                    p.setDisplayName(bundle.getString("PROP_modules_reloadable"));
                    p.setShortDescription(bundle.getString("HINT_modules_reloadable"));
                    ss.put((Node.Property)p);
                }
                p = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String, "getCodeName", null);
                p.setName("codeName");
                p.setDisplayName(bundle.getString("PROP_modules_codename"));
                p.setShortDescription(bundle.getString("HINT_modules_codename"));
                sse.put((Node.Property)p);
                if (this.item.getJar() != null) {
                    p = new PropertySupport.Reflection((Object)this.item, class$java$io$File == null ? (class$java$io$File = Item.class$("java.io.File")) : class$java$io$File, "getJar", null);
                    p.setName("jar");
                    p.setDisplayName(bundle.getString("PROP_modules_jar"));
                    p.setShortDescription(bundle.getString("HINT_modules_jar"));
                    sse.put((Node.Property)p);
                }
                class ClasspathProperty
                extends PropertySupport.ReadOnly {
                    static /* synthetic */ Class class$java$lang$String;
                    private final /* synthetic */ Item this$0;

                    public ClasspathProperty(Item this$0) {
                        super("classpath", Item.access$200(), ModuleNode.access$000().getString("PROP_modules_classpath"), ModuleNode.access$000().getString("HINT_modules_classpath"));
                        this.this$0 = this$0;
                    }

                    public Object getValue() throws InvocationTargetException {
                        String cp = Item.access$100(this.this$0).getEffectiveClasspath();
                        if (this.getValueType() == (class$java$lang$String == null ? (class$java$lang$String = ClasspathProperty.class$("java.lang.String")) : class$java$lang$String)) {
                            return cp;
                        }
                        try {
                            Constructor<T> c = this.getValueType().getConstructor(class$java$lang$String == null ? (class$java$lang$String = ClasspathProperty.class$("java.lang.String")) : class$java$lang$String);
                            return c.newInstance(cp);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                }
                sse.put((Node.Property)new ClasspathProperty(this));
                p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isAutoload", null);
                p.setName("autoload");
                p.setDisplayName(bundle.getString("PROP_modules_autoload"));
                p.setShortDescription(bundle.getString("HINT_modules_autoload"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isEager", null);
                p.setName("eager");
                p.setDisplayName(bundle.getString("PROP_modules_eager"));
                p.setShortDescription(bundle.getString("HINT_modules_eager"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Item.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProvides", null);
                p.setName("provides");
                p.setDisplayName(bundle.getString("PROP_modules_provides"));
                p.setShortDescription(bundle.getString("HINT_modules_provides"));
                sse.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)this.item, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Item.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "getProblemDescriptions", null);
                p.setName("problemDescriptions");
                p.setDisplayName(bundle.getString("PROP_modules_problemDescriptions"));
                p.setShortDescription(bundle.getString("HINT_modules_problemDescriptions"));
                sse.put((Node.Property)p);
            }
            catch (NoSuchMethodException nsme) {
                ErrorManager.getDefault().notify((Throwable)nsme);
            }
            return s;
        }

        private static Class getNbClassPathOrStringClass() {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Item.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            try {
                return l.loadClass("org.openide.execution.NbClassPath");
            }
            catch (ClassNotFoundException cnfe) {
                return class$java$lang$String == null ? (class$java$lang$String = Item.class$("java.lang.String")) : class$java$lang$String;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ ModuleBean access$100(Item x0) {
            return x0.item;
        }

        static /* synthetic */ Class access$200() {
            return Item.getNbClassPathOrStringClass();
        }
    }
}

