/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class NbLabelA11y
extends JLabel {
    private boolean isFocusable = false;
    private boolean isFocused = false;

    public NbLabelA11y() {
    }

    public NbLabelA11y(String label) {
        this();
        this.setText(label);
    }

    public NbLabelA11y(boolean focusable) {
        this();
        this.setA11yFocus(focusable);
    }

    public NbLabelA11y(boolean isFocusable, String a11yName, String a11yDesc) {
        this(isFocusable);
        this.setA11yContext(a11yName, a11yDesc);
    }

    public void setA11yContext(String a11yName, String a11yDesc) {
        if (a11yName == "" && this.getAccessibleContext().getAccessibleName() == null && this.getText() != "") {
            this.getAccessibleContext().setAccessibleName(this.getText());
        }
        if (a11yDesc == "" && this.getAccessibleContext().getAccessibleDescription() == null && this.getToolTipText() != "") {
            this.getAccessibleContext().setAccessibleDescription(this.getToolTipText());
        }
        if (a11yName != "") {
            this.getAccessibleContext().setAccessibleName(a11yName);
        }
        if (a11yDesc != "") {
            this.getAccessibleContext().setAccessibleDescription(a11yDesc);
        }
    }

    public void setA11yFocus(boolean a11yFocus) {
        this.isFocusable = a11yFocus;
        this.setRequestFocusEnabled(a11yFocus);
        if (a11yFocus) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent event) {
                    NbLabelA11y.this.isFocused = true;
                    NbLabelA11y.this.repaint();
                }

                public void focusLost(FocusEvent event) {
                    NbLabelA11y.this.isFocused = false;
                    NbLabelA11y.this.repaint();
                }
            });
        }
        this.repaint();
    }

    public void setA11yAll(boolean a11yFocus, String a11yName, String a11yDesc) {
        this.setA11yFocus(a11yFocus);
        this.setA11yContext(a11yName, a11yDesc);
    }

    public boolean isFocusTraversable() {
        return this.isFocusable;
    }

    public void paintComponent(Graphics g) {
        if (this.ui != null) {
            try {
                this.ui.update(g, this);
                Object var3_2 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                g.dispose();
                throw throwable;
            }
        }
        if (this.isFocused) {
            Dimension size = this.getSize();
            g.setColor(UIManager.getColor("Button.focus"));
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }
}

