/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class WelcomePanel
extends JPanel {
    private ResourceBundle bundle;
    private ResourceBundle bundle1;
    private static final URL INFO_URL;
    private static final String TIPS_FOLDER = "TipsOfTheDay";
    private static final String BORDER_PROPERTY = "originalBorder";
    private static final String HELP_CTX_PROPERTY = "helpCtx";
    private static final String DESCRIPTION_PROPERTY = "welcomeDescription";
    private static Color backgroundColor;
    private static Color borderShadowColor;
    private static Color borderHighlightColor;
    private IDESettings ideSettings = (IDESettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = WelcomePanel.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
    private int tipIndex = -1;
    private List tips;
    private JPanel jPanelButton;
    private JCheckBox showOnStartupCheckBox;
    private JButton closeButton;
    private JEditorPane contextBrowser;
    private JButton nextTipButton;
    private JLabel jLabelTipTitle;
    private JEditorPane tipsBrowser;
    private JPanel buttonSetPanel;
    private JPanel jPanelHtml;
    private JPanel jPanelTip;
    private JLabel jLabelHtmlTitle;
    private JPanel jPanelTipButton;
    private JButton prevTipButton;
    private JScrollPane tipsScrollPane;
    private JScrollPane contextBrowserScroll;
    private GettingStartedFolder gettingStartedFolder;
    private static String tmpEncoding;
    private static Dialog gettingStartedDialog;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$core$ui$WelcomePanel;

    public WelcomePanel() {
        this.bundle1 = this.bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ui$WelcomePanel == null ? (class$org$netbeans$core$ui$WelcomePanel = WelcomePanel.class$("org.netbeans.core.ui.WelcomePanel")) : class$org$netbeans$core$ui$WelcomePanel));
        try {
            backgroundColor = new Color(Integer.parseInt(this.bundle.getString("COLOR_WelcomeBACKGROUND"), 16));
        }
        catch (Exception exc) {
            backgroundColor = this.getBackground();
        }
        try {
            borderShadowColor = new Color(Integer.parseInt(this.bundle.getString("COLOR_WelcomeBorderShadow"), 16));
        }
        catch (Exception exc) {
            borderShadowColor = null;
        }
        try {
            borderHighlightColor = new Color(Integer.parseInt(this.bundle.getString("COLOR_WelcomeBorderHighlight"), 16));
        }
        catch (Exception exc) {
            borderHighlightColor = null;
        }
        this.initComponents();
        this.findTips();
        if (this.tips.isEmpty()) {
            this.remove(this.jPanelTip);
        }
        this.jLabelHtmlTitle.setFont(this.jLabelHtmlTitle.getFont().deriveFont(1));
        this.jLabelTipTitle.setFont(this.jLabelTipTitle.getFont().deriveFont(1));
        this.setBackgroundColor(backgroundColor);
        this.showOnStartupCheckBox.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.showOnStartupCheckBox.setSelected(!this.ideSettings.getShowTipsOnStartup());
        this.showOnStartupCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WelcomePanel.this.ideSettings.setShowTipsOnStartup(e.getStateChange() != 1);
            }
        });
        try {
            DataFolder df = NbPlaces.getDefault().welcome();
            this.startLoading(df);
            this.contextBrowser.setPage(INFO_URL);
            this.tipsBrowser.setPage(INFO_URL);
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        HyperlinkListener hpl = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    StatusDisplayer.getDefault().setStatusText(WelcomePanel.this.bundle.getString("CTL_OpeningBrowser"));
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                    StatusDisplayer.getDefault().setStatusText("");
                }
            }
        };
        this.contextBrowser.addHyperlinkListener(hpl);
        this.tipsBrowser.addHyperlinkListener(hpl);
        MouseAdapter mouselistenertipbutton = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                Object o = e.getSource();
                if (o instanceof JButton) {
                    ((JButton)o).setBorder(new BevelBorder(0));
                }
            }

            public void mouseExited(MouseEvent e) {
                Object o = e.getSource();
                if (o instanceof JButton) {
                    ((JButton)o).setBorder(new EmptyBorder(2, 2, 2, 2));
                    WelcomePanel.this.changeFocus();
                }
            }
        };
        this.nextTipButton.addMouseListener(mouselistenertipbutton);
        this.prevTipButton.addMouseListener(mouselistenertipbutton);
        this.restore();
        this.initAccessibility();
    }

    private void initComponents() {
        this.jPanelHtml = new JPanel();
        this.contextBrowserScroll = new JScrollPane();
        this.contextBrowser = new JEditorPane();
        this.jLabelHtmlTitle = new JLabel();
        this.buttonSetPanel = new JPanel();
        this.jPanelButton = new JPanel();
        this.showOnStartupCheckBox = new JCheckBox();
        this.closeButton = new JButton();
        this.jPanelTip = new JPanel();
        this.jLabelTipTitle = new JLabel();
        this.jPanelTipButton = new JPanel();
        this.nextTipButton = new JButton();
        this.prevTipButton = new JButton();
        this.tipsScrollPane = new JScrollPane();
        this.tipsBrowser = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.setName("");
        this.jPanelHtml.setLayout(new GridBagLayout());
        this.jPanelHtml.setBorder(new EtchedBorder());
        this.jPanelHtml.setRequestFocusEnabled(false);
        this.contextBrowserScroll.setPreferredSize(new Dimension(420, 170));
        this.contextBrowserScroll.setRequestFocusEnabled(false);
        this.contextBrowser.setEditable(false);
        this.contextBrowser.setText("Context browser");
        this.contextBrowser.setRequestFocusEnabled(false);
        this.contextBrowser.setEditorKit(new HTMLEditorKit());
        this.contextBrowserScroll.setViewportView(this.contextBrowser);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.jPanelHtml.add((Component)this.contextBrowserScroll, gridBagConstraints);
        this.jLabelHtmlTitle.setLabelFor(this.buttonSetPanel);
        this.jLabelHtmlTitle.setText(this.bundle.getString("LABEL_WelcomeHTMLPages"));
        this.jLabelHtmlTitle.setForeground(Color.black);
        this.jLabelHtmlTitle.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.jPanelHtml.add((Component)this.jLabelHtmlTitle, gridBagConstraints);
        this.buttonSetPanel.setLayout(new GridBagLayout());
        this.buttonSetPanel.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.jPanelHtml.add((Component)this.buttonSetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.jPanelHtml, gridBagConstraints);
        this.jPanelButton.setLayout(new GridBagLayout());
        this.jPanelButton.setRequestFocusEnabled(false);
        this.showOnStartupCheckBox.setText(this.bundle.getString("CTL_NEXTSTARTUP"));
        this.showOnStartupCheckBox.setNextFocusableComponent(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanelButton.add((Component)this.showOnStartupCheckBox, gridBagConstraints);
        this.closeButton.setText(this.bundle.getString("CTL_CLOSE"));
        this.jPanelButton.add((Component)this.closeButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(17, 12, 11, 11);
        this.add((Component)this.jPanelButton, gridBagConstraints);
        this.jPanelTip.setLayout(new GridBagLayout());
        this.jPanelTip.setBorder(new EtchedBorder());
        this.jPanelTip.setRequestFocusEnabled(false);
        this.jLabelTipTitle.setLabelFor(this.tipsBrowser);
        this.jLabelTipTitle.setText(this.bundle.getString("LABEL_WelcomeTipPages"));
        this.jLabelTipTitle.setForeground(Color.black);
        this.jLabelTipTitle.setHorizontalAlignment(2);
        this.jLabelTipTitle.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.jPanelTip.add((Component)this.jLabelTipTitle, gridBagConstraints);
        this.jPanelTipButton.setLayout(new GridBagLayout());
        this.jPanelTipButton.setRequestFocusEnabled(false);
        this.nextTipButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/core/resources/actions/tipOfTheDay.gif")));
        this.nextTipButton.setText(this.bundle1.getString("CTL_NEXT_BUTTON"));
        this.nextTipButton.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.nextTipButton.setHorizontalAlignment(2);
        this.nextTipButton.setNextFocusableComponent(this.prevTipButton);
        this.nextTipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WelcomePanel.this.nextTipButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 10);
        this.jPanelTipButton.add((Component)this.nextTipButton, gridBagConstraints);
        this.prevTipButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/core/resources/actions/tipOfTheDay.gif")));
        this.prevTipButton.setText(this.bundle1.getString("CTL_PREV_BUTTON"));
        this.prevTipButton.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.prevTipButton.setHorizontalAlignment(2);
        this.prevTipButton.setNextFocusableComponent(this.tipsBrowser);
        this.prevTipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WelcomePanel.this.prevTipButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 10);
        this.jPanelTipButton.add((Component)this.prevTipButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 12);
        this.jPanelTip.add((Component)this.jPanelTipButton, gridBagConstraints);
        this.tipsScrollPane.setPreferredSize(new Dimension(420, 120));
        this.tipsBrowser.setEditable(false);
        this.tipsBrowser.setFont(new Font("Dialog", 0, 11));
        this.tipsBrowser.setRequestFocusEnabled(false);
        this.tipsBrowser.setEditorKit(new HTMLEditorKit());
        this.tipsBrowser.setNextFocusableComponent(this.showOnStartupCheckBox);
        this.tipsScrollPane.setViewportView(this.tipsBrowser);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        this.jPanelTip.add((Component)this.tipsScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.jPanelTip, gridBagConstraints);
    }

    private void prevTipButtonActionPerformed(ActionEvent evt) {
        this.prevTip();
    }

    private void nextTipButtonActionPerformed(ActionEvent evt) {
        this.nextTip();
    }

    JButton getCloseButton() {
        return this.closeButton;
    }

    public void waitFinished() {
        this.gettingStartedFolder.instanceFinished();
    }

    void startLoading(DataFolder folder) {
        this.gettingStartedFolder = new GettingStartedFolder(folder, this.buttonSetPanel);
    }

    void restore() {
        this.tipIndex = this.ideSettings.getLastTip();
        this.showOnStartupCheckBox.setSelected(!this.ideSettings.getShowTipsOnStartup());
        this.nextTip();
    }

    private void findTips() {
        this.tips = new ArrayList(50);
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(TIPS_FOLDER);
        if (fo != null) {
            DataFolder f = DataFolder.findFolder((FileObject)fo);
            DataObject[] kids = f.getChildren();
            int i = 0;
            while (i < kids.length) {
                FileObject prim = kids[i].getPrimaryFile();
                if (prim.hasExt("html")) {
                    try {
                        this.tips.add(prim.getURL());
                    }
                    catch (FileStateInvalidException fsie) {
                        ErrorManager.getDefault().notify(16, (Throwable)fsie);
                    }
                }
                ++i;
            }
        }
    }

    void nextTip() {
        if (this.tips.isEmpty()) {
            return;
        }
        if (this.tipIndex >= this.tips.size()) {
            this.tipIndex = 0;
        }
        ++this.tipIndex;
        if (this.tipIndex == this.tips.size()) {
            this.tipIndex = 0;
        }
        this.ideSettings.setLastTip(this.tipIndex);
        this.showCurrentTip();
    }

    void prevTip() {
        if (this.tips.isEmpty()) {
            return;
        }
        if (this.tipIndex >= this.tips.size()) {
            this.tipIndex = 0;
        }
        --this.tipIndex;
        if (this.tipIndex == -1) {
            this.tipIndex = this.tips.size() - 1;
        }
        this.ideSettings.setLastTip(this.tipIndex);
        this.showCurrentTip();
    }

    private void showCurrentTip() {
        URL url = (URL)this.tips.get(this.tipIndex);
        try {
            this.tipsBrowser.setPage(url);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        this.changeFocus();
    }

    private void updateButtonPanelSize() {
        this.buttonSetPanel.setPreferredSize(null);
        this.buttonSetPanel.setMinimumSize(null);
        this.jPanelTipButton.setPreferredSize(null);
        this.jPanelTipButton.setMinimumSize(null);
        Dimension d1 = this.buttonSetPanel.getPreferredSize();
        Dimension d2 = this.jPanelTipButton.getPreferredSize();
        if (d1.width < d2.width) {
            this.buttonSetPanel.setPreferredSize(new Dimension(d2.width, d1.height));
            this.buttonSetPanel.setMinimumSize(new Dimension(d2.width, d1.height));
        } else {
            this.jPanelTipButton.setPreferredSize(new Dimension(d1.width, d2.height));
            this.jPanelTipButton.setMinimumSize(new Dimension(d1.width, d2.height));
        }
    }

    void changeFocus() {
        this.closeButton.requestFocus();
    }

    private static String getEncodingFromMeta(URL url) {
        tmpEncoding = null;
        try {
            EncParser p = new EncParser(DTD.getDTD("html32"));
            p.parse(new InputStreamReader(url.openStream()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tmpEncoding;
    }

    public static synchronized void showGettingStarted() {
        WelcomePanel wPanel = null;
        if (gettingStartedDialog == null) {
            WelcomePanel gettingStartedComponent;
            wPanel = gettingStartedComponent = new WelcomePanel();
            DialogDescriptor descriptor = new DialogDescriptor((Object)gettingStartedComponent, NbBundle.getBundle((Class)(class$org$netbeans$core$ui$WelcomePanel == null ? (class$org$netbeans$core$ui$WelcomePanel = WelcomePanel.class$("org.netbeans.core.ui.WelcomePanel")) : class$org$netbeans$core$ui$WelcomePanel)).getString("CTL_START_TITLE"), false, new Object[0], null, 0, null, null);
            gettingStartedDialog = DialogDisplayer.getDefault().createDialog(descriptor);
            if (gettingStartedDialog instanceof JDialog) {
                ((JDialog)gettingStartedDialog).getRootPane().setDefaultButton(gettingStartedComponent.getCloseButton());
            }
            gettingStartedComponent.getCloseButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (gettingStartedComponent.getCloseButton().equals(evt.getSource())) {
                        ((Component)gettingStartedDialog).setVisible(false);
                        gettingStartedDialog.dispose();
                    }
                }
            });
            gettingStartedDialog.addWindowListener(new WindowAdapter(){
                static /* synthetic */ Class class$org$netbeans$core$ui$WelcomePanel;

                public void windowClosed(WindowEvent e) {
                    Class clazz = class$org$netbeans$core$ui$WelcomePanel == null ? (class$org$netbeans$core$ui$WelcomePanel = 9.class$("org.netbeans.core.ui.WelcomePanel")) : class$org$netbeans$core$ui$WelcomePanel;
                    synchronized (clazz) {
                        gettingStartedDialog = null;
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            ((Component)gettingStartedDialog).setBackground(backgroundColor);
        }
        gettingStartedDialog.show();
        if (wPanel != null) {
            final WelcomePanel c = wPanel;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    gettingStartedDialog.requestFocus();
                    c.requestDefaultFocus();
                }
            });
        }
    }

    public static void main(String[] args) {
        WelcomePanel.showGettingStarted();
    }

    boolean setBackgroundColor(Color color) {
        if (color == null) {
            return false;
        }
        this.setBackground(color);
        this.jPanelHtml.setBackground(color);
        this.buttonSetPanel.setBackground(color);
        this.jPanelTip.setBackground(color);
        this.jPanelTipButton.setBackground(color);
        this.nextTipButton.setBackground(color);
        this.prevTipButton.setBackground(color);
        this.jPanelButton.setBackground(color);
        this.showOnStartupCheckBox.setBackground(color);
        this.closeButton.setBackground(color);
        this.jPanelHtml.setBorder(new EtchedBorder(borderHighlightColor, borderShadowColor));
        this.jPanelTip.setBorder(new EtchedBorder(borderHighlightColor, borderShadowColor));
        return true;
    }

    public void initAccessibility() {
        ResourceBundle b = NbBundle.getBundle(this.getClass());
        this.showOnStartupCheckBox.setMnemonic(b.getString("MNE_NEXTSTARTUP").charAt(0));
        this.nextTipButton.setMnemonic(b.getString("MNE_NEXT_BUTTON").charAt(0));
        this.prevTipButton.setMnemonic(b.getString("MNE_PREV_BUTTON").charAt(0));
        this.nextTipButton.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_nextTipButton"));
        this.prevTipButton.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_prevTipButton"));
        this.contextBrowser.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_contextBrowser"));
        this.contextBrowser.getAccessibleContext().setAccessibleName(b.getString("ACSN_contextBrowser"));
        this.tipsBrowser.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_tipsBrowser"));
        this.tipsBrowser.getAccessibleContext().setAccessibleName(b.getString("ACSN_tipsBrowser"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_closeButton"));
        this.showOnStartupCheckBox.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_showOnStartupCheckBox"));
        this.getAccessibleContext().setAccessibleDescription(b.getString("ACSD_welcomePanel"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            INFO_URL = new URL("nbresloc:/org/netbeans/core/resources/welcome/info.html");
        }
        catch (MalformedURLException mfue) {
            throw new ExceptionInInitializerError(mfue);
        }
        tmpEncoding = null;
    }

    private static class EncParser
    extends Parser {
        public EncParser(DTD dtd) {
            super(dtd);
        }

        protected void handleError(int ln, String msg) {
        }

        protected void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
            String content;
            SimpleAttributeSet atts;
            Element elem = tag.getElement();
            if (elem == this.dtd.meta && (atts = this.getAttributes()) != null && (content = (String)atts.getAttribute(HTML.Attribute.CONTENT)) != null) {
                if ("content-type".equalsIgnoreCase((String)atts.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                    if (content.indexOf("=") >= 0) {
                        this.handleCharset(content.substring(content.indexOf("=") + 1));
                    } else {
                        this.handleCharset(content);
                    }
                } else if ("charset".equalsIgnoreCase((String)atts.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                    this.handleCharset(content);
                }
            }
        }

        private void handleCharset(String param) {
            try {
                InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), param);
            }
            catch (UnsupportedEncodingException ex) {
                return;
            }
            tmpEncoding = param;
        }
    }

    final class GettingStartedFolder
    extends FolderInstance
    implements NodeListener {
        private JPanel buttonPanel;
        private Map descriptionURLs;
        static /* synthetic */ Class class$javax$swing$JPanel;
        static /* synthetic */ Class class$org$openide$util$actions$Presenter$Toolbar;
        static /* synthetic */ Class class$javax$swing$JComponent;

        public GettingStartedFolder(DataFolder folder, JPanel panel) {
            super(folder);
            this.buttonPanel = panel;
            this.recreate();
            this.instanceFinished();
        }

        public GettingStartedFolder(DataFolder folder) {
            super(folder);
            this.recreate();
            this.instanceFinished();
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent e) {
        }

        public String instanceName() {
            return "javax.swing.JPanel";
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$javax$swing$JPanel == null ? (class$javax$swing$JPanel = GettingStartedFolder.class$("javax.swing.JPanel")) : class$javax$swing$JPanel;
        }

        protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
            Class c;
            if ((class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = GettingStartedFolder.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar).isAssignableFrom(c = cookie.instanceClass())) {
                return cookie;
            }
            if ((class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = GettingStartedFolder.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).isAssignableFrom(c)) {
                return cookie;
            }
            return null;
        }

        protected InstanceCookie acceptFolder(DataFolder df) {
            return new GettingStartedFolder(df);
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected InstanceCookie acceptDataObject(DataObject dob) {
            InstanceCookie cookie = super.acceptDataObject(dob);
            if (cookie != null) {
                URL descURL = (URL)dob.getPrimaryFile().getAttribute(WelcomePanel.DESCRIPTION_PROPERTY);
                if (descURL != null) {
                    this.getDescriptionURLs().put(cookie.instanceName(), descURL);
                } else {
                    ErrorManager.getDefault().log(16, "WelcomePanel: " + dob.getPrimaryFile().getName() + " property welcomeDescription missing.");
                }
            }
            return cookie;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            if (this.buttonPanel != null) {
                this.buttonPanel.removeAll();
            } else {
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new GridBagLayout());
            }
            int i = 0;
            while (i < cookies.length) {
                try {
                    Object obj;
                    Object ob2 = obj = cookies[i].instanceCreate();
                    if (obj instanceof Presenter.Toolbar) {
                        obj = ((Presenter.Toolbar)obj).getToolbarPresenter();
                    }
                    if (obj instanceof JComponent) {
                        Object url = this.getDescriptionURLs().get(cookies[i].instanceName());
                        if (url != null) {
                            ((JComponent)obj).putClientProperty(WelcomePanel.DESCRIPTION_PROPERTY, url);
                        }
                        if (obj instanceof JButton) {
                            JButton b = (JButton)obj;
                            if (ob2 instanceof SystemAction) {
                                SystemAction sa = (SystemAction)ob2;
                                b.putClientProperty(WelcomePanel.HELP_CTX_PROPERTY, sa.getHelpCtx());
                                b.setText(sa.getName());
                            }
                            b.addMouseListener(new MouseAdapter(this, b){
                                private final /* synthetic */ JButton val$b;
                                private final /* synthetic */ GettingStartedFolder this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$b = val$b;
                                }

                                public void mouseEntered(MouseEvent e) {
                                    this.this$1.updateContextBrowser(e);
                                }

                                public void mouseExited(MouseEvent e) {
                                    Border brdr = (Border)this.val$b.getClientProperty("originalBorder");
                                    if (brdr != null) {
                                        this.val$b.setBorder(brdr);
                                    }
                                    GettingStartedFolder.access$400(this.this$1).changeFocus();
                                }
                            });
                            b.addActionListener(new ActionListener(this){
                                private final /* synthetic */ GettingStartedFolder this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void actionPerformed(ActionEvent evt) {
                                    GettingStartedFolder.access$400(this.this$1).changeFocus();
                                }
                            });
                            b.setBorder(new EmptyBorder(2, 2, 2, 2));
                            b.putClientProperty(WelcomePanel.BORDER_PROPERTY, b.getBorder());
                            b.setBackground(backgroundColor);
                            b.setForeground(Color.black);
                            b.setHorizontalAlignment(2);
                            String text = b.getText();
                            if (text.indexOf(38) >= 0) {
                                StringBuffer sb = new StringBuffer(text);
                                sb.deleteCharAt(text.indexOf(38));
                                text = sb.toString();
                                b.setText(text);
                            }
                        } else if (obj instanceof JLabel) {
                            ((JLabel)obj).setText(" ");
                        }
                        GridBagConstraints constraints = new GridBagConstraints();
                        constraints.fill = 2;
                        constraints.gridx = 0;
                        constraints.gridy = i;
                        constraints.weightx = 1.0;
                        constraints.weighty = 0.0;
                        constraints.insets = new Insets(2, 0, 0, 10);
                        constraints.anchor = 11;
                        this.buttonPanel.add((Component)obj, constraints);
                    }
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                }
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 2;
                constraints.gridx = 0;
                constraints.gridy = cookies.length;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.insets = new Insets(4, 0, 0, 10);
                constraints.anchor = 15;
                this.buttonPanel.add(Box.createHorizontalStrut(1), constraints);
                ++i;
            }
            WelcomePanel.this.updateButtonPanelSize();
            return this.buttonPanel;
        }

        public void updateContextBrowser(MouseEvent ev) {
            Object o = ev.getSource();
            if (o instanceof JButton) {
                JButton jb = (JButton)o;
                jb.setToolTipText(null);
                jb.setBorder(new BevelBorder(0));
                URL url = (URL)jb.getClientProperty(WelcomePanel.DESCRIPTION_PROPERTY);
                if (url != null) {
                    try {
                        WelcomePanel.this.contextBrowser.setPage(url);
                    }
                    catch (MissingResourceException mre) {
                        ErrorManager.getDefault().annotate((Throwable)mre, "WelcomePanel: " + url + " cannot be loaded.");
                        ErrorManager.getDefault().notify(16, (Throwable)mre);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().annotate((Throwable)ioe, "WelcomePanel: " + url + " cannot be loaded.");
                        ErrorManager.getDefault().notify(16, (Throwable)ioe);
                    }
                }
            }
        }

        private Map getDescriptionURLs() {
            if (this.descriptionURLs == null) {
                this.descriptionURLs = new HashMap(10);
            }
            return this.descriptionURLs;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ WelcomePanel access$400(GettingStartedFolder x0) {
            return x0.WelcomePanel.this;
        }
    }
}

