/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WorkspaceImpl;

final class BoundsConvertor {
    private static BoundsConvertor instance;
    private ArrayList convertors;
    private String previousFrameType;

    private BoundsConvertor() {
    }

    public static final BoundsConvertor getInstance() {
        if (instance == null) {
            instance = new BoundsConvertor();
        }
        return instance;
    }

    public Rectangle convertBounds(ModeImpl mode, String oldFrameType, String newFrameType) {
        if (this.convertors == null) {
            this.convertors = this.createConversions();
        }
        Conversion curConv = null;
        Iterator iter = ((AbstractList)this.convertors).iterator();
        while (iter.hasNext()) {
            curConv = (Conversion)iter.next();
            if (!curConv.accept(mode, oldFrameType, newFrameType)) continue;
            return curConv.convertBounds(mode, oldFrameType, newFrameType);
        }
        return mode.getBounds();
    }

    public boolean updateBounds(ModeImpl mode) {
        return this.updateBounds(mode, this.previousFrameType, mode.getFrameType());
    }

    public boolean updateBounds(ModeImpl mode, String oldFrameType, String newFrameType) {
        if (oldFrameType == null) {
            return false;
        }
        if (!DeferredPerformer.getDefault().canImmediatelly()) {
            if (this.previousFrameType == null) {
                this.previousFrameType = oldFrameType;
            }
            return false;
        }
        if (mode.getBounds() == null) {
            return false;
        }
        mode.setBounds(this.convertBounds(mode, oldFrameType, newFrameType));
        this.previousFrameType = null;
        return true;
    }

    private ArrayList createConversions() {
        ArrayList<Conversion> convArray = new ArrayList<Conversion>(3);
        convArray.add(new MdiSdi());
        convArray.add(new Desktop2Internal());
        return convArray;
    }

    private static final class Desktop2Internal
    implements Conversion {
        Desktop2Internal() {
        }

        public boolean accept(ModeImpl mode, String oldFrameStr, String newFrameStr) {
            return "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(oldFrameStr) && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(newFrameStr);
        }

        public Rectangle convertBounds(ModeImpl mode, String oldFrameStr, String newFrameStr) {
            Rectangle bounds = mode.getNormalBounds();
            Point leftTop = bounds.getLocation();
            Point innerDesktopLoc = ((WorkspaceImpl)mode.getWorkspace()).getDesktopScreenLocation();
            Point desktopLoc = MainWindow.getDefault().getDesktopScreenLocation();
            Rectangle result = new Rectangle(leftTop.x - (innerDesktopLoc.x - desktopLoc.x), leftTop.y - (innerDesktopLoc.y - desktopLoc.y), bounds.getSize().width - 10, bounds.getSize().height - 10);
            return result;
        }
    }

    private static final class MdiSdi
    implements Conversion {
        MdiSdi() {
        }

        public boolean accept(ModeImpl mode, String oldFrameStr, String newFrameStr) {
            boolean isOldMdi = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(oldFrameStr) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(oldFrameStr);
            boolean isNewMdi = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(newFrameStr) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(newFrameStr);
            return isOldMdi != isNewMdi;
        }

        public Rectangle convertBounds(ModeImpl mode, String oldFrameStr, String newFrameStr) {
            boolean isOldMdi = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(oldFrameStr) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(oldFrameStr);
            boolean isNewMdi = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(newFrameStr) || "org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(newFrameStr);
            Rectangle bounds = mode.getNormalBounds();
            Point newLeftTop = bounds.getLocation();
            Object constraints = mode.getConstraints();
            Point offset = null;
            Rectangle result = null;
            offset = constraints == null || "CENTER".equals(constraints) ? ((WorkspaceImpl)mode.getWorkspace()).getDesktopScreenLocation() : MainWindow.getDefault().getDesktopScreenLocation();
            if (isOldMdi && !isNewMdi) {
                newLeftTop.translate(offset.x, offset.y);
            } else {
                newLeftTop.translate(-offset.x, -offset.y);
            }
            result = new Rectangle(newLeftTop, bounds.getSize());
            return result;
        }
    }

    private static interface Conversion {
        public boolean accept(ModeImpl var1, String var2, String var3);

        public Rectangle convertBounds(ModeImpl var1, String var2, String var3);
    }
}

