/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

final class WeakHash {
    final Entry[] entries = new Entry[7];
    final ReferenceQueue refq = new ReferenceQueue();

    int computeHash(Object ob) {
        return (ob.hashCode() & Integer.MAX_VALUE) % this.entries.length;
    }

    public Value put(Workspace ws, Value nodes) {
        this.checkq();
        int hash = this.computeHash(ws);
        Entry e = this.entries[hash];
        while (e != null && !e.wkey.equals(ws)) {
            e = e.next;
        }
        if (e == null) {
            this.entries[hash] = new Entry(null, ws, nodes, this.refq, this.entries, hash);
            return null;
        }
        Value old = e.val;
        e.val = nodes;
        return old;
    }

    public Value get(Workspace ws) {
        this.checkq();
        int hash = this.computeHash(ws);
        Entry e = this.entries[hash];
        while (e != null && !e.wkey.equals(ws)) {
            e = e.next;
        }
        if (e == null) {
            return null;
        }
        return e.val;
    }

    private void checkq() {
        WeakKey wk = (WeakKey)this.refq.poll();
        if (wk != null) {
            wk.remove();
        }
    }

    static class Value {
        private WeakReference[] currentNodes;
        private WeakReference[] activeNodes;
        TopComponent activatedTC;

        public Value(Node[] current, Node[] activated, TopComponent activatedTC) {
            if (current == null) {
                current = new Node[]{};
            }
            if (activated == null) {
                activated = new Node[]{};
            }
            this.activatedTC = activatedTC;
            this.currentNodes = new WeakReference[current.length];
            int i = 0;
            while (i < this.currentNodes.length) {
                this.currentNodes[i] = new WeakReference<Node>(current[i]);
                ++i;
            }
            this.activeNodes = new WeakReference[activated.length];
            int i2 = 0;
            while (i2 < this.activeNodes.length) {
                this.activeNodes[i2] = new WeakReference<Node>(activated[i2]);
                ++i2;
            }
        }

        public Node[] getActivatedNodes() {
            return Value.asNonNullNodes(this.activeNodes);
        }

        public Node[] getCurrentNodes() {
            return Value.asNonNullNodes(this.currentNodes);
        }

        private static Node[] asNonNullNodes(WeakReference[] working) {
            ArrayList<Node> alist = new ArrayList<Node>(working.length);
            int i = 0;
            while (i < working.length) {
                Node n = (Node)working[i].get();
                if (n != null) {
                    alist.add(n);
                }
                ++i;
            }
            return alist.toArray(new Node[alist.size()]);
        }
    }

    static class WeakKey
    extends WeakReference {
        int hash;
        Entry my;

        WeakKey(Workspace ws, ReferenceQueue rq, Entry parent) {
            super(ws, rq);
            this.hash = ws.hashCode();
            this.my = parent;
        }

        void remove() {
            this.my.remove();
        }

        Workspace getWorkspace() {
            return (Workspace)this.get();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Workspace)) {
                return false;
            }
            Workspace me = this.getWorkspace();
            if (me == null) {
                return o == null;
            }
            return me.equals(o);
        }
    }

    static class Entry {
        Entry next;
        Entry prev;
        WeakKey wkey;
        Value val;
        int hash;
        Entry[] entries;

        Entry(Entry next, Workspace ws, Value val, ReferenceQueue rq, Entry[] es, int hash) {
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
            this.wkey = new WeakKey(ws, rq, this);
            this.val = val;
            this.hash = hash;
            this.entries = es;
        }

        void remove() {
            if (this.prev == null && this.next == null) {
                return;
            }
            if (this.prev == null) {
                this.entries[this.hash] = this.next;
                this.next.prev = null;
            } else {
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
            }
        }
    }
}

