/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.actions.CloseMaximizedFrameAction;
import org.netbeans.core.actions.MinimizeMaximizedFrameAction;
import org.netbeans.core.actions.RestoreMaximizedFrameAction;
import org.netbeans.core.projects.SessionManager;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.TabbedContainerUIManager;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WeakHash;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ResetCookie;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowManagerImpl
extends WindowManager {
    public static final String TC_PREFIX = "wstopcomp";
    public static final int PROPERTIES = 1;
    public static final int WORKSPACES = 2;
    private static WindowManagerImpl defaultInstance;
    private Workspace[] workspaces;
    private Workspace current;
    int savedUIMode = 0;
    private PropertyChangeSupport changeSupport;
    private HashSet tcListeners;
    private boolean isCreated;
    private WeakHash workspace2Nodes;
    private boolean mainPositioned = false;
    private TopComponentManager validatedManager;
    private Map failedCompsMap;
    private Dimension oldScreenSize;
    private Rectangle oldMainWindowBounds;
    private LazyUpdater updater;
    static final long serialVersionUID = 680725949680433701L;
    private static final String DEFAULT_NAME = "untitled_mode";
    private static final int MAX_MODE_NAME_LENGTH = 20;
    private static Component horizontalGlue;
    private static JButton iconButton;
    private static JButton minButton;
    private static JButton closeButton;
    private static boolean buttonsAdded;
    private static CloseMaximizedFrameAction closeFrame;
    private static MinimizeMaximizedFrameAction minimizeFrame;
    private static RestoreMaximizedFrameAction restoreFrame;
    private RequestProcessor.Task deferSaving;
    private static final int WINSYS_SAVING_DELAY;
    private final Object TC_LISTENERS_LOCK = new Object();
    private static final RequestProcessor PROCESSOR;
    private boolean wasAnyWorkspaceVisible = false;
    private boolean switchingWorkspace = false;
    private boolean switchingWorkspaceIgnoreFocusEvent = false;
    private boolean exitingIDE = false;
    private boolean wasIDEStarted = false;
    private static boolean isProjectOpen;
    private static Object LOCK;
    private static ProjectSwitchListener projectSwitchL;
    private static boolean isProjectModuleEnabled;
    private static boolean wasAnyProjectOpen;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
    static /* synthetic */ Class class$org$openide$windows$WindowManager;
    static /* synthetic */ Class class$org$netbeans$core$actions$CloseMaximizedFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$MinimizeMaximizedFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$RestoreMaximizedFrameAction;
    static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;

    public WindowManagerImpl() {
        String string = TC_PREFIX;
        synchronized (string) {
            if (defaultInstance != null) {
                throw new IllegalStateException("Instance already exists");
            }
            defaultInstance = this;
            this.initialize();
            if (NbTopManager.getUninitialized().isInteractive(4)) {
                SessionManager.getDefault().addPropertyChangeListener(projectSwitchL);
                ModuleInfo curModuleInfo = WindowUtils.findModule("org.netbeans.modules.projects", null, null);
                if (curModuleInfo != null) {
                    curModuleInfo.addPropertyChangeListener((PropertyChangeListener)projectSwitchL);
                    WindowManagerImpl.setProjectModuleEnabled(curModuleInfo.isEnabled());
                } else {
                    WindowManagerImpl.setProjectModuleEnabled(false);
                    Lookup.Result modulesResult = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = WindowManagerImpl.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
                    modulesResult.addLookupListener((LookupListener)new LookupResultListener());
                }
            }
        }
    }

    private void initialize() {
        this.initToolbars();
        this.changeSupport = new PropertyChangeSupport((Object)this);
        this.workspace2Nodes = new WeakHash();
        this.workspaces = new Workspace[0];
        this.createButtons();
    }

    private void initToolbars() {
        String TOOLBAR_DTD = "org/netbeans/core/windows/resources/toolbar.dtd";
        String TOOLBAR_DTD_PUBLIC_ID = "-//Forte for Java//DTD toolbar//EN";
        Class TOOLBAR_PROCESSOR_CLASS = class$org$netbeans$core$windows$toolbars$ToolbarProcessor == null ? (class$org$netbeans$core$windows$toolbars$ToolbarProcessor = WindowManagerImpl.class$("org.netbeans.core.windows.toolbars.ToolbarProcessor")) : class$org$netbeans$core$windows$toolbars$ToolbarProcessor;
        String TOOLBAR_ICON_BASE = "/org/netbeans/core/windows/toolbars/xmlToolbars";
        XMLDataObject.Info xmlinfo = new XMLDataObject.Info();
        xmlinfo.addProcessorClass(TOOLBAR_PROCESSOR_CLASS);
        xmlinfo.setIconBase("/org/netbeans/core/windows/toolbars/xmlToolbars");
        XMLDataObject.registerInfo((String)"-//Forte for Java//DTD toolbar//EN", (XMLDataObject.Info)xmlinfo);
    }

    public static WindowManagerImpl getInstance() {
        return (WindowManagerImpl)((Object)Lookup.getDefault().lookup(class$org$openide$windows$WindowManager == null ? (class$org$openide$windows$WindowManager = WindowManagerImpl.class$("org.openide.windows.WindowManager")) : class$org$openide$windows$WindowManager));
    }

    public void save() throws IOException {
        try {
            PersistenceManager.getDefault().setSaveInProgress(true);
            int i = 0;
            while (i < this.workspaces.length) {
                try {
                    ((WorkspaceImpl)this.workspaces[i]).save();
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                }
                ++i;
            }
            Object var4_3 = null;
            PersistenceManager.getDefault().setSaveInProgress(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            PersistenceManager.getDefault().setSaveInProgress(false);
            throw throwable;
        }
    }

    public void postSaving() {
        RequestProcessor.Task task = this.deferSaving;
        if (task == null) {
            this.deferSaving = PROCESSOR.post(new Runnable(){

                public void run() {
                    try {
                        WindowManagerImpl.getInstance().save();
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify(1, (Throwable)exc);
                    }
                }
            }, WINSYS_SAVING_DELAY);
        } else {
            task.schedule(WINSYS_SAVING_DELAY);
        }
    }

    private synchronized void createButtons() {
        if (closeFrame == null) {
            closeFrame = (CloseMaximizedFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$CloseMaximizedFrameAction == null ? (class$org$netbeans$core$actions$CloseMaximizedFrameAction = WindowManagerImpl.class$("org.netbeans.core.actions.CloseMaximizedFrameAction")) : class$org$netbeans$core$actions$CloseMaximizedFrameAction));
        }
        if (minimizeFrame == null) {
            minimizeFrame = (MinimizeMaximizedFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$MinimizeMaximizedFrameAction == null ? (class$org$netbeans$core$actions$MinimizeMaximizedFrameAction = WindowManagerImpl.class$("org.netbeans.core.actions.MinimizeMaximizedFrameAction")) : class$org$netbeans$core$actions$MinimizeMaximizedFrameAction));
        }
        if (restoreFrame == null) {
            restoreFrame = (RestoreMaximizedFrameAction)SystemAction.get((Class)(class$org$netbeans$core$actions$RestoreMaximizedFrameAction == null ? (class$org$netbeans$core$actions$RestoreMaximizedFrameAction = WindowManagerImpl.class$("org.netbeans.core.actions.RestoreMaximizedFrameAction")) : class$org$netbeans$core$actions$RestoreMaximizedFrameAction));
        }
        if (horizontalGlue == null) {
            horizontalGlue = Box.createHorizontalGlue();
        }
        if (iconButton == null) {
            iconButton = new JButton();
            Icon iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
            iconButton.setIcon(iconIcon);
            iconButton.setBorder(BorderFactory.createEmptyBorder());
            iconButton.addActionListener((ActionListener)((Object)minimizeFrame));
        }
        if (minButton == null) {
            minButton = new JButton();
            Icon minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            minButton.setIcon(minIcon);
            minButton.setBorder(BorderFactory.createEmptyBorder());
            minButton.addActionListener((ActionListener)((Object)restoreFrame));
        }
        if (closeButton == null) {
            closeButton = new JButton();
            Icon closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
            closeButton.setIcon(closeIcon);
            closeButton.setBorder(BorderFactory.createEmptyBorder());
            closeButton.addActionListener((ActionListener)((Object)closeFrame));
        }
        buttonsAdded = false;
    }

    void addButtons() {
        if (buttonsAdded) {
            return;
        }
        buttonsAdded = true;
        JMenuBar menuBar = MainWindow.getDefault().getJMenuBar();
        menuBar.add(horizontalGlue);
        menuBar.add(iconButton);
        menuBar.add(minButton);
        menuBar.add(closeButton);
        menuBar.revalidate();
        menuBar.repaint();
    }

    void removeButtons() {
        if (!buttonsAdded) {
            return;
        }
        buttonsAdded = false;
        JMenuBar menuBar = MainWindow.getDefault().getJMenuBar();
        menuBar.remove(horizontalGlue);
        menuBar.remove(iconButton);
        menuBar.remove(minButton);
        menuBar.remove(closeButton);
        menuBar.revalidate();
        menuBar.repaint();
    }

    void setWasAnyWorkspaceVisible(boolean b) {
        this.wasAnyWorkspaceVisible = b;
    }

    boolean isWasAnyWorkspaceVisible() {
        return this.wasAnyWorkspaceVisible;
    }

    void setSwitchingWorkspace(boolean b) {
        this.switchingWorkspace = b;
    }

    public boolean isSwitchingWorkspace() {
        return this.switchingWorkspace;
    }

    void setSwitchingWorkspaceIgnoreFocusEvent(boolean b) {
        this.switchingWorkspaceIgnoreFocusEvent = b;
    }

    public boolean isSwitchingWorkspaceIgnoreFocusEvent() {
        return this.switchingWorkspaceIgnoreFocusEvent;
    }

    public void setExitingIDE(boolean b) {
        this.exitingIDE = b;
    }

    boolean isExitingIDE() {
        return this.exitingIDE;
    }

    public void setWasIDEStarted(boolean b) {
        this.wasIDEStarted = b;
    }

    boolean isWasIDEStarted() {
        return this.wasIDEStarted;
    }

    public static void cleanWindowManager() {
        if (defaultInstance == null) {
            WindowManager.getDefault();
        } else {
            Workspace[] ws = WindowManager.getDefault().getWorkspaces();
            int i = 0;
            while (i < ws.length) {
                ws[i].remove();
                ++i;
            }
        }
    }

    public static void createFromScratch() {
        if ("full".equals(System.getProperty("netbeans.full.hack"))) {
            return;
        }
        if (defaultInstance == null) {
            WindowManager.getDefault();
        }
    }

    public static boolean isWindowDnDEnabled() {
        return Boolean.getBoolean("netbeans.winsys.dnd") && Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
    }

    public Frame getMainWindow() {
        return MainWindow.getDefault();
    }

    public void updateUI() {
        MainWindow mainWindow = MainWindow.getDefault();
        SwingUtilities.updateComponentTreeUI(mainWindow);
        mainWindow.pack();
        Workspace[] wArray = this.getWorkspaces();
        int i = 0;
        while (i < wArray.length) {
            Iterator iter = wArray[i].getModes().iterator();
            while (iter.hasNext()) {
                ((ModeImpl)iter.next()).updateUI();
            }
            ++i;
        }
    }

    public Workspace createWorkspace(String name, String displayName) {
        return new WorkspaceImpl(name, displayName);
    }

    public Workspace findWorkspace(String name) {
        return this.doFindWorkspace(name, true);
    }

    public Workspace findLoadedWorkspace(String name) {
        return this.doFindWorkspace(name, false);
    }

    private Workspace doFindWorkspace(String name, boolean load) {
        if (load) {
            this.ensureSectionLoaded(3);
        }
        int i = 0;
        while (i < this.workspaces.length) {
            if (name.equals(this.workspaces[i].getName())) {
                return this.workspaces[i];
            }
            ++i;
        }
        return null;
    }

    public Workspace[] getWorkspaces() {
        this.ensureSectionLoaded(3);
        return this.workspaces;
    }

    public Workspace[] getWorkspacesNoLoad() {
        return this.workspaces;
    }

    public void setWorkspaces(Workspace[] workspaces) {
        if (Arrays.equals(this.workspaces, workspaces)) {
            return;
        }
        int i = 0;
        while (i < workspaces.length) {
            if (workspaces[i] == null) {
                throw new IllegalArgumentException("Null worspace at " + i + " array index!");
            }
            ++i;
        }
        if (this.current == null && workspaces.length > 0) {
            this.current = workspaces[0];
        }
        Workspace[] old = this.workspaces;
        this.workspaces = workspaces;
        this.changeSupport.firePropertyChange("workspaces", old, this.workspaces);
    }

    public Workspace getCurrentWorkspace() {
        this.ensureSectionLoaded(3);
        if (this.current == null) {
            this.current = new WorkspaceImpl();
        }
        return this.current;
    }

    public Workspace getCurrentWorkspaceNoLoad() {
        return this.current;
    }

    public void setCurrentWorkspace(Workspace workspace) {
        this.ensureSectionLoaded(3);
        if (SwingUtilities.isEventDispatchThread()) {
            this.getWorkspaceSetter(workspace).run();
        } else {
            SwingUtilities.invokeLater(this.getWorkspaceSetter(workspace));
        }
    }

    private Runnable getWorkspaceSetter(final Workspace workspace) {
        return new Runnable(){

            public void run() {
                if (WindowManagerImpl.this.current != null && WindowManagerImpl.this.current.equals(workspace) && ((WorkspaceImpl)WindowManagerImpl.this.current).isVisible()) {
                    return;
                }
                boolean found = false;
                int i = 0;
                while (i < WindowManagerImpl.this.workspaces.length) {
                    if (WindowManagerImpl.this.workspaces[i].equals(workspace)) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    return;
                }
                StateManager stateMan = StateManager.getDefault();
                if ((stateMan.getState() & 0x20) != 0) {
                    stateMan.setMainState(256);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
                WorkspaceImpl old = (WorkspaceImpl)WindowManagerImpl.this.current;
                WindowManagerImpl.this.current = workspace;
                if (old != null) {
                    WindowManagerImpl.this.workspace2Nodes.put(old, WindowManagerImpl.getSelectedNodes());
                    old.setVisible(false);
                    ((WorkspaceImpl)WindowManagerImpl.this.current).setPendingShownTcs(old.getShownTcs());
                }
                ((WorkspaceImpl)WindowManagerImpl.this.current).ensureSectionLoaded(3);
                Set newShown = ((WorkspaceImpl)WindowManagerImpl.this.current).getShownTcs();
                if (old != null) {
                    Set oldShown = old.getShownTcs();
                    Set pending = old.getPendingShownTcs();
                    oldShown.removeAll(pending);
                    newShown.removeAll(oldShown);
                }
                Iterator it = newShown.iterator();
                while (it.hasNext()) {
                    ((WindowManagerImpl)WindowManager.getDefault()).componentShowing((TopComponent)it.next());
                }
                ((WorkspaceImpl)WindowManagerImpl.this.current).setVisible(true, false);
                ((WorkspaceImpl)WindowManagerImpl.this.current).setPendingShownTcs(Collections.EMPTY_SET);
                if (old != null) {
                    Set oldShown = old.getShownTcs();
                    oldShown.removeAll(((WorkspaceImpl)WindowManagerImpl.this.current).getShownTcs());
                    Iterator it2 = oldShown.iterator();
                    while (it2.hasNext()) {
                        ((WindowManagerImpl)WindowManager.getDefault()).componentHidden((TopComponent)it2.next());
                    }
                }
                WindowManagerImpl.this.changeSupport.firePropertyChange("currentWorkspace", old, WindowManagerImpl.this.current);
                WindowManagerImpl.this.setSelectedNodes(WindowManagerImpl.this.workspace2Nodes.get(WindowManagerImpl.this.current));
                if (((WorkspaceImpl)WindowManagerImpl.this.current).isTopMaximizedMode()) {
                    WindowManagerImpl.this.addButtons();
                } else {
                    WindowManagerImpl.this.removeButtons();
                }
                MainWindow.getDefault().updateTitle();
                if ((stateMan.getState() & 0x100) != 0) {
                    stateMan.setMainState(32);
                }
            }
        };
    }

    public int getSavedUIMode() {
        this.ensureSectionLoaded(1);
        return this.savedUIMode;
    }

    public void setSavedUIMode(int uiMode) {
        this.savedUIMode = uiMode;
    }

    public void attachUpdater(LazyUpdater updater) {
        this.updater = updater;
    }

    private boolean ensureSectionLoaded(int section) {
        try {
            if (this.updater == null) {
                PersistenceManager.getDefault().readXML();
                if (this.updater == null) {
                    return false;
                }
            }
            if (!this.updater.isValid()) {
                return false;
            }
            if ((section & this.updater.getLoadedSections()) != section) {
                this.updater.loadDataSection(section);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized void nextWorkspace() {
        int len;
        Workspace current = this.getCurrentWorkspace();
        int i = len = this.workspaces.length - 1;
        while (i >= 0) {
            if (this.workspaces[i] == current) {
                i = i == len ? 0 : ++i;
                current = this.workspaces[i];
                current.activate();
                return;
            }
            --i;
        }
    }

    public synchronized void previousWorkspace() {
        int len;
        Workspace current = this.getCurrentWorkspace();
        int i = len = this.workspaces.length - 1;
        while (i >= 0) {
            if (this.workspaces[i] == current) {
                i = i == 0 ? len : --i;
                current = this.workspaces[i];
                current.activate();
                return;
            }
            --i;
        }
    }

    static WeakHash.Value getSelectedNodes() {
        Node[] current = WindowManager.getDefault().getRegistry().getCurrentNodes();
        Node[] activated = WindowManager.getDefault().getRegistry().getActivatedNodes();
        TopComponent tc = WindowManager.getDefault().getRegistry().getActivated();
        return new WeakHash.Value(current, activated, tc);
    }

    void setSelectedNodes(WeakHash.Value active) {
        Node[] activated = active == null ? new Node[]{} : active.getActivatedNodes();
        Node[] current = active == null ? new Node[]{} : active.getCurrentNodes();
        Node[][] nodes = new Node[][]{current, activated};
        RegistryImpl rimpl = (RegistryImpl)this.getRegistry();
        SelectedNodesChangedEvent ev = new SelectedNodesChangedEvent(nodes, null, activated);
        rimpl.selectedNodesChanged(ev);
        ev = new SelectedNodesChangedEvent(nodes, null, current);
        rimpl.selectedNodesChanged(ev);
        if (active != null) {
            // empty if block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public void addTopComponentListener(TopComponentListener tcl) {
        Object object = this.TC_LISTENERS_LOCK;
        synchronized (object) {
            if (this.tcListeners == null) {
                this.tcListeners = new HashSet(5);
            }
            this.tcListeners.add(tcl);
        }
    }

    public void removeTopComponentListener(TopComponentListener tcl) {
        Object object = this.TC_LISTENERS_LOCK;
        synchronized (object) {
            if (this.tcListeners == null) {
                return;
            }
            this.tcListeners.remove(tcl);
        }
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    void setCreated(boolean isCreated) {
        this.isCreated = isCreated;
    }

    public boolean isMainPositioned() {
        return this.mainPositioned;
    }

    public void setMainPositioned(boolean mainPositioned) {
        this.mainPositioned = mainPositioned;
    }

    public void componentShowing(TopComponent tc) {
        super.componentShowing(tc);
    }

    public void componentHidden(TopComponent tc) {
        super.componentHidden(tc);
    }

    Set getTcListenersForFiring() {
        if (this.tcListeners == null) {
            return null;
        }
        Set cloned = null;
        Object object = this.TC_LISTENERS_LOCK;
        synchronized (object) {
            cloned = (Set)this.tcListeners.clone();
        }
        return cloned;
    }

    public static TopComponentContainer findContainer(String mode) {
        WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
        TopComponentContainer c = null;
        Workspace aWsp = wm.getCurrentWorkspace();
        c = WindowManagerImpl.findContainer(mode, aWsp);
        if (null != c) {
            return c;
        }
        Workspace[] allWsp = wm.getWorkspaces();
        int i = 0;
        while (i < allWsp.length) {
            if (allWsp[i] != aWsp && null != (c = WindowManagerImpl.findContainer(mode, allWsp[i]))) break;
            ++i;
        }
        return c;
    }

    public static TopComponentContainer findContainer(String mode, Workspace wsp) {
        TopComponentContainer c = null;
        ModeImpl m = (ModeImpl)wsp.findMode(mode);
        if (null != m && null != (c = m.getContainerInstance()) && 0 == c.getTopComponents().length) {
            c = null;
        }
        return c;
    }

    public static String findUnusedModeName(String base, Workspace workspace) {
        return WindowManagerImpl.findUnusedModeName(base, workspace, false);
    }

    public static String findUnusedModeName(String base, Workspace workspace, boolean forceNumber) {
        if (base == null) {
            base = DEFAULT_NAME;
        }
        if (base.length() > 20) {
            base = base.substring(0, 20);
        }
        if (!forceNumber && workspace.findMode(base) == null) {
            return base;
        }
        String result = null;
        int modeNumber = 1;
        while (workspace.findMode(result = base + "_" + modeNumber) != null) {
            ++modeNumber;
        }
        return result;
    }

    public void activateComponent(TopComponent tc) {
        Set listeners;
        if (tc != null) {
            ((WorkspaceImpl)this.getCurrentWorkspace()).componentActivated(tc);
        }
        if ((listeners = this.getTcListenersForFiring()) != null) {
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((TopComponentListener)iter.next()).topComponentActivated(new TopComponentChangedEvent((Object)this, tc, this.getCurrentWorkspace(), TopComponentChangedEvent.ACTIVATED));
            }
        }
        super.activateComponent(tc);
    }

    public void annotatePersistenceError(Exception exc, String tcName) {
        if (this.failedCompsMap == null) {
            this.failedCompsMap = new HashMap();
        }
        this.failedCompsMap.put(exc, tcName);
    }

    public void checkPersistenceErrors(boolean reading) {
        if (this.failedCompsMap == null || this.failedCompsMap.isEmpty()) {
            return;
        }
        Iterator it = this.failedCompsMap.keySet().iterator();
        while (it.hasNext()) {
            Exception e = (Exception)it.next();
            Object name = this.failedCompsMap.get(e);
            String message = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? WindowManagerImpl.class$("org.netbeans.core.windows.WindowManagerImpl") : class$org$netbeans$core$windows$WindowManagerImpl), (String)(reading ? "FMT_TCReadError" : "FMT_TCWriteError"), (Object[])new Object[]{name});
            ErrorManager.getDefault().annotate((Throwable)e, message);
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
        this.failedCompsMap = null;
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent c) {
        TopComponentManager result = this.validatedManager == null ? new TopComponentManager(c) : this.validatedManager;
        this.validatedManager = null;
        return result;
    }

    private void setValidatedManager(TopComponentManager tcm) {
        this.validatedManager = tcm;
    }

    private TopComponentManager getValidatedManager() {
        return this.validatedManager;
    }

    public static TopComponentManager findManager(TopComponent tc) {
        return (TopComponentManager)WindowManager.findComponentManager((TopComponent)tc);
    }

    public Dimension getOldScreenSize() {
        return this.oldScreenSize;
    }

    public Rectangle getOldMainWindowBounds() {
        return this.oldMainWindowBounds;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer();
    }

    public static boolean isProjectOpen() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = isProjectOpen;
            return bl;
        }
    }

    private static void setProjectOpen(boolean b) {
        Object object = LOCK;
        synchronized (object) {
            isProjectOpen = b;
        }
    }

    public static boolean isProjectModuleEnabled() {
        return isProjectModuleEnabled;
    }

    private static void setProjectModuleEnabled(boolean b) {
        isProjectModuleEnabled = b;
    }

    public static boolean wasAnyProjectOpen() {
        return wasAnyProjectOpen;
    }

    private static void setAnyProjectOpen(boolean b) {
        wasAnyProjectOpen = b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        WINSYS_SAVING_DELAY = System.getProperty("netbeans.debug.heap") != null ? 0 : 30000;
        PROCESSOR = new RequestProcessor("Winsys Save Processor");
        isProjectOpen = false;
        LOCK = new Object();
        projectSwitchL = new ProjectSwitchListener();
        isProjectModuleEnabled = false;
        wasAnyProjectOpen = false;
    }

    public static final class TopComponentManager
    extends ComponentAdapter
    implements WindowManager.Component,
    DeferredPerformer.DeferredCommand,
    Runnable {
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";
        public static final String PROP_NAME = "name";
        public static final String PROP_ICON = "icon";
        public static final String TAB_POLICY = "TabPolicy";
        public static final String HIDE_WHEN_ALONE = "HideWhenAlone";
        Set whereOpened;
        TopComponent component;
        private NbMarshalledObject marshalledComponent;
        String componentName;
        Image icon;
        Node[] nodes;
        Node[] tempNodes;
        WindowManagerImpl wm;
        PropertyChangeSupport changeSupport;
        private int innerState = 1;
        private RequestProcessor.Task deferNameChange;
        private static final int READY = 1;
        private static final int INVALID = 2;
        private static final int FAILED = 4;
        private static VersionSerializator serializationManager;
        static final long serialVersionUID = 5669852754182098300L;

        TopComponentManager(TopComponent component) {
            this.component = component;
            this.whereOpened = new HashSet(5);
            this.initialize();
        }

        private void initialize() {
            this.wm = (WindowManagerImpl)WindowManager.getDefault();
            this.changeSupport = new PropertyChangeSupport(this);
        }

        public void open() {
            this.open(null);
        }

        public void open(Workspace workspace) {
            if (DeferredPerformer.getDefault().canImmediatelly()) {
                Workspace realWorkspace;
                Workspace workspace2 = realWorkspace = workspace == null ? this.wm.getCurrentWorkspace() : workspace;
                if (EventQueue.isDispatchThread()) {
                    this.doOpen(realWorkspace);
                } else {
                    SwingUtilities.invokeLater(new Runnable(this, realWorkspace){
                        private final /* synthetic */ Workspace val$realWorkspace;
                        private final /* synthetic */ TopComponentManager this$0;
                        {
                            this.this$0 = this$0;
                            this.val$realWorkspace = val$realWorkspace;
                        }

                        public void run() {
                            TopComponentManager.access$1600(this.this$0, this.val$realWorkspace);
                        }
                    });
                }
            } else {
                DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, workspace);
            }
        }

        public void performCommand(DeferredPerformer.DeferredContext context) {
            this.component.open((Workspace)context.getData());
        }

        private void doOpen(Workspace workspace) {
            Set listeners;
            Mode mode = workspace.findMode(this.component);
            if (!this.whereOpened.add(workspace)) {
                if (mode != null && ((ModeImpl)mode).getFrameState() == 1) {
                    ((ModeImpl)mode).setFrameState(0);
                }
                return;
            }
            if (mode == null) {
                String modeName = WindowManagerImpl.findUnusedModeName(this.component.getName(), workspace);
                mode = ((WorkspaceImpl)workspace).createMode(modeName, modeName, null, true);
            }
            mode.dockInto(this.component);
            if (this.whereOpened.size() == 1) {
                WindowManagerImpl.super.componentOpenNotify(this.component);
            }
            if ((listeners = this.wm.getTcListenersForFiring()) != null) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    ((TopComponentListener)iter.next()).topComponentOpened(new TopComponentChangedEvent(this, this.component, workspace, TopComponentChangedEvent.OPENED));
                }
            }
        }

        public boolean isOpened() {
            return this.whereOpened.size() > 0;
        }

        public boolean isOpened(Workspace workspace) {
            return this.whereOpened.contains(workspace);
        }

        public void takeOpenedStatus(TopComponentManager otherTcm) {
            this.whereOpened = new HashSet(otherTcm.whereOpened());
        }

        public void close(Workspace workspace) {
            switch (this.component.getCloseOperation()) {
                case 1: {
                    if (!this.isOpened(workspace)) break;
                    this.doClose(workspace);
                    break;
                }
                case 0: {
                    Workspace[] workspaces = this.wm.getWorkspaces();
                    int i = 0;
                    while (i < workspaces.length) {
                        if (this.isOpened(workspaces[i])) {
                            this.doClose(workspaces[i]);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }

        public void requestFocus() {
            DoRequest doRequestFocus = new DoRequest(0);
            if (EventQueue.isDispatchThread()) {
                doRequestFocus.run();
            } else {
                SwingUtilities.invokeLater(doRequestFocus);
            }
        }

        public void requestVisible() {
            DoRequest doRequestVisible = new DoRequest(1);
            if (EventQueue.isDispatchThread()) {
                doRequestVisible.run();
            } else {
                SwingUtilities.invokeLater(doRequestVisible);
            }
        }

        Mode getMode() {
            return this.wm.getCurrentWorkspace().findMode(this.component);
        }

        void doClose(Workspace workspace) {
            Set listeners;
            ModeImpl mode = (ModeImpl)workspace.findMode(this.component);
            this.whereOpened.remove(workspace);
            if (mode != null) {
                mode.close(this.component);
            }
            if (!this.isOpened()) {
                WindowManagerImpl.super.componentCloseNotify(this.component);
            }
            if ((listeners = this.wm.getTcListenersForFiring()) != null) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    ((TopComponentListener)iter.next()).topComponentClosed(new TopComponentChangedEvent(this, this.component, workspace, TopComponentChangedEvent.CLOSED));
                }
            }
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public void setActivatedNodes(Node[] nodes) {
            if (this.component == null) {
                this.tempNodes = nodes;
                return;
            }
            if (Arrays.equals(this.nodes, nodes)) {
                return;
            }
            Node[] old = this.nodes;
            this.nodes = nodes;
            this.changeSupport.firePropertyChange(PROP_ACTIVATED_NODES, old, nodes);
            Set listeners = this.wm.getTcListenersForFiring();
            if (listeners != null) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    ((TopComponentListener)iter.next()).selectedNodesChanged(new SelectedNodesChangedEvent(this, this.component, nodes));
                }
            }
        }

        public void nameChanged() {
            if (this.component != null) {
                RequestProcessor.Task task = this.deferNameChange;
                if (task == null) {
                    this.deferNameChange = RequestProcessor.getDefault().post((Runnable)this, 200, 1);
                } else {
                    task.schedule(200);
                }
            }
        }

        public void run() {
            this.changeSupport.firePropertyChange(PROP_NAME, null, this.component.getName());
            this.deferNameChange = null;
        }

        public void setIcon(Image icon) {
            if (this.icon != null && this.icon.equals(icon) || this.icon == null && icon == null) {
                return;
            }
            Image old = this.icon;
            this.icon = icon;
            this.changeSupport.firePropertyChange(PROP_ICON, old, this.icon);
        }

        public Image getIcon() {
            return this.icon;
        }

        public TopComponent getComponent() {
            return this.component;
        }

        public Set whereOpened() {
            return this.whereOpened;
        }

        public void addPropertyChangeListener(PropertyChangeListener pchl) {
            this.changeSupport.addPropertyChangeListener(pchl);
        }

        public void removePropertyChangeListener(PropertyChangeListener pchl) {
            this.changeSupport.removePropertyChangeListener(pchl);
        }

        private Object writeReplace() throws ObjectStreamException {
            NbMarshalledObject marshalledTc = null;
            try {
                marshalledTc = new NbMarshalledObject((Object)this.component);
            }
            catch (Exception exc) {
                this.wm.annotatePersistenceError(exc, this.component.getName());
                return null;
            }
            return new SerializationReplacer(this.componentName, marshalledTc);
        }

        public boolean validateData() {
            if (this.innerState != 2) {
                return this.innerState == 1;
            }
            if (this.marshalledComponent == null) {
                this.innerState = 4;
                return false;
            }
            try {
                block8: {
                    try {
                        this.wm.setValidatedManager(this);
                        this.component = (TopComponent)this.marshalledComponent.get();
                        int n = this.innerState = this.component == null ? 4 : 1;
                        if (this.component == null || this.tempNodes == null) break block8;
                        this.setActivatedNodes(this.tempNodes);
                        this.tempNodes = null;
                    }
                    catch (InvalidObjectException ioe) {
                        this.innerState = 4;
                        String msg = ioe.getMessage();
                        if (msg != null) {
                            ErrorManager.getDefault().log(16, "[WinSys] Component is not deserializable. Reason: " + msg);
                        }
                        boolean bl = false;
                        Object var5_2 = null;
                        this.wm.setValidatedManager(null);
                        return bl;
                    }
                    catch (Exception exc) {
                        this.innerState = 4;
                        this.wm.annotatePersistenceError(exc, this.componentName);
                        boolean bl = false;
                        Object var5_3 = null;
                        this.wm.setValidatedManager(null);
                        return bl;
                    }
                }
                Object var5_1 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.wm.setValidatedManager(null);
                throw throwable;
            }
            this.wm.setValidatedManager(null);
            return this.innerState == 1;
        }

        private static TopComponentManager createTCM(String componentName, NbMarshalledObject marshalledComponent) {
            TopComponentManager result = new TopComponentManager(null);
            result.componentName = componentName;
            result.marshalledComponent = marshalledComponent;
            result.innerState = 2;
            return result;
        }

        private VersionSerializator serializationManager() {
            if (serializationManager == null) {
                serializationManager = TopComponentManager.createSerializationManager();
            }
            return serializationManager;
        }

        private static VersionSerializator createSerializationManager() {
            VersionSerializator result = new VersionSerializator();
            result.putVersion(new Version1());
            return result;
        }

        static /* synthetic */ void access$1600(TopComponentManager x0, Workspace x1) {
            x0.doOpen(x1);
        }

        private static final class VSAccess
        implements DefaultReplacer.Access {
            private static final long serialVersionUID = -6484558550904999459L;
            transient VersionSerializator vs;

            public VSAccess(VersionSerializator vs) {
                this.vs = vs;
            }

            public VersionSerializator getVersionSerializator() {
                return this.vs == null ? TopComponentManager.createSerializationManager() : this.vs;
            }
        }

        private static final class Version1
        implements DefaultReplacer.ResVersionable {
            public static final String NAME = "Version_1.0";
            String componentName;
            NbMarshalledObject marshalledComponent;
            TopComponentManager tcm;
            transient HashSet whereOpened;

            Version1() {
            }

            public String getName() {
                return NAME;
            }

            public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
                this.componentName = (String)in.readObject();
                this.marshalledComponent = (NbMarshalledObject)in.readObject();
            }

            public void writeData(ObjectOutput out) throws IOException {
                throw new InternalError();
            }

            public Object resolveData() throws ObjectStreamException {
                return TopComponentManager.createTCM(this.componentName, this.marshalledComponent);
            }
        }

        private static final class SerializationReplacer
        implements Serializable {
            static final long serialVersionUID = -9009124438910567345L;
            private static final String NAME = "name";
            private static final String MARSHALLED_COMPONENT = "marshalledComponent";
            private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("marshalledComponent", class$org$openide$util$io$NbMarshalledObject == null ? (class$org$openide$util$io$NbMarshalledObject = SerializationReplacer.class$("org.openide.util.io.NbMarshalledObject")) : class$org$openide$util$io$NbMarshalledObject)};
            private String componentName;
            private NbMarshalledObject marshalledComponent;
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class class$org$openide$util$io$NbMarshalledObject;

            SerializationReplacer(String componentName, NbMarshalledObject marshalledComponent) {
                this.componentName = componentName;
                this.marshalledComponent = marshalledComponent;
            }

            private void writeObject(ObjectOutputStream oos) throws IOException {
                ObjectOutputStream.PutField pf = oos.putFields();
                pf.put("name", this.componentName);
                pf.put(MARSHALLED_COMPONENT, this.marshalledComponent);
                oos.writeFields();
            }

            private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
                ObjectInputStream.GetField gf = ois.readFields();
                this.componentName = (String)gf.get("name", null);
                this.marshalledComponent = (NbMarshalledObject)gf.get(MARSHALLED_COMPONENT, null);
            }

            private synchronized Object readResolve() throws ObjectStreamException {
                return TopComponentManager.createTCM(this.componentName, this.marshalledComponent);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class DoRequest
        implements Runnable {
            private static final int REQUEST_FOCUS = 0;
            private static final int REQUEST_VISIBLE = 1;
            private int action;

            DoRequest(int action) {
                this.action = action;
            }

            private void requestFocus() {
                ModeImpl modeImpl;
                if (TopComponentManager.this.component.isDisplayable() && (modeImpl = (ModeImpl)TopComponentManager.this.getMode()) != null && TopComponentManager.this.component != null && NbPresenter.currentModalDialog == null) {
                    modeImpl.requestFocus(TopComponentManager.this.component);
                }
            }

            private void requestVisible() {
                ModeImpl modeImpl;
                if (TopComponentManager.this.component.isDisplayable() && (modeImpl = (ModeImpl)TopComponentManager.this.getMode()) != null && TopComponentManager.this.component != null && NbPresenter.currentModalDialog == null) {
                    modeImpl.requestVisible(TopComponentManager.this.component);
                }
            }

            public void run() {
                if (!TopComponentManager.this.isOpened()) {
                    return;
                }
                if (this.action == 0) {
                    this.requestFocus();
                } else if (this.action == 1) {
                    this.requestVisible();
                }
            }
        }
    }

    private static final class ProjectSwitchListener
    implements PropertyChangeListener {
        private ProjectSwitchListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("enabled".equals(evt.getPropertyName())) {
                boolean b = (Boolean)evt.getNewValue();
                if (b) {
                    WindowManagerImpl.setAnyProjectOpen(false);
                }
                WindowManagerImpl.setProjectModuleEnabled(b);
            }
            try {
                if ("session_close".equals(propName)) {
                    WindowManagerImpl.setProjectOpen(false);
                    AWT performer = new AWT(false);
                    if (SwingUtilities.isEventDispatchThread()) {
                        performer.run();
                    } else {
                        while (true) {
                            if (!DeferredPerformer.getDefault().isProcessing()) {
                                SwingUtilities.invokeAndWait(performer);
                                break;
                            }
                            Thread.currentThread();
                            Thread.sleep(200L);
                        }
                    }
                }
                if (!"session_open".equals(propName)) return;
                RequestProcessor.postRequest((Runnable)new Runnable(this){
                    private final /* synthetic */ ProjectSwitchListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        AWT performer = new AWT(true);
                        EventQueue.invokeLater(performer);
                    }
                });
                return;
            }
            catch (InterruptedException e) {
                ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(e, null);
                ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
                return;
            }
            catch (InvocationTargetException e) {
                ((WindowManagerImpl)WindowManager.getDefault()).annotatePersistenceError(e, null);
                ((WindowManagerImpl)WindowManager.getDefault()).checkPersistenceErrors(false);
            }
        }

        private static class AWT
        implements Runnable {
            private final boolean open;
            static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

            public AWT(boolean open) {
                this.open = open;
            }

            public void run() {
                if (this.open) {
                    this.run_open();
                } else {
                    this.run_close();
                }
            }

            private void run_close() {
                Workspace[] ws;
                PersistenceManager pm = PersistenceManager.getDefault();
                pm.resetTCPairs();
                WindowManagerImpl wmi = WindowManagerImpl.getInstance();
                WorkspaceImpl wi = (WorkspaceImpl)wmi.getCurrentWorkspaceNoLoad();
                if (wi != null) {
                    wi.setVisible(false);
                    wi.setTopMaximizedMode(null);
                    wi.desktopPane().setMaxMode(false);
                }
                if ((ws = wmi.getWorkspacesNoLoad()) != null) {
                    int i = 0;
                    while (i < ws.length) {
                        ((WorkspaceImpl)ws[i]).closeModes();
                        ((WorkspaceImpl)ws[i]).setWasVisible(false);
                        ++i;
                    }
                }
            }

            private void run_open() {
                WindowManagerImpl wmi = (WindowManagerImpl)WindowManager.getDefault();
                if (!wmi.isWasIDEStarted()) {
                    WindowManagerImpl.setProjectOpen(true);
                    WindowManagerImpl.setAnyProjectOpen(true);
                    wmi.setWasIDEStarted(true);
                    return;
                }
                PersistenceManager pm = PersistenceManager.getDefault();
                FileObject f = pm.getWindowManagerFolder();
                DataFolder d = DataFolder.findFolder((FileObject)f);
                AWT.invalidate(d);
                DataObject[] ch = d.getChildren();
                WindowManagerImpl.setProjectOpen(true);
                WindowManagerImpl.setAnyProjectOpen(true);
                try {
                    d.setOrder(ch);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                WorkspaceImpl wi = (WorkspaceImpl)wmi.getCurrentWorkspace();
                if (wi != null) {
                    wi.setVisible(true);
                }
            }

            private static void invalidate(DataFolder d) {
                AWT.resetDataObject((DataObject)d);
                DataObject[] ch = d.getChildren();
                int i = 0;
                while (i < ch.length) {
                    if (ch[i] instanceof DataFolder) {
                        AWT.invalidate((DataFolder)ch[i]);
                    } else {
                        AWT.resetDataObject(ch[i]);
                    }
                    ++i;
                }
            }

            private static void resetDataObject(DataObject dobj) {
                ResetCookie rc = (ResetCookie)dobj.getCookie(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = AWT.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie);
                if (rc != null) {
                    rc.reset();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }

    private static final class LookupResultListener
    implements LookupListener {
        LookupResultListener() {
        }

        public void resultChanged(LookupEvent ev) {
            ModuleInfo curModuleInfo = WindowUtils.findModule("org.netbeans.modules.projects", null, null);
            if (curModuleInfo != null) {
                curModuleInfo.addPropertyChangeListener((PropertyChangeListener)projectSwitchL);
                boolean oldValue = WindowManagerImpl.isProjectModuleEnabled();
                if (curModuleInfo.isEnabled() && !oldValue) {
                    WindowManagerImpl.setAnyProjectOpen(false);
                    WindowManagerImpl.setProjectModuleEnabled(true);
                }
                if (!curModuleInfo.isEnabled() && oldValue) {
                    WindowManagerImpl.setProjectModuleEnabled(false);
                }
            }
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = -8212722893309295268L;
        private static final String WORKSPACES = "workspaces";
        private static final String CURRENT_WORKSPACE = "currentWorkspace";
        private static final String MAIN_WINDOW_BOUNDS = "mainWindowBounds";
        private static final String UI_MODE = "uiMode";
        private static final String SCREEN_SIZE = "screenSize";
        private static final String TABBED_CONTAINER_UI = "tabbedContainerUI";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("workspaces", class$java$util$List == null ? (class$java$util$List = SerializationReplacer.class$("java.util.List")) : class$java$util$List), new ObjectStreamField("currentWorkspace", class$org$netbeans$core$windows$WorkspaceImpl == null ? (class$org$netbeans$core$windows$WorkspaceImpl = SerializationReplacer.class$("org.netbeans.core.windows.WorkspaceImpl")) : class$org$netbeans$core$windows$WorkspaceImpl), new ObjectStreamField("mainWindowBounds", class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = SerializationReplacer.class$("java.awt.Rectangle")) : class$java$awt$Rectangle), new ObjectStreamField("uiMode", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("screenSize", class$java$awt$Dimension == null ? (class$java$awt$Dimension = SerializationReplacer.class$("java.awt.Dimension")) : class$java$awt$Dimension), new ObjectStreamField("tabbedContainerUI", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer)};
        private Workspace[] workspaces;
        private Workspace current;
        private Dimension oldScreenSize;
        private int uiMode;
        private int tabbedContainerUI;
        private Rectangle mainWindowBounds;
        private boolean isStartup = true;
        static /* synthetic */ Class class$java$util$List;
        static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceImpl;
        static /* synthetic */ Class class$java$awt$Rectangle;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$awt$Dimension;

        SerializationReplacer() {
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
            PersistenceManager.getDefault().cleanXML();
            StateManager stateMan = StateManager.getDefault();
            stateMan.setMainState(128);
            try {
                ObjectInputStream.GetField gf = ois.readFields();
                if (WindowUtils.hasObjectStreamField(gf, MAIN_WINDOW_BOUNDS)) {
                    List nwsList = (List)gf.get(WORKSPACES, null);
                    Workspace[] nworkspaces = nwsList.toArray(new Workspace[nwsList.size()]);
                    ArrayList<Workspace> wsList = new ArrayList<Workspace>();
                    Workspace browsing = null;
                    int i = 0;
                    while (i < nworkspaces.length) {
                        if ("Browsing".equals(nworkspaces[i].getName())) {
                            browsing = nworkspaces[i];
                        } else {
                            wsList.add(nworkspaces[i]);
                        }
                        ++i;
                    }
                    this.workspaces = wsList.toArray(new Workspace[wsList.size()]);
                    this.current = (Workspace)gf.get(CURRENT_WORKSPACE, null);
                    if (this.current == browsing) {
                        this.current = wsList.size() > 0 ? this.workspaces[0] : null;
                    }
                    this.oldScreenSize = (Dimension)gf.get(SCREEN_SIZE, null);
                    this.uiMode = (Integer)gf.get(UI_MODE, null);
                    this.mainWindowBounds = (Rectangle)gf.get(MAIN_WINDOW_BOUNDS, null);
                } else {
                    int count = ois.readInt();
                    this.workspaces = new Workspace[count];
                    Workspace browsing = null;
                    int i = 0;
                    while (i < count) {
                        this.workspaces[i] = (Workspace)ois.readObject();
                        if ("CTL_Workspace_Browsing".equals(this.workspaces[i].getDisplayName())) {
                            browsing = this.workspaces[i];
                            Workspace[] nworkspaces = new Workspace[count - 1];
                            System.arraycopy(this.workspaces, 0, nworkspaces, 0, i);
                            if (i + 1 < count) {
                                System.arraycopy(this.workspaces, i + 1, nworkspaces, i, count - i - 1);
                            }
                            --count;
                            --i;
                            this.workspaces = nworkspaces;
                        }
                        ++i;
                    }
                    this.current = (Workspace)ois.readObject();
                    if (this.current == browsing) {
                        this.current = count > 0 ? this.workspaces[0] : null;
                    }
                    this.mainWindowBounds = (Rectangle)ois.readObject();
                    this.uiMode = 1;
                }
                this.tabbedContainerUI = gf.getObjectStreamClass().getField(TABBED_CONTAINER_UI) != null ? (Integer)gf.get(TABBED_CONTAINER_UI, null) : 1;
                Object var11_14 = null;
                this.isStartup = false;
                stateMan.setMainState(32);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.isStartup = false;
                stateMan.setMainState(32);
                throw throwable;
            }
        }

        private synchronized Object readResolve() throws ObjectStreamException {
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            StateManager stateMan = StateManager.getDefault();
            stateMan.setMainState(128);
            SwingUtilities.invokeLater(new Runnable(this, wm, stateMan){
                private final /* synthetic */ WindowManagerImpl val$wm;
                private final /* synthetic */ StateManager val$stateMan;
                private final /* synthetic */ SerializationReplacer this$0;
                {
                    this.this$0 = this$0;
                    this.val$wm = val$wm;
                    this.val$stateMan = val$stateMan;
                }

                public void run() {
                    try {
                        SerializationReplacer.access$400(this.this$0);
                        int i = 0;
                        while (i < SerializationReplacer.access$500(this.this$0).length) {
                            ((WorkspaceImpl)SerializationReplacer.access$500(this.this$0)[i]).validateSelf();
                            ++i;
                        }
                        this.val$wm.setWorkspaces(SerializationReplacer.access$500(this.this$0));
                        UIModeManager uiModeManager = UIModeManager.getDefault();
                        if (uiModeManager.getUIMode() != SerializationReplacer.access$600(this.this$0)) {
                            uiModeManager.changeModeFrameTypes();
                        }
                        int i2 = 0;
                        while (i2 < SerializationReplacer.access$500(this.this$0).length) {
                            ((WorkspaceImpl)SerializationReplacer.access$500(this.this$0)[i2]).validateData();
                            ++i2;
                        }
                        this.val$wm.setCurrentWorkspace(SerializationReplacer.access$700(this.this$0));
                        Object var5_4 = null;
                        this.val$stateMan.setMainState(32);
                        this.val$wm.checkPersistenceErrors(true);
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.val$stateMan.setMainState(32);
                        this.val$wm.checkPersistenceErrors(true);
                        throw throwable;
                    }
                    DeferredPerformer.getDefault().putRequest(new DeferredPerformer.DeferredCommand(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void performCommand(DeferredPerformer.DeferredContext dc) {
                            try {
                                WindowManagerImpl wm2 = (WindowManagerImpl)WindowManager.getDefault();
                                PersistenceManager.getDefault().writeXML();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }, new DeferredPerformer.DeferredContext(null, true));
                }
            });
            return wm;
        }

        private void initGlobalProperties() {
            WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
            wm.mainPositioned = true;
            wm.oldScreenSize = this.oldScreenSize;
            wm.oldMainWindowBounds = new Rectangle(this.mainWindowBounds);
            TabbedContainerUIManager.getDefault().setTabbedContainerUI(this.tabbedContainerUI);
            if (UIModeManager.getDefault().getUIMode() == this.uiMode) {
                if (this.oldScreenSize != null) {
                    WindowUtils.convertRectangle(this.mainWindowBounds, this.oldScreenSize, Toolkit.getDefaultToolkit().getScreenSize());
                }
                ((Component)MainWindow.getDefault()).setBounds(this.mainWindowBounds);
            }
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            StateManager stateMan = StateManager.getDefault();
            stateMan.setMainState(64);
            try {
                ObjectOutputStream.PutField pf = oos.putFields();
                pf.put(WORKSPACES, Arrays.asList(wm.workspaces));
                pf.put(CURRENT_WORKSPACE, wm.current);
                pf.put(MAIN_WINDOW_BOUNDS, MainWindow.getDefault().getBounds());
                pf.put(SCREEN_SIZE, Toolkit.getDefaultToolkit().getScreenSize());
                pf.put(UI_MODE, new Integer(UIModeManager.getDefault().getUIMode()));
                pf.put(TABBED_CONTAINER_UI, new Integer(TabbedContainerUIManager.getDefault().getTabbedContainerUI()));
                oos.writeFields();
                Object var6_5 = null;
                stateMan.setMainState(32);
                wm.checkPersistenceErrors(false);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                stateMan.setMainState(32);
                wm.checkPersistenceErrors(false);
                throw throwable;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$400(SerializationReplacer x0) {
            x0.initGlobalProperties();
        }

        static /* synthetic */ Workspace[] access$500(SerializationReplacer x0) {
            return x0.workspaces;
        }

        static /* synthetic */ int access$600(SerializationReplacer x0) {
            return x0.uiMode;
        }

        static /* synthetic */ Workspace access$700(SerializationReplacer x0) {
            return x0.current;
        }
    }
}

