/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WorkspaceExplorerDialog;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

class WorkspaceExplorerPanel
extends JPanel {
    private WorkspaceExplorerDialog wed;
    protected DefaultMutableTreeNode top;
    private ImageIcon curIcon = null;
    private Image modeIcon = null;
    private int nodeOrder;
    private static String DEFAULT_WORKSPACE_ICON = "/org/netbeans/core/resources/workspaces.gif";
    private static String DEFAULT_MODE_ICON = "/org/netbeans/core/resources/window.gif";
    private JScrollPane listScrollPane1;
    private JTree listOfActive;
    private JLabel modesInWorkspaces;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceExplorerPanel;

    protected WorkspaceExplorerPanel(WorkspaceExplorerDialog wed) {
        this.wed = wed;
        this.initComponents();
        this.setPreferredSize(this.getPreferredSize());
        this.updateTreeScrollPane();
        this.listOfActive.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.listOfActive);
        this.listOfActive.setCellRenderer(new weTreeRenderer());
        this.listOfActive.addKeyListener(wed.weKeyListener());
        this.listOfActive.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)WorkspaceExplorerPanel.this.listOfActive.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object nodeInfo = node.getUserObject();
                if (node.isLeaf()) {
                    NodeInfo nodeInstance = (NodeInfo)nodeInfo;
                } else {
                    NodeInfo nodeInstance = (NodeInfo)nodeInfo;
                }
            }
        });
        this.modesInWorkspaces.setLabelFor(this.listOfActive);
    }

    private static Image giveMeIcon(String aktIcon) {
        return Utilities.loadImage((String)aktIcon);
    }

    public void requestFocus() {
        this.listOfActive.requestFocus();
    }

    private void updateTreeScrollPane() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? (class$org$netbeans$core$windows$WorkspaceExplorerPanel = WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel")) : class$org$netbeans$core$windows$WorkspaceExplorerPanel), (String)"CTL_rootOfWorkspaces"));
        this.createTreeContent(top);
        this.listOfActive = new JTree(top);
        this.listOfActive.setRootVisible(false);
        this.listScrollPane1.setViewportView(this.listOfActive);
        this.listOfActive.requestDefaultFocus();
        this.setSelectedObject();
    }

    private void setSelectedObject() {
        Workspace currentWorkspace = WindowManager.getDefault().getCurrentWorkspace();
        Workspace[] allWorkspaces = WindowManager.getDefault().getWorkspaces();
        int i = 0;
        while (i < WindowManager.getDefault().getWorkspaces().length) {
            if (allWorkspaces[i] == currentWorkspace) {
                this.listOfActive.setSelectionInterval(i, i);
            }
            ++i;
        }
    }

    protected void createTreeContent(DefaultMutableTreeNode top) {
        Object category = null;
        DefaultMutableTreeNode nodeWorkspace = null;
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        this.nodeOrder = 0;
        int i = 0;
        while (i < workspaces.length) {
            this.curIcon = new ImageIcon(WorkspaceExplorerPanel.giveMeIcon(DEFAULT_WORKSPACE_ICON));
            String curName = Actions.cutAmpersand((String)workspaces[i].getDisplayName());
            nodeWorkspace = new DefaultMutableTreeNode(new NodeInfo(1, curName, i + 1 + "." + NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel") : class$org$netbeans$core$windows$WorkspaceExplorerPanel), (String)"CTL_Workspace") + curName, this.nodeOrder, i, 0, this.curIcon));
            top.add(nodeWorkspace);
            this.createChildren(workspaces[i], nodeWorkspace, i);
            ++this.nodeOrder;
            ++i;
        }
    }

    void createChildren(Workspace currentWorkspace, DefaultMutableTreeNode nodeW, int workOrder) {
        DefaultMutableTreeNode nodeWindow = null;
        ModeImpl[] modes = currentWorkspace.getModes().toArray(new ModeImpl[0]);
        int i = 0;
        while (i < modes.length) {
            if (!modes[i].isOrphan()) {
                this.modeIcon = modes[i].getIcon();
                this.curIcon = new ImageIcon(this.modeIcon != null ? this.modeIcon : WorkspaceExplorerPanel.giveMeIcon(DEFAULT_MODE_ICON));
                nodeWindow = new DefaultMutableTreeNode(new NodeInfo(2, modes[i].getDisplayName(), i + 1 + "." + NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel") : class$org$netbeans$core$windows$WorkspaceExplorerPanel), (String)"CTL_Mode") + modes[i].getDisplayName(), this.nodeOrder, workOrder, i, this.curIcon));
                nodeW.add(nodeWindow);
                ++this.nodeOrder;
            }
            ++i;
        }
    }

    DefaultMutableTreeNode getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.listOfActive.getLastSelectedPathComponent();
        return node;
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Dimension max = this.getMaximumSize();
        if (pref.width > max.width) {
            pref.width = max.width;
        }
        if (pref.height > max.height) {
            pref.height = max.height;
        }
        return pref;
    }

    private void initComponents() {
        this.listScrollPane1 = new JScrollPane();
        this.listOfActive = new JTree();
        this.modesInWorkspaces = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? (class$org$netbeans$core$windows$WorkspaceExplorerPanel = WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel")) : class$org$netbeans$core$windows$WorkspaceExplorerPanel), (String)"CTL_WorkExplorer"));
        this.setMinimumSize(new Dimension(400, 300));
        this.listScrollPane1.setViewportView(this.listOfActive);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 10);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.listScrollPane1, gridBagConstraints1);
        this.modesInWorkspaces.setText(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? (class$org$netbeans$core$windows$WorkspaceExplorerPanel = WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel")) : class$org$netbeans$core$windows$WorkspaceExplorerPanel), (String)"LBL_ChooseWorkspace"));
        this.modesInWorkspaces.setRequestFocusEnabled(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 12, 5, 10);
        this.add((Component)this.modesInWorkspaces, gridBagConstraints1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class NodeInfo {
        public int nodeType;
        public String nodeName;
        public String nodeDesc;
        public int nodeOrder;
        public int nodeWorkspaceOrder;
        public int nodeModeOrder;
        public ImageIcon nodeIcon;

        protected NodeInfo(int type, String name, String desc, int order, int orderWork, int orderMode, ImageIcon icon) {
            this.nodeType = type;
            this.nodeName = name;
            this.nodeDesc = desc;
            this.nodeOrder = order;
            this.nodeWorkspaceOrder = orderWork;
            this.nodeModeOrder = orderMode;
            this.nodeIcon = icon;
        }

        public String toString() {
            return this.nodeName;
        }
    }

    private class weTreeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon modeIcon;

        private weTreeRenderer() {
            this.setClosedIcon(new ImageIcon(this.getClass().getResource(DEFAULT_WORKSPACE_ICON)));
            this.setOpenIcon(new ImageIcon(this.getClass().getResource(DEFAULT_WORKSPACE_ICON)));
            this.modeIcon = new ImageIcon(this.getClass().getResource(DEFAULT_MODE_ICON));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(this.getNodeInfo((Object)value).nodeIcon);
            this.setToolTipText(this.getNodeInfo((Object)value).nodeDesc);
            return this;
        }

        protected NodeInfo getNodeInfo(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            NodeInfo nodeInfo = (NodeInfo)node.getUserObject();
            return nodeInfo;
        }
    }
}

