/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.dnd;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TopComponentDragSupport
extends KeyAdapter
implements AWTEventListener,
DragGestureListener,
DragSourceListener {
    public static final String MIME_TOP_COMPONENT = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent";
    public static final String MIME_TOP_COMPONENT_CLONEABLE = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable";
    private static final int CURSOR_COPY = 0;
    private static final int CURSOR_COPY_NO = 1;
    private static final int CURSOR_MOVE = 2;
    private static final int CURSOR_MOVE_NO = 3;
    private static final int CURSOR_COPY_NO_MOVE = 4;
    private static final String NAME_CURSOR_COPY = "CursorTopComponentCopy";
    private static final String NAME_CURSOR_COPY_NO = "CursorTopComponentCopyNo";
    private static final String NAME_CURSOR_MOVE = "CursorTopComponentMove";
    private static final String NAME_CURSOR_MOVE_NO = "CursorTopComponentMoveNo";
    private static final String NAME_CURSOR_COPY_NO_MOVE = "CursorTopComponentCopyNoMove";
    private static TopComponentDragSupport defaultDragSupport;
    private Reference dragContextWRef = new WeakReference<Object>(null);
    private boolean canCopy;
    int hackUserDropAction;
    private boolean hackESC;
    private final Set keyObservers = new WeakSet(4);
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
    static /* synthetic */ Class class$java$awt$dnd$DragSourceEvent;

    private TopComponentDragSupport() {
    }

    public static synchronized TopComponentDragSupport getDefault() {
        if (defaultDragSupport == null) {
            defaultDragSupport = new TopComponentDragSupport();
            Toolkit.getDefaultToolkit().addAWTEventListener(defaultDragSupport, 32L);
        }
        return defaultDragSupport;
    }

    public boolean copyOperationPossible() {
        return this.canCopy;
    }

    public void eventDispatched(AWTEvent evt) {
        if (evt.getID() != 506) {
            return;
        }
        if (WindowDnDManager.getDefault().isDragging()) {
            return;
        }
        MouseEvent me = (MouseEvent)evt;
        Object source = me.getSource();
        if (!(source instanceof Component)) {
            return;
        }
        Component srcComp = (Component)source;
        if (srcComp instanceof JTree && ((JTree)srcComp).getPathForLocation(me.getX(), me.getY()) != null) {
            return;
        }
        srcComp = SwingUtilities.getDeepestComponentAt(srcComp, me.getX(), me.getY());
        boolean shiftDown = me.isShiftDown();
        boolean ctrlDown = me.isControlDown();
        TopComponent tc = null;
        if (shiftDown || ctrlDown) {
            tc = srcComp instanceof TopComponent ? (TopComponent)srcComp : (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponentDragSupport.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, srcComp);
        }
        if (tc == null) {
            JTabbedPane tab = (JTabbedPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = TopComponentDragSupport.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane, srcComp);
            if (tab == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint(srcComp, me.getPoint(), tab);
            int i = JdkBug4620540Hack.findTabForCoordinate(tab, p.x, p.y);
            if (i >= 0 && tab.getComponentAt(i) instanceof TopComponent) {
                tc = (TopComponent)tab.getComponentAt(i);
            }
        }
        if (tc == null) {
            return;
        }
        this.hackUserDropAction = ctrlDown ? 1 : 2;
        ArrayList<MouseEvent> list = new ArrayList<MouseEvent>();
        list.add(me);
        this.doStartDrag(tc, new DragGestureEvent(new FakeDragGestureRecognizer(me), this.hackUserDropAction, me.getPoint(), list));
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        int index;
        if (WindowDnDManager.getDefault().isDragging()) {
            return;
        }
        Component comp = evt.getComponent();
        if (!(comp instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tp = (JTabbedPane)comp;
        InputEvent trigger = evt.getTriggerEvent();
        if (trigger instanceof MouseEvent) {
            Point p = ((MouseEvent)trigger).getPoint();
            index = tp.getUI().tabForCoordinate(tp, p.x, p.y);
            if (index == -1) {
                return;
            }
        } else {
            return;
        }
        comp = tp.getComponentAt(index);
        if (!(comp instanceof TopComponent)) {
            return;
        }
        TopComponent tc = (TopComponent)comp;
        int dragAction = evt.getDragAction();
        if (dragAction != 2 && dragAction != 1) {
            return;
        }
        this.hackUserDropAction = dragAction;
        this.doStartDrag(tc, evt);
    }

    private void doStartDrag(TopComponent tc, DragGestureEvent evt) {
        Dialog dlg = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = TopComponentDragSupport.class$("java.awt.Dialog")) : class$java$awt$Dialog, (Component)tc);
        if (dlg != null && dlg.isModal()) {
            return;
        }
        this.canCopy = tc instanceof TopComponent.Cloneable;
        WindowDnDManager.getDefault().setOriginalBounds(tc.getBounds());
        WindowDnDManager.getDefault().dragStarting();
        Cursor cursor = this.hackUserDropAction == 2 ? TopComponentDragSupport.getDragCursor(2) : (this.canCopy ? TopComponentDragSupport.getDragCursor(0) : TopComponentDragSupport.getDragCursor(4));
        Container con = SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = TopComponentDragSupport.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer, (Component)tc);
        if (con == null) {
            this.addListening((Container)tc);
        } else {
            this.addListening(con);
        }
        this.hackESC = false;
        try {
            evt.startDrag(cursor, new TopComponentTransferable(tc), this);
        }
        catch (InvalidDnDOperationException idoe) {
            idoe.printStackTrace();
            this.removeListening();
            WindowDnDManager.getDefault().resetDragSource();
        }
    }

    private void addListening(Container con) {
        con.addKeyListener(this);
        this.keyObservers.add(con);
        Component[] cs = con.getComponents();
        int i = 0;
        while (i < cs.length) {
            cs[i].addKeyListener(this);
            this.keyObservers.add(cs[i]);
            if (cs[i] instanceof Container) {
                this.addListening((Container)cs[i]);
            }
            ++i;
        }
    }

    private void removeListening() {
        Iterator it = this.keyObservers.iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            c.removeKeyListener(this);
        }
        this.keyObservers.clear();
    }

    public void dragEnter(DragSourceDragEvent evt) {
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(evt.getDragSourceContext());
        }
    }

    public void dragOver(DragSourceDragEvent evt) {
    }

    public void dragExit(DragSourceEvent evt) {
        Point location;
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(evt.getDragSourceContext());
        }
        if ((location = TopComponentDragSupport.getLocationForEvent(evt)) == null) {
            return;
        }
        MainWindow mainWindow = MainWindow.getDefault();
        Point checkLocation = new Point(location);
        Rectangle bounds = mainWindow.getBounds();
        if (bounds.contains(checkLocation)) {
            Component[] cs = mainWindow.getContentPane().getComponents();
            Component comp = null;
            int i = 0;
            while (i < cs.length) {
                if (cs[i] instanceof DesktopPane) {
                    comp = cs[i];
                    break;
                }
                ++i;
            }
            if (comp != null && (comp = ((DesktopPane)comp).getComponentAt("CENTER")) != null) {
                SwingUtilities.convertPointFromScreen(location, comp);
                bounds = comp.getBounds();
                if (new Rectangle(0, 0, bounds.width, bounds.height).contains(location)) {
                    this.dragEnterHack(this.hackUserDropAction);
                    return;
                }
            }
            this.dragExitHack();
        }
    }

    public void dropActionChanged(DragSourceDragEvent evt) {
        int type;
        int userAction;
        String name = evt.getDragSourceContext().getCursor().getName();
        if (name == null) {
            return;
        }
        this.hackUserDropAction = userAction = evt.getUserAction();
        if ((NAME_CURSOR_COPY.equals(name) || NAME_CURSOR_COPY_NO_MOVE.equals(name)) && userAction == 2) {
            type = 2;
        } else if (NAME_CURSOR_COPY_NO.equals(name) && userAction == 2) {
            type = 3;
        } else if (NAME_CURSOR_MOVE.equals(name) && userAction == 1) {
            type = 0;
        } else if (NAME_CURSOR_MOVE_NO.equals(name) && userAction == 1) {
            type = 1;
        } else {
            return;
        }
        if (type == 0 && !this.canCopy) {
            type = 4;
        }
        evt.getDragSourceContext().setCursor(TopComponentDragSupport.getDragCursor(type));
    }

    public void dragDropEnd(final DragSourceDropEvent evt) {
        Point checkLocation;
        WindowDnDManager.getDefault().dragFinished();
        if (WindowDnDManager.getDefault().isDropSuccess()) {
            this.removeListening();
            return;
        }
        final Point location = TopComponentDragSupport.getLocationForEvent(evt);
        if (location == null) {
            this.removeListening();
            return;
        }
        boolean forceFrameType = false;
        MainWindow mainWindow = MainWindow.getDefault();
        if (WindowUtils.isMdi()) {
            checkLocation = new Point(location);
            SwingUtilities.convertPointFromScreen(checkLocation, mainWindow);
            Rectangle bounds = mainWindow.getBounds();
            if (!new Rectangle(0, 0, bounds.width, bounds.height).contains(checkLocation)) {
                if (evt.getDropSuccess()) {
                    this.removeListening();
                    return;
                }
                forceFrameType = true;
            } else {
                Component[] cs = mainWindow.getContentPane().getComponents();
                Component comp = null;
                int i = 0;
                while (i < cs.length) {
                    if (cs[i] instanceof DesktopPane) {
                        comp = cs[i];
                        break;
                    }
                    ++i;
                }
                if (comp == null) {
                    this.removeListening();
                    return;
                }
                if ((comp = ((DesktopPane)comp).getComponentAt("CENTER")) == null) {
                    this.removeListening();
                    return;
                }
                SwingUtilities.convertPointFromScreen(location, comp);
                bounds = comp.getBounds();
                if (!new Rectangle(0, 0, bounds.width, bounds.height).contains(location)) {
                    this.removeListening();
                    return;
                }
            }
        } else {
            checkLocation = new Point(location);
            SwingUtilities.convertPointFromScreen(checkLocation, mainWindow);
            Rectangle bounds = mainWindow.getBounds();
            if (new Rectangle(0, 0, bounds.width, bounds.height).contains(checkLocation)) {
                this.removeListening();
                return;
            }
        }
        final boolean forceTopFrameType = forceFrameType;
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (TopComponentDragSupport.access$100(1.access$000(this.this$1))) {
                            TopComponentDragSupport.access$200(1.access$000(this.this$1));
                            return;
                        }
                        TopComponent tc = TopComponentDragSupport.extractTopComponent(false, 1.access$300(this.this$1).getDragSourceContext().getTransferable(), this.getClass().getClassLoader());
                        if (tc != null) {
                            Rectangle newBounds = TopComponentDragSupport.access$500(tc, 1.access$400(this.this$1));
                            if (1.access$000(this.this$1).hackUserDropAction == 1 && tc instanceof TopComponent.Cloneable) {
                                WindowUtils.dockIntoNewMode(tc, true, newBounds, 1.access$600(this.this$1) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : (WindowUtils.isMdi() ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : null));
                            } else if (1.access$000(this.this$1).hackUserDropAction == 2) {
                                TopComponent[] tcs;
                                ModeImpl originalMode = (ModeImpl)WindowManager.getDefault().getCurrentWorkspace().findMode(tc);
                                if (originalMode != null && !"org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(originalMode.getFrameType()) && (tcs = originalMode.getTopComponents()).length == 1 && tcs[0] == tc) {
                                    originalMode.release(tc);
                                }
                                WindowUtils.dockIntoNewMode(tc, false, newBounds, 1.access$600(this.this$1) ? "org.netbeans.core.windows.frames.TopFrameTypeImpl" : (WindowUtils.isMdi() ? "org.netbeans.core.windows.frames.InternalFrameTypeImpl" : null));
                            }
                        }
                    }
                });
            }

            static /* synthetic */ TopComponentDragSupport access$000(1 x0) {
                return x0.TopComponentDragSupport.this;
            }

            static /* synthetic */ DragSourceDropEvent access$300(1 x0) {
                return x0.evt;
            }

            static /* synthetic */ Point access$400(1 x0) {
                return x0.location;
            }

            static /* synthetic */ boolean access$600(1 x0) {
                return x0.forceTopFrameType;
            }
        }, (int)250);
    }

    private static Rectangle getBoundsForNewMode(TopComponent tc, Point location) {
        int width = tc.getWidth();
        int height = tc.getHeight();
        Window window = SwingUtilities.getWindowAncestor((Component)tc);
        if (window != null) {
            Insets ins = window.getInsets();
            width += ins.left + ins.right;
            height += ins.top + ins.bottom;
        }
        Rectangle tcBounds = tc.getBounds();
        Rectangle initBounds = new Rectangle(location.x, location.y, width, height);
        return initBounds;
    }

    public void dragEnterHack(int dropAction) {
        int type;
        DragSourceContext ctx = (DragSourceContext)this.dragContextWRef.get();
        if (ctx == null) {
            return;
        }
        if (dropAction == 2) {
            type = 2;
        } else if (dropAction == 1) {
            type = this.canCopy ? 0 : 4;
        } else {
            return;
        }
        ctx.setCursor(TopComponentDragSupport.getDragCursor(type));
    }

    public void dragExitHack() {
        int type;
        DragSourceContext ctx = (DragSourceContext)this.dragContextWRef.get();
        if (ctx == null) {
            return;
        }
        String name = ctx.getCursor().getName();
        if (NAME_CURSOR_COPY.equals(name) || NAME_CURSOR_COPY_NO_MOVE.equals(name)) {
            type = 1;
        } else if (NAME_CURSOR_MOVE.equals(name)) {
            type = 3;
        } else {
            return;
        }
        ctx.setCursor(TopComponentDragSupport.getDragCursor(type));
    }

    void dragFinished() {
        this.dragContextWRef = new WeakReference<Object>(null);
    }

    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.hackESC = true;
        }
    }

    static Point getLocationForEvent(DragSourceEvent evt) {
        try {
            Method m = (class$java$awt$dnd$DragSourceEvent == null ? (class$java$awt$dnd$DragSourceEvent = TopComponentDragSupport.class$("java.awt.dnd.DragSourceEvent")) : class$java$awt$dnd$DragSourceEvent).getMethod("getLocation", new Class[0]);
            return (Point)m.invoke((Object)evt, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NoSuchMethodException nme) {
            nme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return null;
    }

    private static Cursor getDragCursor(int type) {
        Image image = null;
        String name = null;
        if (type == 0) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopy.gif");
            name = NAME_CURSOR_COPY;
        } else if (type == 1) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            name = NAME_CURSOR_COPY_NO;
        } else if (type == 2) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMove.gif");
            name = NAME_CURSOR_MOVE;
        } else if (type == 3) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMoveNo.gif");
            name = NAME_CURSOR_MOVE_NO;
        } else if (type == 4) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            name = NAME_CURSOR_COPY_NO_MOVE;
        } else {
            throw new IllegalArgumentException("Unknown cursor type=" + type);
        }
        return TopComponentDragSupport.createCustomCursor(image, name);
    }

    private static Cursor createCustomCursor(Image icon, String name) {
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getBestCursorSize(16, 16);
        Image i = icon;
        if (d.width != icon.getWidth(null)) {
            BufferedImage empty = TopComponentDragSupport.createBufferedImage(d.width, d.height);
            i = Utilities.mergeImages((Image)icon, (Image)empty, (int)0, (int)0);
        }
        return t.createCustomCursor(i, new Point(11, 9), name);
    }

    private static final BufferedImage createBufferedImage(int width, int height) {
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    public static TopComponent extractTopComponent(boolean clone, Transferable tr, ClassLoader classLoader) {
        DataFlavor df = TopComponentDragSupport.getDataFlavorForDropAction(clone, classLoader);
        if (df == null) {
            return null;
        }
        if (tr.isDataFlavorSupported(df)) {
            try {
                TopComponent tc;
                if (clone) {
                    TopComponent.Cloneable ctc = (TopComponent.Cloneable)tr.getTransferData(df);
                    tc = ctc.cloneComponent();
                } else {
                    tc = (TopComponent)tr.getTransferData(df);
                }
                return tc;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                return null;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static DataFlavor getDataFlavorForDropAction(boolean clone, ClassLoader classLoader) {
        DataFlavor df;
        if (clone) {
            try {
                df = new DataFlavor(MIME_TOP_COMPONENT_CLONEABLE, null, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException("Can't create DataFlavor with MIME_TOP_COMPONENT_CLONEABLE using " + classLoader), (Throwable)cnfe);
            }
        } else {
            df = new DataFlavor(MIME_TOP_COMPONENT, null);
        }
        return df;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ boolean access$100(TopComponentDragSupport x0) {
        return x0.hackESC;
    }

    static /* synthetic */ void access$200(TopComponentDragSupport x0) {
        x0.removeListening();
    }

    static /* synthetic */ Rectangle access$500(TopComponent x0, Point x1) {
        return TopComponentDragSupport.getBoundsForNewMode(x0, x1);
    }

    private static class FakeDragGestureRecognizer
    extends DragGestureRecognizer {
        public FakeDragGestureRecognizer(MouseEvent evt) {
            super(WindowDnDManager.getDefault().getWindowDragSource(), (Component)evt.getSource(), 3, null);
            this.appendEvent(evt);
        }

        public void registerListeners() {
        }

        public void unregisterListeners() {
        }
    }

    private static class TopComponentTransferable
    implements Transferable {
        private TopComponent tc;

        public TopComponentTransferable(TopComponent tc) {
            this.tc = tc;
        }

        public Object getTransferData(DataFlavor df) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(df.getMimeType())) {
                return this.tc;
            }
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(df.getMimeType()) && this.tc instanceof TopComponent.Cloneable) {
                return this.tc;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (this.tc instanceof TopComponent.Cloneable) {
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null), new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE, null)};
            }
            return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null)};
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(df.getMimeType())) {
                return true;
            }
            return TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(df.getMimeType()) && this.tc instanceof TopComponent.Cloneable;
        }
    }
}

