/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.windows.TopComponent;

final class CloseButtonTabbedPane
extends JTabbedPane
implements ChangeListener {
    public static final int UI_TYPE_NORMAL = 0;
    public static final int UI_TYPE_ARROWS = 1;
    public static final int UI_TYPE_POPUP = 2;
    private int uiType = 0;
    public static final boolean CLOSE_BUTTON_ENABLED;
    public static final String TAB_NAME_TRAILING_SPACE;
    private static Image closeTabImage;
    private static Image closeTabInactiveImage;
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;
    private static final boolean plainTabs;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$CloseButtonTabbedPane;

    CloseButtonTabbedPane() {
        if (CLOSE_BUTTON_ENABLED) {
            this.addChangeListener(this);
            CloseButtonListener.install();
        }
        if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
            try {
                Method method = this.getClass().getMethod("setFocusable", Boolean.TYPE);
                method.invoke((Object)this, new Boolean(false));
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        } else {
            this.setRequestFocusEnabled(false);
        }
    }

    void setUIType(int uiType) {
        this.uiType = uiType;
    }

    public void updateUI() {
        if (this.uiType == 0) {
            super.updateUI();
        } else if (this.uiType == 1) {
            this.setUI(new ArrowsTabbedPaneUI());
        } else if (this.uiType == 2) {
            this.setUI(new PopupTabbedPaneUI());
        } else {
            throw new IllegalStateException("Unknown uiType " + this.uiType + " in " + this);
        }
    }

    public Insets getInsets() {
        Insets result = UIManager.getInsets("nb.CloseButtonTabPane.Insets");
        if (result == null) {
            result = UIManager.get("nb.useBorderPolicy") == null ? new Insets(0, 0, 0, 0) : new Insets(2, 2, 2, 2);
        }
        return result;
    }

    public void stateChanged(ChangeEvent e) {
        this.reset();
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int i) {
        Rectangle b = this.getBoundsAt(i);
        if (b == null) {
            return null;
        }
        b = new Rectangle(b);
        JdkBug4620540Hack.fixGetBoundsAt(b);
        Dimension tabsz = this.getSize();
        if (b.x + b.width >= tabsz.width || b.y + b.height >= tabsz.height) {
            return null;
        }
        return new Rectangle(b.x + b.width - 13, b.y + b.height / 2 - 5, 8, 8);
    }

    private static void checkUIColors() {
        if (UIManager.getColor("Button.shadow") == null) {
            UIManager.put("Button.shadow", new ColorUIResource(153, 153, 153));
        }
        if (UIManager.getColor("Button.darkShadow") == null) {
            UIManager.put("Button.darkShadow", new ColorUIResource(102, 102, 102));
        }
        if (UIManager.getColor("Button.highlight") == null) {
            UIManager.put("Button.highlight", new ColorUIResource(Color.white));
        }
        if (UIManager.getColor("Button.background") == null) {
            UIManager.put("Button.background", new ColorUIResource(204, 204, 204));
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!CLOSE_BUTTON_ENABLED) {
            return;
        }
        CloseButtonTabbedPane.checkUIColors();
        int selectedIndex = this.getSelectedIndex();
        int i = 0;
        int n = this.getTabCount();
        while (i < n) {
            Rectangle r = this.getCloseButtonBoundsAt(i);
            if (r != null) {
                if (i == this.pressedCloseButtonIndex && !this.draggedOut) {
                    g.setColor(UIManager.getColor("Button.shadow"));
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                if (i != selectedIndex) {
                    g.drawImage(closeTabInactiveImage, r.x + 2, r.y + 2, this);
                } else {
                    g.drawImage(closeTabImage, r.x + 2, r.y + 2, this);
                }
                if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                    g.setColor(UIManager.getColor("Button.darkShadow"));
                    g.drawRect(r.x, r.y, r.width, r.height);
                    g.setColor(i == selectedIndex ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                    g.drawRect(r.x + 1, r.y + 1, r.width, r.height);
                    g.setColor(UIManager.getColor("Button.highlight").brighter());
                    g.drawLine(r.x + r.width, r.y + 1, r.x + r.width, r.y + 1);
                    g.drawLine(r.x + 1, r.y + r.height, r.x + 1, r.y + r.height);
                } else if (i == this.pressedCloseButtonIndex) {
                    g.setColor(UIManager.getColor("Button.shadow"));
                    g.drawRect(r.x, r.y, r.width, r.height);
                    g.setColor(i == selectedIndex ? UIManager.getColor("Button.highlight") : UIManager.getColor("Button.background"));
                    g.drawLine(r.x + 1, r.y + r.height + 1, r.x + r.width + 1, r.y + r.height + 1);
                    g.drawLine(r.x + r.width + 1, r.y + 1, r.x + r.width + 1, r.y + r.height + 1);
                    g.setColor(UIManager.getColor("Button.background"));
                    g.drawLine(r.x + 1, r.y + 1, r.x + r.width, r.y + 1);
                    g.drawLine(r.x + 1, r.y + 1, r.x + 1, r.y + r.height);
                }
            }
            ++i;
        }
    }

    private void setPressedCloseButtonIndex(int index) {
        Rectangle r;
        if (this.pressedCloseButtonIndex == index) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            TopComponent tc = (TopComponent)this.getComponentAt(this.pressedCloseButtonIndex);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, tc.getToolTipText());
        }
        this.pressedCloseButtonIndex = index;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int index) {
        Rectangle r;
        if (this.mouseOverCloseButtonIndex == index) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            TopComponent tc = (TopComponent)this.getComponentAt(this.mouseOverCloseButtonIndex);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, tc.getToolTipText());
        }
        this.mouseOverCloseButtonIndex = index;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            r = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            this.repaint(r.x, r.y, r.width + 2, r.height + 2);
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    public String getTitleAt(int tabIndex) {
        int start;
        String title = super.getTitleAt(tabIndex);
        if (plainTabs && (start = title.indexOf(91)) != -1) {
            title = title.substring(0, start);
        }
        return title;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean bl = CLOSE_BUTTON_ENABLED = System.getProperty("netbeans.tab.close.button.enabled") == null ? true : Boolean.getBoolean("netbeans.tab.close.button.enabled");
        TAB_NAME_TRAILING_SPACE = CLOSE_BUTTON_ENABLED ? (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) < 0 ? "   " : "  ") : "";
        closeTabImage = Toolkit.getDefaultToolkit().createImage((class$org$netbeans$core$windows$frames$CloseButtonTabbedPane == null ? (class$org$netbeans$core$windows$frames$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.netbeans.core.windows.frames.CloseButtonTabbedPane")) : class$org$netbeans$core$windows$frames$CloseButtonTabbedPane).getResource("tabclose.gif"));
        closeTabInactiveImage = Toolkit.getDefaultToolkit().createImage((class$org$netbeans$core$windows$frames$CloseButtonTabbedPane == null ? (class$org$netbeans$core$windows$frames$CloseButtonTabbedPane = CloseButtonTabbedPane.class$("org.netbeans.core.windows.frames.CloseButtonTabbedPane")) : class$org$netbeans$core$windows$frames$CloseButtonTabbedPane).getResource("tabcloseinactive.gif"));
        plainTabs = Boolean.getBoolean("netbeans.plaintabs");
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent ev) {
            MouseEvent e = (MouseEvent)ev;
            Component c = (Component)e.getSource();
            while (c != null && !(c instanceof CloseButtonTabbedPane)) {
                c = c.getParent();
            }
            if (c == null) {
                return;
            }
            CloseButtonTabbedPane tab = (CloseButtonTabbedPane)c;
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
            int index = JdkBug4620540Hack.findTabForCoordinate(tab, p.x, p.y);
            Rectangle r = null;
            if (index >= 0) {
                r = tab.getCloseButtonBoundsAt(index);
            }
            if (r == null) {
                r = new Rectangle(0, 0, 0, 0);
            }
            switch (e.getID()) {
                case 501: {
                    if (!r.contains(p)) break;
                    tab.setPressedCloseButtonIndex(index);
                    tab.draggedOut = false;
                    e.consume();
                    return;
                }
                case 502: {
                    if (r.contains(p) && tab.pressedCloseButtonIndex >= 0) {
                        TopComponent tc = (TopComponent)tab.getComponentAt(tab.pressedCloseButtonIndex);
                        tab.reset();
                        tc.close();
                        e.consume();
                        return;
                    }
                    tab.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (r.contains(p)) {
                        tab.setMouseOverCloseButtonIndex(index);
                        tab.draggedOut = false;
                        e.consume();
                        return;
                    }
                    if (tab.mouseOverCloseButtonIndex < 0) break;
                    tab.setMouseOverCloseButtonIndex(-1);
                    tab.draggedOut = false;
                    e.consume();
                    break;
                }
                case 506: {
                    if (tab.pressedCloseButtonIndex < 0) break;
                    if (tab.draggedOut != !r.contains(p)) {
                        tab.draggedOut = !r.contains(p);
                        tab.repaint(r.x, r.y, r.width + 2, r.height + 2);
                    }
                    e.consume();
                    return;
                }
            }
        }
    }
}

