/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.JdkBug4620540Hack;
import org.netbeans.core.windows.frames.CloseButtonTabbedPane;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.openide.awt.MouseUtils;
import org.openide.windows.TopComponent;

class TabHandlePopupListener
implements AWTEventListener {
    private static boolean installed = false;

    private TabHandlePopupListener() {
    }

    static synchronized void install() {
        if (installed) {
            return;
        }
        installed = true;
        Toolkit.getDefaultToolkit().addAWTEventListener(new TabHandlePopupListener(), 16L);
    }

    public void eventDispatched(AWTEvent ev) {
        MouseEvent e = (MouseEvent)ev;
        if (e.getID() != 501 || !MouseUtils.isRightMouseButton((MouseEvent)e)) {
            return;
        }
        Component c = (Component)e.getSource();
        while (c != null && !(c instanceof CloseButtonTabbedPane)) {
            c = c.getParent();
        }
        if (c == null) {
            return;
        }
        final JTabbedPane tab = (JTabbedPane)c;
        while (c != null && !(c instanceof SplitContainerImpl) && !(c instanceof MultiTabbedContainerImpl)) {
            c = c.getParent();
        }
        if (c == null) {
            return;
        }
        final DefaultContainerImpl container = (DefaultContainerImpl)c;
        final TopComponent prevSelected = container.getSelectedTopComponent();
        final Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), tab);
        final int clickTab = JdkBug4620540Hack.findTabForCoordinate(tab, p.x, p.y);
        if (clickTab < 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent selected;
                TopComponent selectedInTab = (TopComponent)tab.getComponentAt(clickTab);
                if (prevSelected != selectedInTab) {
                    container.setSelectedTopComponent(selectedInTab);
                    container.reactivateSelectedComponent();
                }
                if ((selected = (TopComponent)tab.getSelectedComponent()) == null || !selected.equals(TopComponent.getRegistry().getActivated())) {
                    return;
                }
                container.showPopupMenu(container.createPopupMenu(selected), p, tab);
            }
        });
    }
}

