/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceManager;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.TCRef;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInfo;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class TCRefImpl
extends DefaultHandler
implements TCRef,
FileChangeListener,
DeferredPerformer.DeferredCommand,
PropertyChangeListener {
    public static final String INSTANCE_DTD_ID = "-//NetBeans//DTD Top Component in Mode Properties 1.0//EN";
    public static final String INSTANCE_DTD_WWW = "http://www.netbeans.org/dtds/tc-ref1_0.dtd";
    public static final String INSTANCE_DTD_LOCAL = "/org/netbeans/core/windows/resources/tc-ref1_0.dtd";
    private static final String ATT_ID = "id";
    private static final String ATT_CONSTRAINT = "constraint";
    private static final String ATT_STATE = "state";
    private static final String ATT_SELECTED = "selected";
    private static final String ATT_TYPE = "type";
    private String tc_id;
    private int orderWeight = Integer.MAX_VALUE;
    private boolean selected = false;
    private boolean opened = false;
    private String constraint;
    private boolean tc_idChanged = false;
    private boolean selectedChanged = false;
    private boolean constraintChanged = false;
    private boolean openedChanged = false;
    private boolean dataValid;
    private boolean noSectionLoaded;
    private ModeImpl mi;
    private WeakReference tcWeakRef;
    private DataObject producer;
    private boolean shouldParse;
    private boolean propsLoaded;
    private String moduleCodeNameBase;
    private String moduleCodeNameRelease;
    private String moduleSpecificationVersion;
    private PropertyChangeListener weakPropertyChangeL;
    private FileChangeListener weakFileChangeL;
    private final Object RW_LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$TCRefImpl;

    public TCRefImpl(DataObject producer, ModeImpl mi) {
        this.producer = producer;
        this.mi = mi;
        this.shouldParse = true;
        this.weakFileChangeL = WeakListener.fileChange((FileChangeListener)this, (Object)producer.getPrimaryFile());
        producer.getPrimaryFile().addFileChangeListener(this.weakFileChangeL);
    }

    public void performCommand(DeferredPerformer.DeferredContext dc) {
        try {
            TopComponent tc = this.getTopComponent();
            if (tc != null) {
                tc.open(this.mi.getWorkspace());
            }
        }
        catch (SafeException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify(4096, (Throwable)exc);
        }
    }

    public boolean updateMode() throws IOException {
        TopComponent tc;
        this.dataValid = true;
        this.parse();
        if (!this.dataValid || this.noSectionLoaded) {
            return false;
        }
        if (this.moduleCodeNameBase != null) {
            ModuleInfo curModuleInfo = WindowUtils.findModule(this.moduleCodeNameBase, this.moduleCodeNameRelease, this.moduleSpecificationVersion);
            if (curModuleInfo != null && curModuleInfo.isEnabled()) {
                if (this.weakPropertyChangeL == null) {
                    this.weakPropertyChangeL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)curModuleInfo);
                    curModuleInfo.addPropertyChangeListener(this.weakPropertyChangeL);
                }
            } else {
                this.deleteFiles();
                return false;
            }
        }
        if ((tc = this.getTopComponent()) == null) {
            return false;
        }
        this.mi.dockIntoNoSelect(tc, this.constraint, this.getOrderWeight());
        if (this.opened) {
            DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(null, true));
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteFiles() {
        FileObject fo = this.producer.getPrimaryFile();
        FileLock lock = null;
        if (!fo.isValid()) return;
        try {
            try {
                lock = fo.lock();
                fo.delete(lock);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                Object var5_4 = null;
                if (lock == null) return;
                lock.releaseLock();
                return;
            }
            Object var5_3 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    public void destroy() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TCRefImpl.this.deleteFiles();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            ModuleInfo src = (ModuleInfo)evt.getSource();
            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                this.deleteFiles();
            }
        }
    }

    private StringBuffer fillBuffer(TopComponent tc) throws IOException {
        StringBuffer buff = new StringBuffer(800);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        buff.append("<tc-ref version=\"1.0\" id=\"");
        buff.append(XMLUtil.toAttributeValue((String)this.producer.getPrimaryFile().getName()));
        buff.append("\" >\n");
        if (this.moduleCodeNameBase != null) {
            buff.append("    <module");
            buff.append(" name=\"");
            buff.append(this.moduleCodeNameBase);
            if (this.moduleCodeNameRelease != null) {
                buff.append("/" + this.moduleCodeNameRelease);
            }
            if (this.moduleSpecificationVersion != null) {
                buff.append("\" spec=\"");
                buff.append(this.moduleSpecificationVersion);
            }
            buff.append("\" />\n");
        }
        buff.append("    <ui-type type=\"any\" state=\"");
        boolean isOpened = tc.isOpened(this.mi.getWorkspace());
        buff.append(isOpened ? "opened" : "closed");
        ModeImpl modeImpl = this.getModeImpl();
        String constraint = (String)modeImpl.getConstraint(tc);
        if (constraint != null) {
            buff.append("\" constraint=\"");
            buff.append(WindowUtils.convertConstraint2Xml(constraint));
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Constraint is null for topComponent:" + tc + " in mode: " + modeImpl + "!"));
        }
        if (isOpened) {
            TopComponentContainer tcc = this.mi.getContainerInstance();
            buff.append("\" selected=\"");
            if (tcc != null) {
                TopComponentContainer.Area area = tcc.getArea(constraint);
                if (area != null) {
                    buff.append(tc.equals(area.getSelectedTopComponent()) ? "true" : "false");
                } else {
                    buff.append("false");
                }
            } else {
                buff.append("false");
            }
        }
        buff.append("\" />\n");
        buff.append("</tc-ref>\n");
        return buff;
    }

    public void save() throws IOException {
        TopComponent tc = this.getTopComponent();
        if (tc != null) {
            final StringBuffer buff = this.fillBuffer(tc);
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.producer.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock lock;
                        block3: {
                            TCRefImpl.this.noSectionLoaded = false;
                            FileObject foLocal = TCRefImpl.this.producer.getPrimaryFile();
                            lock = foLocal.lock();
                            OutputStreamWriter osw = null;
                            try {
                                OutputStream os = foLocal.getOutputStream(lock);
                                osw = new OutputStreamWriter(os, "UTF-8");
                                osw.write(buff.toString());
                                Object var6_5 = null;
                                if (osw == null) break block3;
                            }
                            catch (Throwable throwable) {
                                Object var6_6 = null;
                                if (osw != null) {
                                    osw.close();
                                }
                                lock.releaseLock();
                                throw throwable;
                            }
                            osw.close();
                        }
                        lock.releaseLock();
                    }
                });
            }
        } else {
            this.deleteFiles();
        }
    }

    public boolean isSynchronized() {
        return false;
    }

    public ModeImpl getModeImpl() {
        return this.mi;
    }

    public TopComponent getTopComponent() throws IOException {
        if (!this.producer.isValid() || !this.producer.getPrimaryFile().isValid()) {
            throw new FileStateInvalidException("Producer is invalid DO:" + this.producer + ", FO:" + this.producer.getPrimaryFile() + ", DO.isValid:" + this.producer.isValid() + ", FO.isValid:" + this.producer.getPrimaryFile().isValid());
        }
        TopComponent tc = null;
        if (this.tcWeakRef == null) {
            if (this.tc_id == null) {
                this.tc_id = this.producer.getPrimaryFile().getName();
            }
            tc = PersistenceManager.getDefault().lookupTCInstance(this.tc_id);
            this.tcWeakRef = new WeakReference<TopComponent>(tc);
        } else {
            tc = (TopComponent)this.tcWeakRef.get();
            if (tc == null) {
                this.deleteFiles();
            }
        }
        return tc;
    }

    public boolean isOpened() throws IOException {
        if (this.shouldParse) {
            this.parse();
        }
        return this.opened;
    }

    public String toString() {
        return this.producer.getPrimaryFile().toString();
    }

    int getOrderWeight() {
        return this.orderWeight;
    }

    Object getConstraint() {
        return this.constraint;
    }

    int setOrderWeight(int orderWeight) {
        this.orderWeight = orderWeight;
        return this.orderWeight;
    }

    public int compareTo(Object obj) {
        return this.getOrderWeight() - ((TCRefImpl)obj).getOrderWeight();
    }

    public DataObject getDataObject() {
        return this.producer;
    }

    void setSynchronized(boolean inSync) {
    }

    public void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        if ("tc-ref".equals(qname)) {
            this.handle_tc_ref(attrs);
        } else if ("ui-type".equals(qname)) {
            this.handle_ui_type(attrs);
        } else if ("module".equals(qname)) {
            this.handleModule(attrs);
        }
    }

    private void handle_tc_ref(Attributes attrs) throws SAXException {
        String value = attrs.getValue(ATT_ID);
        if (value != null) {
            if (!value.equals(this.tc_id)) {
                this.tc_id = value;
                this.tc_idChanged = true;
            }
        } else {
            this.dataValid = false;
            this.log("Error in configuration file. File: " + this.producer.getPrimaryFile().getName() + "  Error: Attribute \"id\" is required.");
            return;
        }
    }

    private void handleModule(Attributes attrs) {
        String moduleCodeName = attrs.getValue("name");
        this.moduleCodeNameBase = null;
        this.moduleCodeNameRelease = null;
        this.moduleSpecificationVersion = null;
        if (moduleCodeName != null) {
            int i = moduleCodeName.indexOf(47);
            if (i != -1) {
                this.moduleCodeNameBase = moduleCodeName.substring(0, i);
                this.moduleCodeNameRelease = moduleCodeName.substring(i + 1);
                TCRefImpl.checkReleaseCode(this);
            } else {
                this.moduleCodeNameBase = moduleCodeName;
            }
            this.moduleSpecificationVersion = attrs.getValue("spec");
        }
    }

    private static void checkReleaseCode(TCRefImpl tcRef) {
        if ("null".equals(tcRef.moduleCodeNameRelease)) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Module release code was saved as null string for module " + tcRef.moduleCodeNameBase + "! Repairing."));
            tcRef.moduleCodeNameRelease = null;
        }
    }

    private void handle_ui_type(Attributes attrs) throws SAXException {
        if (this.propsLoaded) {
            return;
        }
        String value = attrs.getValue(ATT_TYPE);
        if (UIModeManager.getDefault().getUIMode() == WindowUtils.parseUIType(value)) {
            this.propsLoaded = true;
        } else if (!"any".equals(value)) {
            return;
        }
        this.noSectionLoaded = false;
        value = attrs.getValue(ATT_STATE);
        if (value != null) {
            boolean oldOpened = this.opened;
            if (value.equals("opened")) {
                this.opened = true;
            } else if (value.equals("closed")) {
                this.opened = false;
            } else {
                this.log("Value of attribute state in invalid in file " + this.producer.getPrimaryFile().getName() + ", ignoring.");
            }
            boolean bl = this.openedChanged = this.opened != oldOpened;
        }
        if ((value = attrs.getValue(ATT_CONSTRAINT)) != null) {
            if (!value.equals(this.constraint)) {
                this.constraint = WindowUtils.convertConstraint2Perim(value);
                if (this.constraint == null) {
                    this.constraint = "CENTER";
                }
                this.constraintChanged = true;
            }
        } else if (!"center".equals(this.constraint)) {
            this.constraint = "CENTER";
            this.constraintChanged = true;
        }
        if ((value = attrs.getValue(ATT_SELECTED)) != null) {
            if (!value.equals("true") && !value.equals("false")) {
                this.log("Warning in configuration file. File: " + this.producer.getPrimaryFile().getName() + "  Warning: Value \"" + value + "\" for attribute \"selected\" is invalid.");
                this.log("Valid values are: \"true\",\"false\".");
                this.log("Default value \"false\" is set.");
            }
            if (value.equals("true") && !this.selected) {
                this.selected = true;
                this.selectedChanged = true;
            }
            if (value.equals("false") && this.selected) {
                this.selected = false;
                this.selectedChanged = true;
            }
        } else if (this.selected) {
            this.selected = false;
            this.selectedChanged = true;
        }
    }

    private void log(String msg) {
        ErrorManager.getDefault().log(5, msg);
        System.err.println(msg);
    }

    private void parse() throws IOException {
        try {
            try {
                XMLReader parser = XMLUtil.createXMLReader();
                parser.setContentHandler(this);
                parser.setEntityResolver(this);
                parser.setErrorHandler(this.getDefaultErrorHandler());
                Object object = this.RW_LOCK;
                synchronized (object) {
                    InputStream is = this.producer.getPrimaryFile().getInputStream();
                    InputSource input = new InputSource(is);
                    this.propsLoaded = false;
                    this.noSectionLoaded = true;
                    parser.parse(input);
                }
                Object var7_9 = null;
                this.shouldParse = false;
            }
            catch (SAXException ex) {
                ex.printStackTrace();
                String msg = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$TCRefImpl == null ? (class$org$netbeans$core$windows$layers$TCRefImpl = TCRefImpl.class$("org.netbeans.core.windows.layers.TCRefImpl")) : class$org$netbeans$core$windows$layers$TCRefImpl), (String)"EXC_TCRefParse", (Object[])new Object[]{this.producer.getPrimaryFile().getName()});
                IOException ioe = new IOException(msg);
                ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)ex);
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.shouldParse = false;
            throw throwable;
        }
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (INSTANCE_DTD_ID.equals(publicId)) {
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            if (is == null) {
                throw new IllegalStateException("Entity cannot be resolved.");
            }
            return new InputSource(is);
        }
        return null;
    }

    private void fileStd() {
        try {
            if (ICFolderImpl.isListening()) {
                this.updateMode();
            }
        }
        catch (SafeException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public void fileDeleted(FileEvent fe) {
        TopComponent tc;
        TopComponent topComponent = tc = this.tcWeakRef != null ? (TopComponent)this.tcWeakRef.get() : null;
        if (tc != null) {
            ModeImpl mode = (ModeImpl)this.mi.getWorkspace().findMode(tc);
            if (tc.isOpened(this.mi.getWorkspace()) && this.mi.equals(mode)) {
                tc.close(this.mi.getWorkspace());
            }
            if (EventQueue.isDispatchThread()) {
                this.mi.release(tc);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        TCRefImpl.this.mi.release(tc);
                    }
                });
            }
        }
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        this.fileStd();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

