/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import org.w3c.dom.Element;

public class JTabbedPaneMouseEventData
extends AbstractMouseEventData {
    public static final boolean DEFAULT_ISPOPUPTRIGGER = false;
    public static final String DEFAULT_TITLE = "";
    private JTabbedPane m_tabPane;
    private String m_title;
    private int m_tabIndex = -1;

    public JTabbedPaneMouseEventData() {
        this.setValid(false);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, int numberOfClicks) {
        this(testCase, tabPane, tabIndex, DEFAULT_TITLE, numberOfClicks);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, 300L);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, int numberOfClicks, long sleepTime) {
        this(testCase, tabPane, tabIndex, DEFAULT_TITLE, numberOfClicks, sleepTime);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, long sleepTime) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, false, sleepTime);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, tabPane, tabIndex, DEFAULT_TITLE, numberOfClicks, isPopupTrigger);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, isPopupTrigger, 300L);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tabPane, tabIndex, DEFAULT_TITLE, numberOfClicks, isPopupTrigger, sleepTime);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, JTabbedPaneMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, tabPane, tabIndex, title, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JTabbedPaneMouseEventData(JFCTestCase testCase, JTabbedPane tabPane, int tabIndex, String title, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(tabPane);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setTabIndex(tabIndex);
        this.setTitle(title);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setSource(JTabbedPane tabPane) {
        this.m_tabPane = tabPane;
    }

    public final JTabbedPane getSource() {
        return this.m_tabPane;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public final void setTabIndex(int tabIndex) {
        this.m_tabIndex = tabIndex;
    }

    public final int getTabIndex() {
        return this.m_tabIndex;
    }

    public final void setTitle(String title) {
        this.m_title = title;
    }

    public final String getTitle() {
        return this.m_title;
    }

    public boolean canConsume(AWTEvent ae) {
        if (ae.getSource() instanceof JTabbedPane && super.canConsume(ae) && this.sameSource(ae)) {
            MouseEvent me = (MouseEvent)ae;
            if (me.getID() == 504 || me.getID() == 505) {
                return true;
            }
            JTabbedPane tp = (JTabbedPane)me.getSource();
            int index = ((BasicTabbedPaneUI)tp.getUI()).tabForCoordinate(tp, me.getX(), me.getY());
            return this.getTabIndex() == -1 || this.getTabIndex() == index;
        }
        return false;
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        if (me.getClickCount() == 0) {
            return true;
        }
        JTabbedPane source = (JTabbedPane)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        int index = ((BasicTabbedPaneUI)source.getUI()).tabForCoordinate(source, p.x, p.y);
        if (index != -1) {
            this.setTitle(source.getTitleAt(index));
        }
        this.setTabIndex(index);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setSleepTime(this.getDefaultSleepTime());
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JTabbedPaneMouseEventData)) {
            return false;
        }
        JTabbedPaneMouseEventData data = (JTabbedPaneMouseEventData)o;
        return super.equals(o) && data.getTabIndex() == this.getTabIndex() && data.getTitle() == this.getTitle();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JTabbedPaneMouseEventData");
        e.setAttribute("index", DEFAULT_TITLE + this.getTabIndex());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        if (this.m_tabIndex < 0) {
            this.m_tabIndex = this.m_tabPane.indexOfTab(this.getTitle());
        }
        if (this.m_tabPane.getBoundsAt(this.m_tabIndex) == null) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        Rectangle tabPaneRect = this.m_tabPane.getBoundsAt(this.m_tabIndex);
        if (this.getPosition() != 12 && this.m_tabIndex == this.m_tabPane.getTabCount() - 1) {
            this.setPosition(12);
            this.setReferencePoint(new Point(10, tabPaneRect.height / 2));
        }
        if (testCase != null) {
            testCase.flushAWT();
        }
        Point p = this.calculatePoint(tabPaneRect);
        if (!this.m_tabPane.getVisibleRect().contains(p)) {
            Rectangle vis = this.m_tabPane.getVisibleRect();
            Rectangle newView = new Rectangle(p.x - vis.width / 2, p.y - vis.height / 2, vis.width, vis.height);
            this.m_tabPane.scrollRectToVisible(newView);
        }
        Point screen = this.m_tabPane.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" title: " + this.getTitle());
        buf.append(" index: " + this.getTabIndex());
        return buf.toString();
    }
}

