/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import org.w3c.dom.Element;

public class JTableMouseEventData
extends AbstractMouseEventData {
    private JTable m_table;
    private int m_columnIndex;
    private int m_rowIndex;

    public JTableMouseEventData() {
        this.setValid(false);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, 300L);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, long sleepTime) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, false, sleepTime);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, boolean isPopupTrigger) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, isPopupTrigger, 300L);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, boolean isPopupTrigger, long sleepTime) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, JTableMouseEventData.getDefaultModifiers(isPopupTrigger), isPopupTrigger, sleepTime);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 0, null);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, position, null);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, Point referencePoint) {
        this(testCase, table, rowIndex, columnIndex, numberOfClicks, modifiers, isPopupTrigger, sleepTime, 12, referencePoint);
    }

    public JTableMouseEventData(JFCTestCase testCase, JTable table, int rowIndex, int columnIndex, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime, int position, Point referencePoint) {
        this.setTestCase(testCase);
        this.setSource(table);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setRowIndex(rowIndex);
        this.setColumnIndex(columnIndex);
        this.setSleepTime(sleepTime);
        this.setPosition(position);
        this.setReferencePoint(referencePoint);
        this.setValid(true);
    }

    public final void setColumnIndex(int columnIndex) {
        this.m_columnIndex = columnIndex;
    }

    public final int getColumnIndex() {
        return this.m_columnIndex;
    }

    public final void setRowIndex(int rowIndex) {
        this.m_rowIndex = rowIndex;
    }

    public final int getRowIndex() {
        return this.m_rowIndex;
    }

    public final void setSource(JTable table) {
        this.m_table = table;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public JTable getSource() {
        return this.m_table;
    }

    public boolean canConsume(AWTEvent ae) {
        return ae.getSource() instanceof JTable && super.canConsume(ae) && this.sameSource(ae);
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        MouseEvent me = (MouseEvent)ae;
        JTable source = (JTable)me.getSource();
        this.setSource(source);
        this.setModifiers(me.getModifiers());
        this.setNumberOfClicks(me.getClickCount());
        this.setPopupTrigger(me.isPopupTrigger());
        Point p = new Point(me.getX(), me.getY());
        Point screen = source.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        this.setSleepTime(this.getDefaultSleepTime());
        int row = source.rowAtPoint(p);
        int column = source.columnAtPoint(p);
        this.setRowIndex(row);
        this.setColumnIndex(column);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JTableMouseEventData)) {
            return false;
        }
        JTableMouseEventData data = (JTableMouseEventData)o;
        return super.equals(o) && data.getRowIndex() == this.getRowIndex() && data.getColumnIndex() == this.getColumnIndex();
    }

    public int hashCode() {
        return super.hashCode() + this.m_rowIndex * this.m_columnIndex;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("type", "JTableMouseEventData");
        e.setAttribute("row", "" + this.getRowIndex());
        e.setAttribute("column", "" + this.getColumnIndex());
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        JFCTestCase testCase = this.getTestCase();
        if (testCase != null) {
            testCase.flushAWT();
        }
        if (this.m_rowIndex == -1 || this.m_columnIndex == -1) {
            int height = this.m_table.getHeight();
            Dimension vp = this.m_table.getPreferredScrollableViewportSize();
            boolean y = false;
            height = height < vp.height ? (height += (vp.height - height) / 2) : (height /= 2);
            int width = this.m_table.getWidth();
            width = width < vp.width ? (width += (vp.width - width) / 2) : (width /= 2);
            Point p = new Point(width, height);
            Container parent = this.m_table.getParent();
            this.getTestCase().getHelper().enterClickAndLeave(new MouseEventData(this.getTestCase(), parent, this.getNumberOfClicks(), this.getModifiers(), this.getPopupTrigger(), this.getSleepTime(), 12, p));
            return false;
        }
        Rectangle cellRect = this.m_table.getCellRect(this.m_rowIndex, this.m_columnIndex, true);
        if (testCase != null) {
            testCase.flushAWT();
        }
        Point p = this.calculatePoint(cellRect);
        if (!this.m_table.getVisibleRect().contains(p)) {
            Rectangle vis = this.m_table.getVisibleRect();
            Rectangle newView = new Rectangle(p.x - vis.width / 2, p.y - vis.height / 2, vis.width, vis.height);
            this.m_table.scrollRectToVisible(newView);
        }
        Point screen = this.m_table.getLocationOnScreen();
        screen.translate(p.x, p.y);
        this.setLocationOnScreen(screen);
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" row: " + this.getRowIndex());
        buf.append(" column: " + this.getColumnIndex());
        return buf.toString();
    }
}

