/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openarchitectureware.MetamodelContributor;
import org.openarchitectureware.ResourceContributor;
import org.openarchitectureware.core.IOawModelManager;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.builder.OawNature;
import org.openarchitectureware.core.internal.OawModelManager;
import org.openarchitectureware.core.metamodel.MetamodelContributorRegistry;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.PluginExecutionContextImpl;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.internal.OawLog;
import org.openarchitectureware.type.MetaModel;
import org.osgi.framework.BundleContext;

public class OawPlugin
extends AbstractUIPlugin {
    private static final String RESOURCE_CONTRIBUTOR_ID = "org.openarchitectureware.base.resourceContributor";
    public static final String PLUGIN_ID = "org.openarchitectureware.base";
    private static OawPlugin plugin;
    private static HashMap<String, ResourceContributor> contributors;
    private IOawModelManager oawModelManager;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Job job = new Job("Analyzing workspace..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                OawPlugin.getOawModelManager().analyze(monitor);
                            }
                        }.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        OawLog.logError(e);
                    }
                    catch (InterruptedException e) {
                        OawLog.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    };

    public OawPlugin() {
        plugin = this;
        this.oawModelManager = new OawModelManager();
    }

    public static OawPlugin getDefault() {
        return plugin;
    }

    public static ExecutionContext getExecutionContext(IJavaProject project) {
        IOawProject xp = OawPlugin.getOawModelManager().findProject(project.getPath());
        PluginExecutionContextImpl ctx = new PluginExecutionContextImpl(xp, new TypeSystemImpl());
        List<? extends MetamodelContributor> contr = MetamodelContributorRegistry.getActiveMetamodelContributors(project);
        for (MetamodelContributor metamodelContributor : contr) {
            MetaModel[] metamodels = metamodelContributor.getMetamodels(project, (TypeSystem)ctx);
            int i = 0;
            while (i < metamodels.length) {
                ctx.registerMetaModel(metamodels[i]);
                ++i;
            }
        }
        return ctx;
    }

    public static String getId() {
        return OawPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)OawPlugin.getId(), (String)path);
    }

    public static final String getNatureId() {
        return OawNature.NATURE_ID;
    }

    public static IOawModelManager getOawModelManager() {
        return OawPlugin.getDefault().oawModelManager;
    }

    public static ResourceContributor getRegisteredResourceContributorFor(String fileExtension) {
        if (contributors == null) {
            contributors = new HashMap();
            ResourceContributor[] resourceContributorArray = OawPlugin.getRegisteredResourceContributors();
            int n = resourceContributorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor contr = resourceContributorArray[n2];
                contributors.put(contr.getFileExtension(), contr);
                ++n2;
            }
        }
        return contributors.get(fileExtension);
    }

    public static ResourceContributor[] getRegisteredResourceContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(RESOURCE_CONTRIBUTOR_ID);
        HashSet<ResourceContributor> contrs = new HashSet<ResourceContributor>();
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configs = extension.getConfigurationElements();
                int j = 0;
                while (j < configs.length) {
                    IConfigurationElement element = configs[j];
                    try {
                        contrs.add((ResourceContributor)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        OawLog.logError(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return contrs.toArray(new ResourceContributor[contrs.size()]);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final boolean isXtendFile(Object object) {
        if (object instanceof IFile) {
            return "ext".equals(((IFile)object).getFileExtension());
        }
        return false;
    }

    public void start(BundleContext context) throws Exception {
        IProject[] projects;
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener(this.listener);
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                javaProject.getResolvedClasspath(true);
            }
            ++n2;
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener(this.listener);
        plugin = null;
    }
}

