/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.console;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.internal.OawLog;

public class OawConsoleHyperLink
implements IHyperlink {
    private final IResource res;
    private final int start;
    private final int length;
    private int lineNumber;

    public OawConsoleHyperLink(IOawResource res, int start, int length) {
        this.res = res != null && res.getUnderlyingStorage() instanceof IFile ? (IFile)res.getUnderlyingStorage() : null;
        this.start = start;
        this.length = length;
    }

    public OawConsoleHyperLink(IResource res, int start, int length) {
        this.res = res;
        this.start = start;
        this.length = length;
        this.lineNumber = -1;
    }

    public OawConsoleHyperLink(IResource res, int lineNumber) {
        this.res = res;
        Assert.isTrue((lineNumber >= 1 ? 1 : 0) != 0, (String)"Linenumbers must be >= 1");
        this.lineNumber = lineNumber - 1;
        this.start = -1;
        this.length = -1;
    }

    public void linkActivated() {
        if (this.lineNumber == -1) {
            this.revealRange();
        } else {
            this.gotoLine();
        }
    }

    private void revealRange() {
        try {
            IEditorPart opened = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)this.res));
            if (opened instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)opened;
                editor.selectAndReveal(this.start, this.length);
            }
        }
        catch (PartInitException e) {
            OawLog.logError(e);
        }
    }

    private void gotoLine() {
        try {
            IEditorPart opened = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)this.res));
            if (opened instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)opened;
                editor.selectAndReveal(this.start, this.length);
                IWorkbenchPage page = editor.getSite().getPage();
                page.activate((IWorkbenchPart)editor);
            }
        }
        catch (PartInitException e) {
            OawLog.logError(e);
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }
}

