/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.console;

import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.console.OawConsoleHyperLink;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.expression.EvaluationException;

public class OawExceptionConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole fConsole;

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            TextConsole console = this.getConsole();
            String oawFileId = console.getDocument().get(offset, length);
            Matcher m = EvaluationException.P.matcher(oawFileId);
            if (m.find()) {
                offset += m.start();
                length = m.end() - m.start();
                IOawResource res = OawPlugin.getOawModelManager().findOawResource(m.group(1), m.group(2));
                if (res != null) {
                    OawConsoleHyperLink link = new OawConsoleHyperLink(res, (int)Integer.valueOf(m.group(3)), (int)Integer.valueOf(m.group(4)));
                    this.getConsole().addHyperlink((IHyperlink)link, offset, length - 1);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }
}

