/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.core.builder.OawMarkerManager;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOawResource
implements IOawResource {
    private IStorage underlyingFile;
    private Resource resource;
    private boolean hasSemanticErrors = false;

    protected AbstractOawResource(IStorage res) {
        this.underlyingFile = res;
    }

    public void setOawResource(Resource res) {
        this.resource = res;
    }

    @Override
    public Resource getOawResource() {
        if (this.resource == null) {
            this.resource = new StubResource();
        }
        return this.resource;
    }

    @Override
    public IStorage getUnderlyingStorage() {
        return this.underlyingFile;
    }

    public String getFullyQualifiedName() {
        return this.getOawResource().getFullyQualifiedName();
    }

    public String[] getImportedNamespaces() {
        return this.getOawResource().getImportedNamespaces();
    }

    public void setFullyQualifiedName(String fqn) {
        this.getOawResource().setFullyQualifiedName(fqn);
    }

    public String[] getImportedExtensions() {
        return this.getOawResource().getImportedExtensions();
    }

    @Override
    public final void analyze() {
        if (this.getUnderlyingStorage() instanceof IFile) {
            IFile f = (IFile)this.getUnderlyingStorage();
            IJavaProject p = JavaCore.create((IProject)f.getProject());
            ExecutionContext ctx = this.getExecutionContext(p);
            HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
            this.analyze(ctx, issues);
            if (this.hasSemanticErrors) {
                OawMarkerManager.deleteMarkers((IResource)f);
            }
            this.hasSemanticErrors = !issues.isEmpty();
            Iterator iterator = issues.iterator();
            while (iterator.hasNext()) {
                OawMarkerManager.addMarker(f, (AnalysationIssue)iterator.next());
            }
        }
    }

    protected ExecutionContext getExecutionContext(IJavaProject p) {
        return OawPlugin.getExecutionContext(p);
    }

    protected abstract void analyze(ExecutionContext var1, Set<AnalysationIssue> var2);

    @Override
    public final boolean refresh() {
        return this.internalRefresh();
    }

    protected abstract boolean internalRefresh();

    private class StubResource
    implements Resource {
        private String fullyQualifiedName;

        private StubResource() {
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String[] getImportedExtensions() {
            return new String[0];
        }

        public String[] getImportedNamespaces() {
            return new String[0];
        }

        public void setFullyQualifiedName(String fqn) {
            this.fullyQualifiedName = fqn;
        }
    }
}

