/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.builder;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.ResourceContributor;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.core.builder.OawMarkerManager;
import org.openarchitectureware.internal.OawLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawBuilder
extends IncrementalProjectBuilder {
    boolean isOnJavaClassPath(IResource resource) {
        IJavaProject jp = JavaCore.create((IProject)resource.getProject());
        if (jp != null) {
            return jp.isOnClasspath(resource);
        }
        return false;
    }

    public static final String getBUILDER_ID() {
        return String.valueOf(OawPlugin.getId()) + ".oawBuilder";
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        IOawProject p = OawPlugin.getOawModelManager().findProject((IResource)this.getProject());
        p.analyze(monitor);
        return null;
    }

    void reloadResource(IFile resource) {
        IOawResource r;
        IOawProject project;
        if (resource.exists() && (project = OawPlugin.getOawModelManager().findProject((IResource)resource)) != null && (r = project.findOawResource((IStorage)resource)) != null && r.refresh()) {
            resource.getLocalTimeStamp();
        }
    }

    public void handleRemovement(IFile resource) {
        IOawProject project = OawPlugin.getOawModelManager().findProject((IResource)resource);
        if (project != null) {
            project.unregisterOawResource(project.findOawResource((IStorage)resource));
        } else {
            OawLog.logInfo("No oaw project found for " + resource.getProject().getName());
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        IOawProject project = OawPlugin.getOawModelManager().findProject(this.getProject().getFullPath());
        if (project != null) {
            ResourceContributor[] contributors;
            this.getProject().accept((IResourceVisitor)new OawDeltaVisitor(monitor));
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            HashSet<String> extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = OawPlugin.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.isArchive() || root.isExternal()) {
                    boolean closeRoot = false;
                    try {
                        if (!root.isOpen()) {
                            root.open(monitor);
                            closeRoot = true;
                        }
                        this.processExternalResources(project, "", root.getNonJavaResources(), extensions);
                        IJavaElement[] iJavaElementArray = root.getChildren();
                        int n3 = iJavaElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement element = iJavaElementArray[n4];
                            if (element instanceof IPackageFragment) {
                                IPackageFragment fragment = (IPackageFragment)element;
                                String name = fragment.getElementName().replaceAll("\\.", "::");
                                if (name.length() > 0) {
                                    name = String.valueOf(name) + "::";
                                }
                                this.processExternalResources(project, name, fragment.getNonJavaResources(), extensions);
                            }
                            ++n4;
                        }
                    }
                    finally {
                        if (closeRoot) {
                            root.close();
                        }
                    }
                }
                ++i;
            }
        } else {
            OawLog.logInfo("Couldn't create oawproject for project " + this.getProject().getName());
        }
    }

    private void processExternalResources(IOawProject project, String path, Object[] resources, Set<String> extensions) {
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource entry;
            Object resource = objectArray[n2];
            if (resource instanceof IJarEntryResource && (entry = (IJarEntryResource)resource).isFile()) {
                String name = entry.getName();
                for (String ext : extensions) {
                    char dot;
                    if (!name.endsWith(ext) || name.length() <= ext.length() + 1 || (dot = name.charAt(name.length() - ext.length() - 1)) != '.') continue;
                    String fqn = String.valueOf(path) + name.substring(0, name.length() - ext.length() - 1);
                    project.loadOawResource(fqn, ext, true);
                    break;
                }
            }
            ++n2;
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        OawDeltaVisitor visitor = new OawDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
    }

    class OawDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private IProgressMonitor monitor;
        private Set<String> extensions;

        public OawDeltaVisitor(IProgressMonitor monitor) {
            ResourceContributor[] contributors;
            this.monitor = monitor;
            this.extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = OawPlugin.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                this.extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this.isOawResource(resource)) {
                switch (delta.getKind()) {
                    case 1: {
                        OawMarkerManager.deleteMarkers((IResource)((IFile)resource));
                        OawBuilder.this.reloadResource((IFile)resource);
                        break;
                    }
                    case 2: {
                        OawBuilder.this.handleRemovement((IFile)resource);
                        break;
                    }
                    case 4: {
                        OawBuilder.this.reloadResource((IFile)resource);
                    }
                }
            }
            this.monitor.worked(1);
            return true;
        }

        private boolean isOawResource(IResource resource) {
            return resource instanceof IFile && this.extensions.contains(((IFile)resource).getFileExtension()) && OawBuilder.this.isOnJavaClassPath(resource);
        }

        public boolean visit(IResource resource) {
            if (this.isOawResource(resource)) {
                OawBuilder.this.reloadResource((IFile)resource);
            }
            this.monitor.worked(1);
            return true;
        }
    }
}

