/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.builder;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.internal.OawLog;

public class OawMarkerManager {
    static final String getMARKER_TYPE() {
        return String.valueOf(OawPlugin.getId()) + ".problem";
    }

    public static void addMarker(IFile file, AnalysationIssue issue) {
        try {
            IMarker marker = file.createMarker(OawMarkerManager.getMARKER_TYPE());
            int severity = issue.isWarning() ? 1 : 2;
            int start = -1;
            int end = -1;
            if (issue.getElement() != null) {
                start = issue.getElement().getStart();
                end = issue.getElement().getEnd();
            }
            OawMarkerManager.internalAddMarker(file, marker, issue.getMessage(), severity, start, end);
        }
        catch (CoreException coreException) {}
    }

    public static void addErrorMarker(IFile file, String message, int severity, int start, int end) {
        try {
            IMarker marker = file.createMarker(OawMarkerManager.getMARKER_TYPE());
            OawMarkerManager.internalAddMarker(file, marker, message, severity, start, end);
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
    }

    public static void addWarningMarker(IFile file, String message, int severity, int start, int end) {
        try {
            IMarker marker = file.createMarker(OawMarkerManager.getMARKER_TYPE());
            OawMarkerManager.internalAddMarker(file, marker, message, severity, start, end);
        }
        catch (CoreException coreException) {}
    }

    private static final void internalAddMarker(final IFile file, final IMarker marker, final String message, final int severity, final int start, final int end) {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    block9: {
                        try {
                            marker.setAttribute("message", (Object)message);
                            marker.setAttribute("severity", severity);
                            int s = start;
                            if (start == -1) {
                                s = 1;
                            }
                            int e = end;
                            if (end <= start) {
                                e = start + 1;
                            }
                            marker.setAttribute("charStart", s);
                            marker.setAttribute("charEnd", e);
                            ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
                            if (mgr == null) break block9;
                            IPath location = file.getFullPath();
                            try {
                                mgr.connect(location, (IProgressMonitor)new NullProgressMonitor());
                                ITextFileBuffer buff = mgr.getTextFileBuffer(file.getFullPath());
                                if (buff != null) {
                                    IDocument doc = buff.getDocument();
                                    int line = doc.getLineOfOffset(start);
                                    marker.setAttribute("lineNumber", doc.getLineOfOffset(start));
                                    marker.setAttribute("location", (Object)("line: " + ++line));
                                }
                            }
                            finally {
                                mgr.disconnect(location, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException e) {
                            OawLog.logError(e);
                        }
                        catch (BadLocationException e) {
                            OawLog.logError(e);
                        }
                    }
                }
            }.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            OawLog.logError(e);
        }
    }

    public static void deleteMarkers(final IResource file) {
        try {
            if (file.exists()) {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        file.deleteMarkers(OawMarkerManager.getMARKER_TYPE(), true, 2);
                    }
                }.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ce) {
            OawLog.logError(ce);
        }
    }
}

