/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.internal;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.openarchitectureware.core.internal.OawResourceID;
import org.openarchitectureware.internal.OawLog;

public class JDTUtil {
    private static final Pattern patternNamespace = Pattern.compile("::");
    private static final Pattern patternSlash = Pattern.compile("/");

    public static IStorage findStorage(IJavaProject project, OawResourceID id, boolean searchJars) {
        IPath p = JDTUtil.path(id);
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IStorage storage;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!root.isArchive() && !root.isExternal()) {
                    IResource res = root.getUnderlyingResource();
                    IResource r = null;
                    if (res != null) {
                        r = project.getProject().findMember(res.getProjectRelativePath().append(p));
                    }
                    if (r instanceof IFile) {
                        return (IFile)r;
                    }
                } else if (searchJars && (storage = JDTUtil.loadFromJar(id, root)) != null) {
                    return storage;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            OawLog.logInfo(e);
        }
        return null;
    }

    public static IStorage loadFromJar(OawResourceID id, IPackageFragmentRoot root) throws JavaModelException {
        Object[] resources;
        String[] elements = id.toString().split("::");
        StringBuilder pathBuilder = new StringBuilder();
        int i = 0;
        while (i < elements.length - 1) {
            if (i > 0) {
                pathBuilder.append(".");
            }
            pathBuilder.append(elements[i]);
            ++i;
        }
        String path = pathBuilder.toString();
        String fileName = elements[elements.length - 1];
        if (path.length() > 0) {
            IPackageFragment fragment = root.getPackageFragment(path);
            if (fragment == null || !fragment.exists()) {
                return null;
            }
            resources = fragment.getNonJavaResources();
        } else {
            resources = root.getNonJavaResources();
        }
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource entry;
            Object resource = objectArray[n2];
            if (resource instanceof IJarEntryResource && (entry = (IJarEntryResource)resource).isFile() && entry.getName().equals(fileName)) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public static OawResourceID findOawResourceID(IJavaProject project, IStorage file) {
        if (file == null) {
            return null;
        }
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = project.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getPath().isPrefixOf(file.getFullPath())) {
                    IPath shortOne = file.getFullPath().removeFirstSegments(root.getPath().segmentCount()).setDevice(null);
                    String ns = shortOne.removeFileExtension().toString();
                    ns = patternSlash.matcher(ns).replaceAll("::");
                    return new OawResourceID(ns, shortOne.getFileExtension());
                }
                ++n2;
            }
        }
        catch (JavaModelException e1) {
            OawLog.logInfo(e1);
        }
        return null;
    }

    public static IJavaProject getJProject(IStorage s) {
        IProject[] projects;
        if (s instanceof IFile) {
            return JavaCore.create((IProject)((IFile)s).getProject());
        }
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IJavaProject p = JavaCore.create((IProject)project);
            if (p.exists()) {
                try {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = p.getPackageFragmentRoots();
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        if (root.getPath().isPrefixOf(s.getFullPath())) {
                            return p;
                        }
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    OawLog.logError(e);
                }
            }
            ++n2;
        }
        return null;
    }

    private static IPath path(OawResourceID id) {
        return new Path(String.valueOf(patternNamespace.matcher(id.name).replaceAll("/")) + "." + id.extension);
    }

    public static String getQualifiedName(IStorage source) {
        OawResourceID id = JDTUtil.findOawResourceID(JDTUtil.getJProject(source), source);
        if (id != null) {
            return id.name;
        }
        return null;
    }
}

