/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.internal;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.openarchitectureware.core.IOawModelManager;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.core.builder.OawNature;
import org.openarchitectureware.core.internal.OawProject;
import org.openarchitectureware.internal.OawLog;
import org.openarchitectureware.workflow.util.Cache;

public class OawModelManager
implements IOawModelManager {
    public final Cache<IJavaProject, OawProject> projects = new Cache<IJavaProject, OawProject>(){

        protected OawProject createNew(IJavaProject ele) {
            return new OawProject(ele);
        }
    };

    public IOawProject findProject(IPath path) {
        return this.findProject(ResourcesPlugin.getWorkspace().getRoot().findMember(path));
    }

    public IOawProject findProject(IResource res) {
        if (res == null) {
            return null;
        }
        IJavaProject ele = JavaCore.create((IProject)res.getProject());
        try {
            if (ele != null && res.getProject().isAccessible() && res.getProject().isNatureEnabled(OawNature.NATURE_ID)) {
                return (IOawProject)this.projects.get((Object)ele);
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        return null;
    }

    public void analyze(IProgressMonitor monitor) {
        monitor.beginTask("Analyzing oAW4 projects...", this.computeAmoutOfWork());
        Iterator iter = this.projects.getValues().iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ((IOawProject)iter.next()).analyze(monitor);
        }
        monitor.done();
    }

    private int computeAmoutOfWork() {
        int i = 0;
        for (IOawProject element : this.projects.getValues()) {
            i += element.getRegisteredResources().length;
        }
        return i;
    }

    public IOawResource findOawResource(IStorage file) {
        if (!(file instanceof IFile)) {
            for (IOawProject p : this.projects.getValues()) {
                IOawResource res = p.findOawResource(file);
                if (res == null) continue;
                return res;
            }
        } else {
            IOawProject project = this.findProject((IResource)((IFile)file));
            if (project != null) {
                return project.findOawResource(file);
            }
        }
        return null;
    }

    public IOawResource findOawResource(String oawNamespace, String extension) {
        for (IOawProject p : this.projects.getValues()) {
            IOawResource res = p.findOawResource(oawNamespace, extension);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

