/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.metamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.openarchitectureware.MetamodelContributor;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.metamodel.Contributor;
import org.openarchitectureware.internal.OawLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelContributorRegistry {
    private static final String CONTRIBUTOR_ID = "org.openarchitectureware.base.metamodelContributor";
    private static Map<String, Contributor> contributors = null;

    public static Map<String, Contributor> getRegisteredMetamodelContributors() {
        if (contributors == null) {
            contributors = new HashMap<String, Contributor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(CONTRIBUTOR_ID);
            if (point != null) {
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    IConfigurationElement[] configs = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configs.length) {
                        IConfigurationElement element = configs[j];
                        String label = element.getAttribute("name");
                        String className = element.getAttribute("class");
                        Contributor contributor = new Contributor(label, className, element, false);
                        contributors.put(className, contributor);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return contributors;
    }

    public static List<? extends MetamodelContributor> getActiveMetamodelContributors(IJavaProject project) {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), OawPlugin.getId());
        IScopeContext[] scopes = new IScopeContext[]{new ProjectScope(project.getProject()), new InstanceScope()};
        scopedPreferenceStore.setSearchContexts(scopes);
        MetamodelContributorRegistry.fixMetamodelContributorPreferences((IPreferenceStore)scopedPreferenceStore);
        String metamodelContr = scopedPreferenceStore.getString("metamodelContributor");
        String[] mm = metamodelContr.split(",");
        ArrayList<MetamodelContributor> result = new ArrayList<MetamodelContributor>();
        String[] stringArray = mm;
        int n = mm.length;
        int n2 = 0;
        while (n2 < n) {
            String metamodelContributorName = stringArray[n2];
            if (metamodelContributorName != null && !metamodelContributorName.equals("")) {
                MetamodelContributor metamodelContributor = MetamodelContributorRegistry.getMetamodelContributorByClassName(metamodelContributorName);
                if (metamodelContributor != null) {
                    result.add(metamodelContributor);
                } else {
                    OawLog.logInfo("Metamodel contributor '" + metamodelContributorName + "' is not available\n");
                }
            }
            ++n2;
        }
        return result;
    }

    private static void fixMetamodelContributorPreferences(IPreferenceStore prefStore) {
        String metamodelContr = prefStore.getString("metamodelContributor");
        if (metamodelContr.indexOf("openarchitecturware") > 0) {
            metamodelContr = metamodelContr.replace("openarchitecturware", "openarchitectureware");
            prefStore.setValue("metamodelContributor", metamodelContr);
        }
    }

    private static MetamodelContributor getMetamodelContributorByClassName(String metamodelContr) {
        Contributor contributor = MetamodelContributorRegistry.getRegisteredMetamodelContributors().get(metamodelContr);
        if (contributor == null) {
            return null;
        }
        return contributor.getMetaModelContributor();
    }
}

