/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.search;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.core.search.SearchMatch;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.expression.ast.OperationCall;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.internal.OawLog;
import org.openarchitectureware.xpand2.ast.Definition;
import org.openarchitectureware.xpand2.ast.ExpandStatement;
import org.openarchitectureware.xpand2.ast.Template;
import org.openarchitectureware.xpand2.model.XpandDefinition;
import org.openarchitectureware.xtend.ast.AbstractExtension;
import org.openarchitectureware.xtend.ast.Extension;
import org.openarchitectureware.xtend.ast.ExtensionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawSearchEngine {
    public static List<Definition> findAllDefines(IOawProject project) {
        IOawResource[] resources;
        ArrayList<Definition> matches = new ArrayList<Definition>();
        IOawResource[] iOawResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IOawResource res = iOawResourceArray[n2];
            if (res.getOawResource() instanceof Template) {
                Template tpl = (Template)res.getOawResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition) {
                        Definition def = (Definition)xdef;
                        matches.add(def);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return matches;
    }

    public static List<SearchMatch> findAllOccurrences(IOawProject project, String identifier) {
        IOawResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IOawResource[] iOawResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IOawResource res = iOawResourceArray[n2];
            if (res.getOawResource() instanceof Template) {
                Template tpl = (Template)res.getOawResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        int startOfDefnitionName = def.getDefName().getStart() - 1;
                        int lengthOfDefinitionName = def.getDefName().getEnd() - def.getDefName().getStart();
                        matches.add(new SearchMatch(startOfDefnitionName, lengthOfDefinitionName, res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            Set<ExpandStatement> ops = OawSearchEngine.findRec(res.getOawResource(), ExpandStatement.class, new HashSet<Object>());
            for (ExpandStatement expr : ops) {
                Identifier definition = expr.getDefinition();
                String definitionFQN = definition.getValue();
                int lastIndexOf = definitionFQN.lastIndexOf(identifier);
                if (lastIndexOf <= -1) continue;
                int startOfDefinition = definition.getStart() + lastIndexOf - 1;
                int lengthOfDefinition = identifier.length();
                matches.add(new SearchMatch(startOfDefinition, lengthOfDefinition, res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iOawResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iOawResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IOawResource p = iOawResourceArray[n2];
            IOawProject oawp = OawPlugin.getOawModelManager().findProject((IResource)p);
            if (oawp != null) {
                matches.addAll(OawSearchEngine.findAllOccurrences(oawp, identifier));
            }
            ++n2;
        }
        return OawSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findReferences(IOawProject project, String identifier) {
        IOawResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IOawResource[] iOawResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IOawResource res = iOawResourceArray[n2];
            Set<OperationCall> ops = OawSearchEngine.findRec(res.getOawResource(), OperationCall.class, new HashSet<Object>());
            for (OperationCall expr : ops) {
                if (!expr.getName().getValue().equals(identifier)) continue;
                int start = expr.getName().getStart();
                int end = expr.getName().getEnd();
                int length = end - start + 1;
                if (res.getOawResource() instanceof Template) {
                    --length;
                }
                matches.add(new SearchMatch(start, length, res.getUnderlyingStorage()));
            }
            ++n2;
        }
        iOawResourceArray = project.getProject().getProject().getReferencingProjects();
        n = iOawResourceArray.length;
        n2 = 0;
        while (n2 < n) {
            IOawResource p = iOawResourceArray[n2];
            IOawProject oawp = OawPlugin.getOawModelManager().findProject((IResource)p);
            if (oawp != null) {
                matches.addAll(OawSearchEngine.findReferences(oawp, identifier));
            }
            ++n2;
        }
        return OawSearchEngine.sort(matches);
    }

    public static List<SearchMatch> findDeclarations(IOawProject project, String identifier) {
        IOawResource[] resources;
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>();
        IOawResource[] iOawResourceArray = resources = project.getRegisteredResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IOawResource res = iOawResourceArray[n2];
            if (res.getOawResource() instanceof ExtensionFile) {
                ExtensionFile ef = (ExtensionFile)res.getOawResource();
                for (Extension ext : ef.getExtensions()) {
                    if (!(ext instanceof AbstractExtension)) continue;
                    AbstractExtension ae = (AbstractExtension)ext;
                    if (!ext.getName().equals(identifier)) continue;
                    Identifier id = ae.getNameIdentifier();
                    int start = id.getStart();
                    int end = id.getEnd();
                    int length = end - start + 1;
                    matches.add(new SearchMatch(start, length, res.getUnderlyingStorage()));
                }
            }
            if (res.getOawResource() instanceof Template) {
                Template tpl = (Template)res.getOawResource();
                XpandDefinition[] xpandDefinitionArray = tpl.getDefinitions();
                int n3 = xpandDefinitionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Definition def;
                    XpandDefinition xdef = xpandDefinitionArray[n4];
                    if (xdef instanceof Definition && (def = (Definition)xdef).getName().equals(identifier)) {
                        matches.add(new SearchMatch(def.getDefName().getStart(), def.getDefName().getEnd() - def.getDefName().getStart(), res.getUnderlyingStorage()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        try {
            iOawResourceArray = project.getProject().getProject().getReferencedProjects();
            n = iOawResourceArray.length;
            n2 = 0;
            while (n2 < n) {
                IOawResource p = iOawResourceArray[n2];
                IOawProject oawp = OawPlugin.getOawModelManager().findProject((IResource)p);
                if (oawp != null) {
                    matches.addAll(OawSearchEngine.findDeclarations(oawp, identifier));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        return OawSearchEngine.sort(matches);
    }

    private static List<SearchMatch> sort(List<SearchMatch> searchmatches) {
        Collections.sort(searchmatches, new Comparator<SearchMatch>(){

            @Override
            public int compare(SearchMatch o1, SearchMatch o2) {
                if (o1.getFile() == null) {
                    return -1;
                }
                if (o2.getFile() == null) {
                    return 1;
                }
                int fileCompare = o1.getFile().getName().compareTo(o2.getFile().getName());
                if (fileCompare == 0) {
                    return Integer.valueOf(o1.getOffSet()).compareTo(o2.getOffSet());
                }
                return fileCompare;
            }
        });
        return searchmatches;
    }

    private static <T extends SyntaxElement> Set<T> findRec(Object res, Class<T> clazz, Set<Object> visitedNodes) {
        Method[] methods;
        if (visitedNodes.contains(res)) {
            return Collections.emptySet();
        }
        visitedNodes.add(res);
        HashSet<Object> result = new HashSet<Object>();
        if (clazz.isInstance(res)) {
            result.add((SyntaxElement)res);
        }
        Class<?> instanceClass = res.getClass();
        Method[] methodArray = methods = instanceClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> pType;
            Method method = methodArray[n2];
            int mod = method.getModifiers();
            if (Modifier.isPublic(mod) && !Modifier.isStatic(mod) && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && (Collection.class.isAssignableFrom(pType = method.getReturnType()) || SyntaxElement.class.isAssignableFrom(pType))) {
                try {
                    Object invRes = method.invoke(res, new Object[0]);
                    if (invRes instanceof Collection) {
                        for (Object o : (Collection)invRes) {
                            result.addAll(OawSearchEngine.findRec(o, clazz, visitedNodes));
                        }
                    } else if (invRes != null) {
                        result.addAll(OawSearchEngine.findRec(invRes, clazz, visitedNodes));
                    }
                }
                catch (Exception e) {
                    OawLog.logError(e);
                }
            }
            ++n2;
        }
        return result;
    }
}

