/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.editor.navigation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openarchitectureware.core.search.SearchMatch;
import org.openarchitectureware.internal.OawLog;

public class GenericHyperlink
implements IHyperlink {
    private final String identifierString;
    private final IRegion region;
    private final IWorkbenchPage workbenchPage;
    private final SearchMatch searchMatch;

    public GenericHyperlink(IWorkbenchPage workbenchPage, SearchMatch searchMatch, IRegion region, String identifierString) {
        Assert.isNotNull((Object)workbenchPage);
        Assert.isNotNull((Object)identifierString);
        Assert.isNotNull((Object)region);
        this.workbenchPage = workbenchPage;
        this.region = region;
        this.identifierString = identifierString;
        this.searchMatch = searchMatch;
    }

    public void open() {
        try {
            IEditorPart opened;
            if (this.searchMatch.getFile() != null && (opened = IDE.openEditor((IWorkbenchPage)this.workbenchPage, (IFile)this.searchMatch.getFile())) instanceof ITextEditor) {
                ((ITextEditor)opened).selectAndReveal(this.searchMatch.getOffSet(), this.searchMatch.getLength());
            }
        }
        catch (PartInitException e) {
            OawLog.logError(e);
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return this.identifierString;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public String toString() {
        String result = "Hyperlink (" + this.identifierString + ")";
        if (this.searchMatch != null) {
            result = String.valueOf(result) + " [" + this.searchMatch.getOffSet() + ", " + this.searchMatch.getLength() + "]";
        }
        return "Hyperlink (" + this.identifierString + ")";
    }
}

