/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.editor.navigation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.search.OawSearchEngine;
import org.openarchitectureware.core.search.SearchMatch;
import org.openarchitectureware.editor.navigation.GenericHyperlink;
import org.openarchitectureware.editor.navigation.WordDetector;

public class GenericHyperlinkDetector
implements IHyperlinkDetector {
    private final IEditorPart editor;

    public GenericHyperlinkDetector(IEditorPart editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IRegion hyperlinkRegion = this.getHyperlinkRegion(textViewer, region.getOffset());
        if (hyperlinkRegion == null) {
            return null;
        }
        String hyperlinkedWord = textViewer.getDocument().get().substring(hyperlinkRegion.getOffset(), hyperlinkRegion.getOffset() + hyperlinkRegion.getLength());
        if (hyperlinkedWord == null || "".equals(hyperlinkedWord.trim())) {
            return null;
        }
        IOawProject project = this.getOawProject();
        if (project != null) {
            List<SearchMatch> matches = OawSearchEngine.findDeclarations(project, hyperlinkedWord);
            ArrayList<GenericHyperlink> links = new ArrayList<GenericHyperlink>();
            for (SearchMatch searchMatch : matches) {
                GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), searchMatch, hyperlinkRegion, hyperlinkedWord);
                links.add(genericHyperlink);
            }
            if (!links.isEmpty()) {
                if (canShowMultipleHyperlinks) {
                    return links.toArray(new IHyperlink[links.size()]);
                }
                return new IHyperlink[]{(IHyperlink)links.get(0)};
            }
        }
        return null;
    }

    private IWorkbenchPage getWorkbenchPage() {
        return this.editor.getSite().getWorkbenchWindow().getActivePage();
    }

    private IOawProject getOawProject() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return OawPlugin.getOawModelManager().findProject((IResource)file);
    }

    private IFile getFile() {
        return (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
    }

    private IRegion getHyperlinkRegion(ITextViewer textViewer, int offset) {
        String currDoc = textViewer.getDocument().get();
        if (offset == currDoc.length()) {
            return null;
        }
        int start = offset;
        while (start > -1 && WordDetector.isWordPart(currDoc.charAt(start))) {
            --start;
        }
        ++start;
        int end = offset;
        while (end < currDoc.length() && WordDetector.isWordPart(currDoc.charAt(end))) {
            ++end;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        return new Region(start, end - start);
    }
}

