/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.editor.search.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.action.SelectionDispatchAction;
import org.openarchitectureware.editor.AbstractOawEditor;

public abstract class FindAction
extends SelectionDispatchAction {
    private AbstractOawEditor editor;

    protected FindAction(IWorkbenchSite site) {
        super(site);
        this.init();
    }

    protected FindAction(AbstractOawEditor editor) {
        this((IWorkbenchSite)editor.getSite());
        this.editor = editor;
    }

    abstract void init();

    protected IOawProject getOawProject() {
        IFile file = this.getActiveFile();
        if (file == null) {
            return null;
        }
        return OawPlugin.getOawModelManager().findProject((IResource)file);
    }

    protected IFile getActiveFile() {
        return (IFile)this.getEditor().getEditorInput().getAdapter(IFile.class);
    }

    public AbstractOawEditor getEditor() {
        return this.editor;
    }

    public void run(ITextSelection selection) {
        String selectedText = selection.getText();
        IOawProject project = this.getOawProject();
        ISearchQuery query = this.createSearchQuery(selectedText, project);
        NewSearchUI.runQuery((ISearchQuery)query);
    }

    protected abstract ISearchQuery createSearchQuery(String var1, IOawProject var2);
}

