/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.editor.codeassist;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.openarchitectureware.expression.TypeNameUtil;
import org.openarchitectureware.expression.ast.DeclaredParameter;
import org.openarchitectureware.expression.codeassist.ProposalFactory;
import org.openarchitectureware.expression.editor.EditorImages;
import org.openarchitectureware.expression.editor.codeassist.TextSelectingProposal;
import org.openarchitectureware.type.Operation;
import org.openarchitectureware.type.ParameterizedType;
import org.openarchitectureware.type.Property;
import org.openarchitectureware.type.StaticProperty;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xpand2.XpandUtil;
import org.openarchitectureware.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProposalFactoryEclipseImpl
implements ProposalFactory {
    public int offset;

    public ProposalFactoryEclipseImpl(int offset) {
        this.offset = offset;
    }

    public Object createCollectionSpecificOperationProposal(String insertString, String displayString, String prefix, int cursor, int marked) {
        String displayStr = displayString;
        String insertStr = insertString;
        Image img = EditorImages.getImage("operation.gif");
        return new TextSelectingProposal(insertStr, this.offset - prefix.length(), prefix.length(), cursor, marked, img, displayStr, null, null);
    }

    public Object createPropertyProposal(Property p, String prefix, boolean onOperation) {
        String returnType = this.computeReturnType(p.getReturnType(), onOperation);
        String displayStr = String.valueOf(p.getName()) + " " + returnType + " - " + TypeNameUtil.getSimpleName((String)p.getOwner().getName());
        String insertStr = p.getName();
        Image img = EditorImages.getImage("property.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createStaticPropertyProposal(StaticProperty p, String prefix, boolean onOperation) {
        String returnType = this.computeReturnType(p.getReturnType(), onOperation);
        String displayStr = String.valueOf(p.getName()) + " " + returnType + " - " + TypeNameUtil.getSimpleName((String)p.getOwner().getName());
        String insertStr = p.getName();
        Image img = EditorImages.getImage("staticproperty.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    private String computeReturnType(Type returnType, boolean onOperation) {
        if (returnType == null) {
            return "unknown";
        }
        if (onOperation) {
            if (returnType instanceof ParameterizedType) {
                returnType = ((ParameterizedType)returnType).getInnerType();
            }
            return "List[" + XpandUtil.getLastSegment((String)returnType.getName()) + "]";
        }
        return TypeNameUtil.getSimpleName((String)returnType.getName());
    }

    public Object createOperationProposal(Operation p, String prefix, boolean onOperation) {
        String returnType = this.computeReturnType(p.getReturnType(), onOperation);
        String displayStr = String.valueOf(p.getName()) + this.toParamString(p.getParameterTypes()) + " " + returnType + " - " + TypeNameUtil.getSimpleName((String)p.getOwner().getName());
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getParameterTypes().size() > 0) {
            --x;
        }
        Image img = EditorImages.getImage("operation.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, img, displayStr, null, null);
    }

    public Object createExtensionProposal(Extension p, String prefix) {
        String displayStr = String.valueOf(p.getName()) + this.toParamString(p, false);
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getFormalParameters().size() > 0) {
            --x;
        }
        Image img = EditorImages.getImage("extension.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, img, displayStr, null, null);
    }

    public Object createExtensionOnMemberPositionProposal(Extension p, String prefix, boolean onOperation) {
        String displayStr = String.valueOf(p.getName()) + this.toParamString(p, true) + " - " + ((DeclaredParameter)p.getFormalParameters().get(0)).getType();
        String insertStr = String.valueOf(p.getName()) + "()";
        int x = insertStr.length();
        if (p.getFormalParameters().size() > 1) {
            --x;
        }
        Image img = EditorImages.getImage("extension.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), x, img, displayStr, null, null);
    }

    private String toParamString(List<Type> parameterTypes) {
        StringBuffer b = new StringBuffer("(");
        int i = 0;
        int x = parameterTypes.size();
        while (i < x) {
            b.append(TypeNameUtil.getSimpleName((String)parameterTypes.get(i).getName()));
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    private String toParamString(Extension p, boolean member) {
        StringBuffer b = new StringBuffer("(");
        int i = member ? 1 : 0;
        int x = p.getFormalParameters().size();
        while (i < x) {
            b.append(((DeclaredParameter)p.getFormalParameters().get(i)).toString());
            if (i + 1 < x) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public Object createVariableProposal(String name, Type t, String prefix) {
        String displayStr = String.valueOf(name) + " " + this.computeReturnType(t, false);
        String insertStr = name;
        Image img = EditorImages.getImage("variable.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createTypeProposal(String insertString, Type type, String prefix) {
        String displayStr = TypeNameUtil.getSimpleName((String)type.getName());
        String packName = TypeNameUtil.withoutLastSegment((String)type.getName());
        if (packName != null) {
            displayStr = String.valueOf(displayStr) + " - " + packName;
        }
        String insertStr = insertString;
        Image img = EditorImages.getImage("type.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createExtensionImportProposal(String insertStr, String displayStr, String prefix, int cursor, int marked) {
        Image img = EditorImages.getImage("import_ext.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createNamespaceProposal(String insertStr, String displayStr, String prefix) {
        Image img = EditorImages.getImage("package.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createDefinitionProposal(String insertStr, String displayStr, String prefix) {
        Image img = EditorImages.getImage("xpand_define.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createStatementProposal(String insertStr, String displayStr, String prefix, int cursor, int marked) {
        Image img = EditorImages.getImage("import_ext.gif");
        return new CompletionProposal(insertStr, this.offset - prefix.length(), prefix.length(), insertStr.length(), img, displayStr, null, null);
    }

    public Object createStatementProposal(String insertString, String displayString, String prefix) {
        throw new UnsupportedOperationException();
    }

    public Object createKeywordProposal(String insertString, String displayString, String prefix) {
        throw new UnsupportedOperationException();
    }

    public boolean isDuplicate(Set<String> nameCache, Object proposal) {
        if (nameCache == null || proposal == null) {
            throw new IllegalArgumentException();
        }
        CompletionProposal p = this.castToProposal(proposal);
        if (p != null) {
            return nameCache.contains(p.getDisplayString());
        }
        return true;
    }

    public void addToCache(Set<String> nameCache, Object proposal) {
        CompletionProposal p = this.castToProposal(proposal);
        if (p != null) {
            nameCache.add(p.getDisplayString());
        }
    }

    private CompletionProposal castToProposal(Object obj) {
        if (obj instanceof CompletionProposal) {
            return (CompletionProposal)obj;
        }
        return null;
    }
}

